/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.external.admin;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.query.Query;
import org.jahia.modules.external.ExternalContentStoreProvider;
import org.jahia.modules.external.ExternalDataSource;
import org.jahia.modules.external.ExternalProviderInitializerService;
import org.jahia.modules.external.ExternalQuery;
import org.jahia.modules.external.admin.DataSourceInfo;
import org.jahia.modules.external.admin.MountInfo;
import org.jahia.services.content.JCRStoreService;
import org.jahia.services.content.ProviderFactory;
import org.jahia.services.content.QueryManagerWrapper;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.query.QueryWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ExternalProviderAdminFlow
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(ExternalProviderAdminFlow.class);
    private transient JCRStoreService jcrStoreService;
    private transient ExternalProviderInitializerService initializationService;

    @Autowired
    public void setInitializationService(ExternalProviderInitializerService initializationService) {
        this.initializationService = initializationService;
    }

    @Autowired
    public void setJcrStoreService(JCRStoreService jcrStoreService) {
        this.jcrStoreService = jcrStoreService;
    }

    public List<MountInfo> getMountedProviders() throws RepositoryException {
        ArrayList<MountInfo> l = new ArrayList<MountInfo>();
        HashMap<String, DataSourceInfo> infos = new HashMap<String, DataSourceInfo>();
        for (Map.Entry entry : this.jcrStoreService.getSessionFactory().getMountPoints().entrySet()) {
            if (!(entry.getValue() instanceof ExternalContentStoreProvider)) continue;
            ExternalContentStoreProvider jcrStoreProvider = (ExternalContentStoreProvider)((Object)entry.getValue());
            MountInfo m = new MountInfo();
            m.setKey(jcrStoreProvider.getKey());
            m.setId(this.initializationService.getProviderId(jcrStoreProvider.getKey()));
            m.setMountPoint((String)entry.getKey());
            ExternalDataSource dataSource = jcrStoreProvider.getDataSource();
            if (!infos.containsKey(dataSource.getClass().getName())) {
                DataSourceInfo p = this.getBaseDataSourceInfo(dataSource);
                infos.put(dataSource.getClass().getName(), p);
            }
            m.setDataSource((DataSourceInfo)infos.get(dataSource.getClass().getName()));
            m.setDynamic(jcrStoreProvider.isDynamicallyMounted());
            l.add(m);
        }
        return l;
    }

    private DataSourceInfo getBaseDataSourceInfo(ExternalDataSource dataSource) {
        DataSourceInfo info = new DataSourceInfo();
        info.setClazz(dataSource.getClass().getName());
        info.setSearchable(dataSource instanceof ExternalDataSource.Searchable);
        info.setSupportsLazy(dataSource instanceof ExternalDataSource.LazyProperty);
        info.setWriteable(dataSource instanceof ExternalDataSource.Writable);
        info.setInitializable(dataSource instanceof ExternalDataSource.Initializable);
        info.setSupportsUuid(dataSource.isSupportsUuid());
        info.setSupportsHierarchicalIdentifiers(dataSource.isSupportsHierarchicalIdentifiers());
        info.setSupportedTypes(dataSource.getSupportedNodeTypes());
        return info;
    }

    public List<String> getProviderFactories() {
        ArrayList<String> l = new ArrayList<String>();
        for (ProviderFactory factory : this.jcrStoreService.getProviderFactories().values()) {
            try {
                ExtendedNodeType type = NodeTypeRegistry.getInstance().getNodeType(factory.getNodeTypeName());
                l.add(factory.getNodeTypeName());
            }
            catch (NoSuchNodeTypeException e) {
                logger.error("Cannot find factory type", (Throwable)e);
            }
        }
        return l;
    }

    public DataSourceInfo getDatasourceInfo(String mountpoint) throws RepositoryException {
        ExternalContentStoreProvider provider = (ExternalContentStoreProvider)((Object)this.jcrStoreService.getSessionFactory().getMountPoints().get(mountpoint));
        ExternalDataSource dataSource = provider.getDataSource();
        DataSourceInfo dataSourceInfo = this.getBaseDataSourceInfo(dataSource);
        dataSourceInfo.setRootNodeType(this.jcrStoreService.getSessionFactory().getCurrentUserSession().getNode(provider.getMountPoint()).getPrimaryNodeType().getName());
        dataSourceInfo.setExtendable(provider.getExtensionProvider() != null);
        dataSourceInfo.setOverridableItems(provider.getOverridableItems());
        dataSourceInfo.setNonOverridableItems(provider.getNonOverridableItems());
        dataSourceInfo.setExtendableTypes(provider.getExtendableTypes());
        if (dataSourceInfo.isSearchable()) {
            dataSourceInfo.setSupportedQueries(new LinkedHashMap<String, Boolean>());
            QueryManagerWrapper queryManager = this.jcrStoreService.getSessionFactory().getCurrentUserSession().getWorkspace().getQueryManager();
            ExternalDataSource.Searchable searchable = (ExternalDataSource.Searchable)((Object)dataSource);
            this.testQuery(provider, searchable, dataSourceInfo, (Query)queryManager.createQuery("SELECT n.* FROM [nt:base] AS n", "JCR-SQL2"));
            this.testQuery(provider, searchable, dataSourceInfo, (Query)queryManager.createQuery("SELECT n.* FROM [nt:base] AS n WHERE CONTAINS(n.n, 'test')", "JCR-SQL2"));
            this.testQuery(provider, searchable, dataSourceInfo, (Query)queryManager.createQuery("SELECT n.* FROM [nt:base] AS n WHERE ISDESCENDANTNODE(n, [/test])", "JCR-SQL2"));
            this.testQuery(provider, searchable, dataSourceInfo, (Query)queryManager.createQuery("SELECT n.* FROM [nt:base] AS n WHERE (CONTAINS(n.n, 'test') OR CONTAINS(n.[jcr:title], 'test')) AND (n.[jcr:language] = 'test' OR NOT n.[jcr:language] IS NOT NULL) ORDER BY SCORE(n) DESC", "JCR-SQL2"));
            this.testQuery(provider, searchable, dataSourceInfo, (Query)queryManager.createQuery("SELECT * from [nt:hierarchyNode] as n WHERE ((CONTAINS(n.[jcr:content],'acme') OR CONTAINS(n.[jcr:description],'acme') OR CONTAINS(n.[jcr:title],'acme') OR CONTAINS(n.[jcr:keywords],'acme') OR LOCALNAME(n) LIKE '%acme%')) ORDER BY SCORE() DESC", "JCR-SQL2"));
        }
        return dataSourceInfo;
    }

    private void testQuery(ExternalContentStoreProvider provider, ExternalDataSource.Searchable dataSource, DataSourceInfo dataSourceInfo, Query query) {
        try {
            ExternalQuery q = (ExternalQuery)((QueryWrapper)query).getQueries().get((Object)provider);
            if (q != null) {
                dataSource.search(new ExternalQuery(q.getSource(), q.getConstraint(), q.getOrderings(), q.getColumns()));
                dataSourceInfo.getSupportedQueries().put(query.getStatement(), true);
            } else {
                dataSourceInfo.getSupportedQueries().put(query.getStatement(), false);
            }
        }
        catch (Exception e) {
            dataSourceInfo.getSupportedQueries().put(query.getStatement(), false);
        }
    }
}

