/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.external.admin.mount;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.query.QueryResult;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.util.Text;
import org.jahia.modules.external.admin.mount.model.MountPoint;
import org.jahia.modules.external.admin.mount.model.MountPointFactory;
import org.jahia.modules.external.admin.mount.model.MountPointManager;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRStoreProvider;
import org.jahia.services.content.JCRStoreService;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.ProviderFactory;
import org.jahia.services.content.decorator.JCRMountPointNode;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.query.QueryWrapper;
import org.jahia.utils.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.binding.message.MessageContext;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.webflow.execution.RequestContext;

public class MountPointsManagementFlowHandler
implements Serializable {
    private static final long serialVersionUID = 1436197019769187454L;
    private static Logger logger = LoggerFactory.getLogger(MountPointsManagementFlowHandler.class);
    private static final String BUNDLE = "resources.JahiaExternalProvider";
    @Autowired
    private transient JCRStoreService jcrStoreService;

    public void init(RequestContext requestContext, MessageContext messageContext) throws RepositoryException {
        String stateCode = requestContext.getRequestParameters().get("stateCode");
        String messageKey = requestContext.getRequestParameters().get("messageKey");
        String bundleSource = requestContext.getRequestParameters().get("bundleSource");
        if (stateCode != null && messageKey != null && bundleSource != null) {
            Locale locale = LocaleContextHolder.getLocale();
            MessageBuilder messageBuilder = null;
            String message = Messages.get((String)bundleSource, (String)messageKey, (Locale)locale);
            if ("ERROR".equals(stateCode) && message != null) {
                messageBuilder = new MessageBuilder().error().defaultText(message);
            }
            if ("WARNING".equals(stateCode)) {
                messageBuilder = new MessageBuilder().warning().defaultText(message);
            }
            if ("SUCCESS".equals(stateCode)) {
                messageBuilder = new MessageBuilder().info().defaultText(message);
            }
            messageContext.addMessage(messageBuilder.build());
        }
    }

    public MountPointManager getMountPointManagerModel() {
        try {
            return (MountPointManager)JCRTemplate.getInstance().doExecuteWithSystemSession((JCRCallback)new JCRCallback<MountPointManager>(){

                public MountPointManager doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    NodeIterator nodeIterator = MountPointsManagementFlowHandler.this.getMountPoints(session);
                    ArrayList<MountPoint> mountPoints = new ArrayList<MountPoint>((int)nodeIterator.getSize());
                    while (nodeIterator.hasNext()) {
                        JCRMountPointNode mountPointNode = (JCRMountPointNode)nodeIterator.next();
                        mountPoints.add(new MountPoint(mountPointNode));
                    }
                    Map providerFactories = MountPointsManagementFlowHandler.this.jcrStoreService.getProviderFactories();
                    HashMap<String, MountPointFactory> mountPointFactories = new HashMap<String, MountPointFactory>();
                    for (ProviderFactory factory : providerFactories.values()) {
                        JCRNodeWrapper factoryNode;
                        String templateName;
                        ExtendedNodeType type = NodeTypeRegistry.getInstance().getNodeType(factory.getNodeTypeName());
                        String queryString = "select * from [jmix:mountPointFactory] as factory where isdescendantnode(factory,'/modules/') and ['j:mountPointType'] = '" + type.getName() + "'";
                        QueryWrapper query = session.getWorkspace().getQueryManager().createQuery(queryString, "JCR-SQL2");
                        QueryResult queryResult = query.execute();
                        String endOfURL = null;
                        if (queryResult.getNodes().getSize() <= 0L || !StringUtils.isNotEmpty((String)(templateName = (factoryNode = (JCRNodeWrapper)queryResult.getNodes().next()).getPropertyAsString("j:templateName")))) continue;
                        endOfURL = Text.escapePath((String)factoryNode.getPath()) + "." + templateName + ".html";
                        mountPointFactories.put(type.getName(), new MountPointFactory(type.getName(), type.getLabel(LocaleContextHolder.getLocale()), endOfURL));
                    }
                    return new MountPointManager(mountPointFactories, mountPoints);
                }
            });
        }
        catch (RepositoryException e) {
            logger.error("Error retrieving mount points", (Throwable)e);
            return new MountPointManager();
        }
    }

    public void doAction(String mountPointName, Actions action, MessageContext messageContext) {
        boolean success = false;
        switch (action) {
            case mount: {
                success = this.mount(mountPointName);
                break;
            }
            case unmount: {
                success = this.unmount(mountPointName);
                break;
            }
            case delete: {
                success = this.delete(mountPointName);
            }
        }
        this.handleMessages(messageContext, action, mountPointName, success);
    }

    private boolean mount(final String mountPointName) {
        boolean success = false;
        try {
            success = (Boolean)JCRTemplate.getInstance().doExecuteWithSystemSession((JCRCallback)new JCRCallback<Boolean>(){

                public Boolean doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    JCRMountPointNode mountPointNode = MountPointsManagementFlowHandler.this.getMountPoint(session, mountPointName);
                    if (mountPointNode != null) {
                        if (mountPointNode.getMountStatus() != JCRMountPointNode.MountStatus.unmounted) {
                            String detail = "Can't mount " + mountPointName + ", mount status of the mount point is not unmounted";
                            logger.error(detail);
                            return false;
                        }
                        mountPointNode.setMountStatus(JCRMountPointNode.MountStatus.mounted);
                        session.save();
                        JCRStoreProvider mountProvider = mountPointNode.getMountProvider();
                        return mountProvider.isAvailable();
                    }
                    logger.error("Can't mount " + mountPointName + ", no mount point node found");
                    return false;
                }
            });
        }
        catch (RepositoryException e) {
            logger.error("Error trying to mount " + mountPointName, (Throwable)e);
        }
        return success;
    }

    private boolean unmount(final String mountPointName) {
        boolean success = false;
        try {
            success = (Boolean)JCRTemplate.getInstance().doExecuteWithSystemSession((JCRCallback)new JCRCallback<Boolean>(){

                public Boolean doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    JCRMountPointNode mountPointNode = MountPointsManagementFlowHandler.this.getMountPoint(session, mountPointName);
                    if (mountPointNode != null) {
                        if (mountPointNode.getMountStatus() != JCRMountPointNode.MountStatus.mounted) {
                            logger.error("Can't mount " + mountPointName + ", current mount status of the mount point is not mounted");
                            return false;
                        }
                        mountPointNode.setMountStatus(JCRMountPointNode.MountStatus.unmounted);
                        session.save();
                        return mountPointNode.getMountProvider() == null;
                    }
                    logger.error("Can't mount " + mountPointName + ", no mount point node found");
                    return false;
                }
            });
        }
        catch (RepositoryException e) {
            logger.error("Error trying to unmount " + mountPointName, (Throwable)e);
        }
        return success;
    }

    private boolean delete(final String mountPointName) {
        boolean success = false;
        try {
            success = (Boolean)JCRTemplate.getInstance().doExecuteWithSystemSession((JCRCallback)new JCRCallback<Boolean>(){

                public Boolean doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    JCRMountPointNode mountPointNode = MountPointsManagementFlowHandler.this.getMountPoint(session, mountPointName);
                    if (mountPointNode != null) {
                        mountPointNode.remove();
                        session.save();
                        return MountPointsManagementFlowHandler.this.getMountPoint(session, mountPointName) == null;
                    }
                    logger.error("Can't delete " + mountPointName + ", no mount point node found");
                    return false;
                }
            });
        }
        catch (RepositoryException e) {
            logger.error("Error trying to delete " + mountPointName, (Throwable)e);
        }
        return success;
    }

    private void handleMessages(MessageContext messageContext, Actions action, String mountPoint, boolean success) {
        Locale locale = LocaleContextHolder.getLocale();
        String message = Messages.getWithArgs((String)BUNDLE, (String)("serverSettings.mountPointsManagement.action." + (success ? "successMessage" : "failMessage")), (Locale)locale, (Object[])new Object[]{action, mountPoint});
        MessageBuilder messageBuilder = new MessageBuilder();
        if (success) {
            messageBuilder.info().defaultText(message);
        } else {
            messageBuilder.error().defaultText(message);
        }
        messageContext.addMessage(messageBuilder.build());
    }

    private JCRMountPointNode getMountPoint(JCRSessionWrapper sessionWrapper, String name) throws RepositoryException {
        QueryWrapper query = sessionWrapper.getWorkspace().getQueryManager().createQuery(this.getMountPointQuery(name), "JCR-SQL2");
        QueryResult queryResult = query.execute();
        return queryResult.getNodes().getSize() > 0L ? (JCRMountPointNode)queryResult.getNodes().next() : null;
    }

    private NodeIterator getMountPoints(JCRSessionWrapper sessionWrapper) throws RepositoryException {
        QueryWrapper query = sessionWrapper.getWorkspace().getQueryManager().createQuery(this.getMountPointQuery(null), "JCR-SQL2");
        return query.execute().getNodes();
    }

    private String getMountPointQuery(String name) {
        String query = "select * from [jnt:mountPoint] as mount where ischildnode('/mounts')";
        if (StringUtils.isNotEmpty((String)name)) {
            query = query + " and ['j:nodename'] = '" + name + "'";
        }
        return query;
    }

    public void setJcrStoreService(JCRStoreService jcrStoreService) {
        this.jcrStoreService = jcrStoreService;
    }

    public static enum Actions {
        mount,
        unmount,
        delete;

    }
}

