/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.external.cache;

import java.util.Properties;
import javax.jcr.RepositoryException;
import org.jahia.modules.external.ExternalContentStoreProvider;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRStoreProvider;
import org.jahia.services.content.JCRStoreService;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.filter.cache.CacheKeyPartGenerator;

public class ExternalReferenceCacheKeyPartGenerator
implements CacheKeyPartGenerator {
    public String getKey() {
        return "refToExternalContent";
    }

    public String getValue(Resource resource, RenderContext renderContext, Properties properties) {
        try {
            JCRNodeWrapper resourceNode = resource.getNode();
            if (resourceNode.isNodeType("jmix:nodeReference") && resourceNode.hasProperty("j:node")) {
                String uuid = resourceNode.getProperty("j:node").getString();
                for (JCRStoreProvider p : JCRStoreService.getInstance().getSessionFactory().getProviderList()) {
                    if (!(p instanceof ExternalContentStoreProvider) || !((ExternalContentStoreProvider)p).isCacheKeyOnReferenceSupport() || !uuid.startsWith(((ExternalContentStoreProvider)p).getId())) continue;
                    return uuid;
                }
            }
        }
        catch (RepositoryException e) {
            return "";
        }
        return "";
    }

    public String replacePlaceholders(RenderContext renderContext, String s) {
        if (s.equals("")) {
            return "";
        }
        try {
            renderContext.getMainResource().getNode().getSession().getNodeByIdentifier(s);
        }
        catch (RepositoryException e) {
            return "0";
        }
        return "1";
    }
}

