/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.external.query;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.query.qom.And;
import javax.jcr.query.qom.ChildNode;
import javax.jcr.query.qom.Comparison;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.DescendantNode;
import javax.jcr.query.qom.FullTextSearch;
import javax.jcr.query.qom.Literal;
import javax.jcr.query.qom.Not;
import javax.jcr.query.qom.Or;
import javax.jcr.query.qom.PropertyExistence;
import javax.jcr.query.qom.PropertyValue;
import javax.jcr.query.qom.Selector;
import javax.jcr.query.qom.Source;

public class QueryHelper {
    private QueryHelper() {
    }

    public static String getNodeType(Source source) throws UnsupportedRepositoryOperationException {
        if (source instanceof Selector) {
            return ((Selector)source).getNodeTypeName();
        }
        throw new UnsupportedRepositoryOperationException("Unsupported source : " + source);
    }

    public static String getRootPath(Constraint constraint) throws UnsupportedRepositoryOperationException {
        if (constraint == null) {
            return null;
        }
        if (constraint instanceof And) {
            String result1 = QueryHelper.getRootPath(((And)constraint).getConstraint1());
            if (result1 != null) {
                return result1;
            }
            return QueryHelper.getRootPath(((And)constraint).getConstraint2());
        }
        if (constraint instanceof Comparison) {
            return null;
        }
        if (constraint instanceof DescendantNode) {
            return ((DescendantNode)constraint).getAncestorPath();
        }
        if (constraint instanceof ChildNode) {
            return ((ChildNode)constraint).getParentPath();
        }
        if (constraint instanceof Or && QueryHelper.isLanguageConstraint(constraint)) {
            return null;
        }
        throw new UnsupportedRepositoryOperationException("Unsupported constraint : " + constraint.toString());
    }

    public static Boolean includeSubChild(Constraint constraint) throws UnsupportedRepositoryOperationException {
        if (constraint == null) {
            return null;
        }
        if (constraint instanceof And) {
            Boolean result1 = QueryHelper.includeSubChild(((And)constraint).getConstraint1());
            if (result1 != null) {
                return result1;
            }
            return QueryHelper.includeSubChild(((And)constraint).getConstraint2());
        }
        if (constraint instanceof Comparison) {
            return null;
        }
        if (constraint instanceof DescendantNode) {
            return true;
        }
        if (constraint instanceof ChildNode) {
            return false;
        }
        throw new UnsupportedRepositoryOperationException("Unsupported constraint : " + constraint.toString());
    }

    public static Map<String, Value> getSimpleAndConstraints(Constraint constraint) throws RepositoryException {
        HashMap<String, Value> m = new HashMap<String, Value>();
        QueryHelper.addConstraints(m, constraint, true);
        return m;
    }

    public static Map<String, Value> getSimpleOrConstraints(Constraint constraint) throws RepositoryException {
        HashMap<String, Value> m = new HashMap<String, Value>();
        QueryHelper.addConstraints(m, constraint, false);
        return m;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void addConstraints(Map<String, Value> search, Constraint constraint, boolean and) throws RepositoryException {
        if (constraint == null) {
            return;
        }
        if (and && constraint instanceof And) {
            QueryHelper.addConstraints(search, ((And)constraint).getConstraint1(), and);
            QueryHelper.addConstraints(search, ((And)constraint).getConstraint2(), and);
            return;
        } else if (!and && constraint instanceof Or) {
            QueryHelper.addConstraints(search, ((Or)constraint).getConstraint1(), and);
            QueryHelper.addConstraints(search, ((Or)constraint).getConstraint2(), and);
            return;
        } else if (constraint instanceof Not) {
            Constraint constraint1;
            Constraint negatedConstraint = ((Not)constraint).getConstraint();
            if (negatedConstraint instanceof Or && (constraint1 = ((Or)negatedConstraint).getConstraint1()) instanceof PropertyExistence && ((PropertyExistence)constraint1).getPropertyName().equals("jcr:language")) {
                return;
            }
            QueryHelper.addConstraints(search, negatedConstraint, and);
            return;
        } else if (constraint instanceof Comparison) {
            Comparison comparison = (Comparison)constraint;
            if (comparison.getOperand1() instanceof PropertyValue && ((PropertyValue)comparison.getOperand1()).getPropertyName().equals("jcr:language")) {
                return;
            }
            if (!(comparison.getOperand1() instanceof PropertyValue) || !(comparison.getOperand2() instanceof Literal) || !comparison.getOperator().equals("jcr.operator.equal.to")) throw new UnsupportedRepositoryOperationException("Unsupported constraint : " + constraint.toString());
            search.put(((PropertyValue)comparison.getOperand1()).getPropertyName(), ((Literal)comparison.getOperand2()).getLiteralValue());
            return;
        } else {
            if (constraint instanceof DescendantNode || constraint instanceof ChildNode) return;
            if (constraint instanceof FullTextSearch) {
                search.put(((FullTextSearch)constraint).getPropertyName(), ((Literal)((FullTextSearch)constraint).getFullTextSearchExpression()).getLiteralValue());
                return;
            } else {
                Constraint constraint2;
                if (constraint instanceof Or && QueryHelper.isLanguageConstraint(constraint)) {
                    return;
                }
                if (!(constraint instanceof And) || !QueryHelper.isLanguageConstraint(constraint2 = ((And)constraint).getConstraint2())) throw new UnsupportedRepositoryOperationException("Unsupported constraint : " + constraint.toString());
                QueryHelper.addConstraints(search, ((And)constraint).getConstraint1(), and);
                return;
            }
        }
    }

    private static boolean isLanguageConstraint(Constraint constraint) {
        if (constraint instanceof Or) {
            if (QueryHelper.isLanguageExistence(((Or)constraint).getConstraint1())) {
                return true;
            }
            if (QueryHelper.isLanguageExistence(((Or)constraint).getConstraint2())) {
                return true;
            }
        }
        return false;
    }

    private static boolean isLanguageExistence(Constraint constraint1) {
        Constraint not;
        return constraint1 instanceof Not && (not = ((Not)constraint1).getConstraint()) instanceof PropertyExistence && ((PropertyExistence)not).getPropertyName().equals("jcr:language");
    }

    public static String getLanguage(Constraint constraint) throws RepositoryException {
        if (constraint == null) {
            return null;
        }
        if (constraint instanceof And) {
            String lang = QueryHelper.getLanguage(((And)constraint).getConstraint1());
            if (lang != null) {
                return lang;
            }
            return QueryHelper.getLanguage(((And)constraint).getConstraint2());
        }
        if (constraint instanceof Or) {
            String lang = QueryHelper.getLanguage(((Or)constraint).getConstraint1());
            if (lang != null) {
                return lang;
            }
            return QueryHelper.getLanguage(((Or)constraint).getConstraint2());
        }
        if (constraint instanceof Not) {
            return QueryHelper.getLanguage(((Not)constraint).getConstraint());
        }
        if (constraint instanceof Comparison) {
            Comparison comparison = (Comparison)constraint;
            if (comparison.getOperand1() instanceof PropertyValue && comparison.getOperand2() instanceof Literal && comparison.getOperator().equals("jcr.operator.equal.to") && ((PropertyValue)comparison.getOperand1()).getPropertyName().equals("jcr:language")) {
                return ((Literal)comparison.getOperand2()).getLiteralValue().getString();
            }
            return null;
        }
        return null;
    }
}

