/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.jahiacsrfguard;

import java.lang.reflect.Proxy;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.jahia.bin.listeners.JahiaContextLoaderListener;
import org.jahia.modules.jahiacsrfguard.HttpServiceTracker;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.owasp.csrfguard.CsrfGuardServletContextListener;

public class Activator
implements BundleActivator {
    private HttpServiceTracker httpTracker;

    public void start(BundleContext context) throws Exception {
        this.httpTracker = new HttpServiceTracker(context);
        this.httpTracker.open();
        CsrfGuardServletContextListener csrfGuardServletContextListener = new CsrfGuardServletContextListener();
        ServletContext servletContext = (ServletContext)Proxy.newProxyInstance(Activator.class.getClassLoader(), new Class[]{ServletContext.class}, (proxy, method, args) -> {
            if (method.getName().equals("getInitParameter") && args[0].equals("Owasp.CsrfGuard.Config")) {
                if (System.getProperty("java.vm.vendor").toLowerCase().contains("ibm")) {
                    return "META-INF/csrfguard-ibm.properties";
                }
                return "META-INF/csrfguard.properties";
            }
            return method.invoke((Object)JahiaContextLoaderListener.getServletContext(), args);
        });
        csrfGuardServletContextListener.contextInitialized(new ServletContextEvent(servletContext));
    }

    public void stop(BundleContext context) throws Exception {
        this.httpTracker.close();
    }
}

