/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.jahiacsrfguard;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.jahia.modules.jahiacsrfguard.filters.CsrfGuardServletFilterWrapper;

public class Config {
    private CsrfGuardServletFilterWrapper filter;
    private List<Pattern> urlPatterns;
    private List<Pattern> whitelist;

    public void setFilter(CsrfGuardServletFilterWrapper filter) {
        this.filter = filter;
    }

    public void init() {
        this.filter.registerConfig(this);
    }

    public void destroy() {
        this.filter.unregisterConfig(this);
    }

    public void setUrlPatterns(String urlPatterns) {
        this.urlPatterns = Arrays.stream(urlPatterns.split(",")).map(String::trim).map(Config::createUrlPattern).collect(Collectors.toList());
    }

    public void setWhitelist(String whitelist) {
        this.whitelist = Arrays.stream(whitelist.split(",")).map(String::trim).map(Config::createUrlPattern).collect(Collectors.toList());
    }

    public static Pattern createUrlPattern(String pattern) {
        String patternToUse = pattern;
        if (!pattern.contains("*")) {
            patternToUse = pattern + (pattern.endsWith("/") ? "*" : "/*");
        }
        patternToUse = patternToUse.replace(".", "\\.");
        patternToUse = patternToUse.replaceAll("([^\\\\])\\*", "$1.*");
        patternToUse = patternToUse.replaceAll("^\\*", ".*");
        return Pattern.compile(patternToUse);
    }

    public boolean isFiltered(ServletRequest request) {
        if (this.urlPatterns == null) {
            return false;
        }
        String uri = ((HttpServletRequest)request).getRequestURI();
        return this.urlPatterns.stream().anyMatch(pattern -> pattern.matcher(uri).matches());
    }

    public boolean isWhiteListed(ServletRequest request) {
        if (this.whitelist == null) {
            return false;
        }
        String uri = ((HttpServletRequest)request).getRequestURI();
        return this.whitelist.stream().anyMatch(pattern -> pattern.matcher(uri).matches());
    }
}

