/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.jahiacsrfguard;

import org.owasp.csrfguard.log.ILogger;
import org.owasp.csrfguard.log.LogLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsrfGuardLogger
implements ILogger {
    private static final long serialVersionUID = 5581329713949000954L;
    private static final Logger logger = LoggerFactory.getLogger((String)"Owasp.CsrfGuard");

    public void log(String msg) {
        logger.info(msg);
    }

    public void log(LogLevel level, String msg) {
        switch (level) {
            case Info: {
                logger.info(msg);
                break;
            }
            case Debug: {
                logger.debug(msg);
                break;
            }
            case Trace: {
                logger.trace(msg);
                break;
            }
            case Warning: {
                logger.warn(msg);
                break;
            }
            default: {
                logger.error(msg);
            }
        }
    }

    public void log(Exception exception) {
        logger.error(exception.getLocalizedMessage(), (Throwable)exception);
    }

    public void log(LogLevel level, Exception exception) {
        switch (level) {
            case Info: {
                logger.info(exception.getLocalizedMessage(), (Throwable)exception);
                break;
            }
            case Debug: {
                logger.debug(exception.getLocalizedMessage(), (Throwable)exception);
                break;
            }
            case Trace: {
                logger.trace(exception.getLocalizedMessage(), (Throwable)exception);
                break;
            }
            case Warning: {
                logger.warn(exception.getLocalizedMessage(), (Throwable)exception);
                break;
            }
            default: {
                logger.error(exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
    }
}

