/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.jahiacsrfguard.filters;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.http.HttpSession;
import org.jahia.bin.filters.AbstractServletFilter;
import org.owasp.csrfguard.CsrfGuard;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CsrfGuardJavascriptFilter
extends AbstractServletFilter {
    private static final Logger logger = LoggerFactory.getLogger(CsrfGuardJavascriptFilter.class);
    private static final Pattern CLOSE_HEAD_TAG_PATTERN = Pattern.compile("</head>", 2);
    private String servletPath;

    public void init(FilterConfig filterConfig) {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String originalContent;
        Matcher closeHeadTagMatcher;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        ResponseWrapper responseWrapper = new ResponseWrapper(httpResponse);
        chain.doFilter(request, (ServletResponse)responseWrapper);
        HttpSession httpSession = httpRequest.getSession(false);
        if (httpSession != null) {
            CsrfGuard csrfGuard = CsrfGuard.getInstance();
            csrfGuard.updateToken(httpSession);
        }
        if ((closeHeadTagMatcher = CLOSE_HEAD_TAG_PATTERN.matcher(originalContent = responseWrapper.toString())).find()) {
            logger.debug("Adding CSRFGuard JS to '{}'", (Object)httpRequest.getRequestURI());
            int indexOfCloseHeadTag = closeHeadTagMatcher.start();
            String codeSnippet = this.buildCodeSnippet(httpRequest.getContextPath());
            PrintWriter writer = response.getWriter();
            writer.write(originalContent.substring(0, indexOfCloseHeadTag));
            writer.write(codeSnippet);
            writer.write(originalContent.substring(indexOfCloseHeadTag));
            int contentLength = originalContent.length() + codeSnippet.length();
            response.setContentLength(contentLength);
        } else {
            response.getWriter().write(originalContent);
        }
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    private String buildCodeSnippet(String contextPath) {
        String src = contextPath + this.servletPath;
        return String.format("<script type=\"text/javascript\" src=\"%s\"></script>\n", src);
    }

    private static final class ResponseWrapper
    extends HttpServletResponseWrapper {
        private final CharArrayWriter writer = new CharArrayWriter();

        ResponseWrapper(HttpServletResponse response) {
            super(response);
        }

        public PrintWriter getWriter() throws IOException {
            return new PrintWriter(this.writer);
        }

        public String toString() {
            return this.writer.toString();
        }
    }
}

