/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.jahiacsrfguard.filters;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.jahia.bin.filters.AbstractServletFilter;
import org.jahia.modules.jahiacsrfguard.Config;
import org.owasp.csrfguard.CsrfGuardFilter;

public class CsrfGuardServletFilterWrapper
extends AbstractServletFilter {
    private CsrfGuardFilter csrfGuardFilter;
    private Set<Config> configs = new HashSet<Config>();

    public void init(FilterConfig filterConfig) throws ServletException {
        this.csrfGuardFilter = new CsrfGuardFilter();
        this.csrfGuardFilter.init(filterConfig);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.isFiltered(request) && !this.isWhiteListed(request)) {
            this.csrfGuardFilter.doFilter(request, response, chain);
            return;
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
        this.csrfGuardFilter.destroy();
    }

    public void registerConfig(Config config) {
        this.configs.add(config);
    }

    public void unregisterConfig(Config config) {
        this.configs.remove(config);
    }

    public boolean isFiltered(ServletRequest request) {
        return this.configs.stream().anyMatch(config -> config.isFiltered(request));
    }

    public boolean isWhiteListed(ServletRequest request) {
        return this.configs.stream().anyMatch(config -> config.isWhiteListed(request));
    }
}

