/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.maven.hbm2ddl;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.IOUtil;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.ejb.Ejb3Configuration;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.Target;

public class JpaSchemaExportMojo
extends AbstractMojo {
    private String hibernateDialect;
    private String hibernateNamingStrategy;
    private File outputFile;
    private String persistenceFileName;
    private String persistenceUnitName;
    private MavenProject project;
    private SchemaExport.Type statementType = SchemaExport.Type.BOTH;

    private void configureNamingStrategy(Configuration cfg) throws MojoExecutionException {
        if (this.hibernateNamingStrategy == null || this.hibernateNamingStrategy.length() == 0) {
            return;
        }
        try {
            cfg.setNamingStrategy((NamingStrategy)Thread.currentThread().getContextClassLoader().loadClass(this.hibernateNamingStrategy).newInstance());
            this.getLog().info((CharSequence)("Using naming strategy: " + this.hibernateNamingStrategy));
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Unable to instantiate the class for the naming strategy: " + this.hibernateNamingStrategy), (Throwable)e);
            throw new MojoExecutionException("Unable to instantiate the class for the naming strategy: " + this.hibernateNamingStrategy, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassLoader createClassLoader(ClassLoader contextClassLoader) throws MojoExecutionException {
        try {
            LinkedList<String> locations = new LinkedList<String>(this.project.getCompileClasspathElements());
            locations.addAll(this.project.getRuntimeClasspathElements());
            locations.add(this.project.getBuild().getOutputDirectory());
            LinkedList<URL> urls = new LinkedList<URL>();
            for (String location : locations) {
                urls.add(new File(location).toURI().toURL());
            }
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Using following locations for class loader:\n" + locations));
            }
            URLClassLoader urlClassLoader = new URLClassLoader(urls.toArray(new URL[0]), ((Object)((Object)this)).getClass().getClassLoader());
            if (this.persistenceFileName == null) {
                return urlClassLoader;
            }
            URL persistenceUrl = urlClassLoader.getResource("META-INF/" + this.persistenceFileName);
            if (persistenceUrl != null) {
                File outputFile = new File(this.project.getBuild().getOutputDirectory(), "META-INF/persistence.xml");
                this.getLog().info((CharSequence)("Copying " + this.persistenceFileName + " from " + persistenceUrl + " to " + outputFile));
                InputStream is = null;
                BufferedOutputStream os = null;
                try {
                    outputFile.getParentFile().mkdirs();
                    is = persistenceUrl.openStream();
                    os = new BufferedOutputStream(new FileOutputStream(outputFile));
                    IOUtil.copy((InputStream)is, (OutputStream)os);
                }
                catch (Throwable throwable) {
                    IOUtil.close(is);
                    IOUtil.close(os);
                    throw throwable;
                }
                IOUtil.close((InputStream)is);
                IOUtil.close((OutputStream)os);
            }
            return urlClassLoader;
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Unable to create class loader", (Throwable)e);
            throw new MojoExecutionException("Unable to create class loader", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("Performing DDL schema export for persistence unit '" + this.persistenceUnitName + "' using dialect '" + this.hibernateDialect + "'. Output file is: " + this.outputFile));
        File outputFolder = this.outputFile.getParentFile();
        if (!outputFolder.exists()) {
            outputFolder.mkdirs();
        }
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader customClassLoader = this.createClassLoader(contextClassLoader);
            Thread.currentThread().setContextClassLoader(customClassLoader);
            this.performExport();
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    private Map<String, String> getHibernateProperties() {
        if (this.hibernateDialect != null && this.hibernateDialect.length() > 0) {
            HashMap<String, String> props = new HashMap<String, String>(2);
            props.put("hibernate.dialect", this.hibernateDialect);
            props.put("hibernate.id.new_generator_mappings", "false");
            this.getLog().info((CharSequence)("Using the following Hibernate dialect: " + this.hibernateDialect));
            return props;
        }
        return null;
    }

    private void performExport() throws MojoExecutionException {
        Configuration cfg = new Ejb3Configuration().configure(this.persistenceUnitName, this.getHibernateProperties()).getHibernateConfiguration();
        this.configureNamingStrategy(cfg);
        SchemaExport schemaExport = new SchemaExport(cfg);
        schemaExport.setDelimiter(";");
        schemaExport.setOutputFile(this.outputFile.getAbsolutePath());
        schemaExport.execute(Target.SCRIPT, this.statementType);
    }
}

