/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.qom.PropertyValue;
import javax.jcr.query.qom.Selector;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.query.lucene.FacetRow;
import org.apache.jackrabbit.core.query.lucene.NamespaceMappings;
import org.apache.jackrabbit.core.query.lucene.SearchIndex;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.util.OpenBitSet;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.RangeFacet;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.search.facets.SimpleJahiaJcrFacets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FacetHandler {
    public static final int FACET_COLUMNS = 1;
    public static final int ONLY_FACET_COLUMNS = 2;
    private static final Logger log = LoggerFactory.getLogger(FacetHandler.class);
    private static final String RANGEFROM_INCLUSIVE_PREFIX = ":[";
    private static final String RANGEFROM_EXCLUSIVE_PREFIX = ":{";
    private static final String FACET_FUNC_LPAR = "facet(";
    private static final Name REP_FACET_LPAR = NameFactoryImpl.getInstance().create("internal", "facet(");
    private static final String FIELD_SPECIFIC_PREFIX = "f.";
    private static final Pattern valueWithQuery = Pattern.compile("(.*)##q\\->##(.*)");
    private Map<String, Long> _facetQuery = null;
    private List<FacetField> _facetFields = null;
    private List<FacetField> _limitingFacets = null;
    private List<FacetField> _facetDates = null;
    private List<RangeFacet> _facetRanges = null;
    protected final SessionImpl session;
    protected Selector selector;
    protected final Map<String, PropertyValue> columns;
    private long totalSize = 1L;
    OpenBitSet docIdSet;
    SearchIndex index;
    NamespaceMappings nsMappings;

    public FacetHandler(Map<String, PropertyValue> columns, Selector selector, OpenBitSet docIdSet, SearchIndex index, SessionImpl session, NamespaceMappings nsMappings) {
        this.columns = columns;
        this.selector = selector;
        this.session = session;
        this.docIdSet = docIdSet;
        this.index = index;
        this.nsMappings = nsMappings;
        this.totalSize = docIdSet.cardinality();
    }

    public static int hasFacetFunctions(Map<String, PropertyValue> columns, SessionImpl session) {
        int hasFacetRequest = !columns.isEmpty() ? 2 : 0;
        for (String column : columns.keySet()) {
            if (FacetHandler.isFacetFunction(column, session)) {
                hasFacetRequest |= 1;
                continue;
            }
            hasFacetRequest &= 0xFFFFFFFD;
        }
        return hasFacetRequest;
    }

    private static boolean isFacetFunction(String name, SessionImpl session) {
        try {
            return name.trim().startsWith(session.getJCRName(REP_FACET_LPAR));
        }
        catch (NamespaceException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleFacets(IndexReader reader) {
        IndexSearcher searcher = new IndexSearcher(reader);
        try {
            String facetFunctionPrefix = this.session.getJCRName(REP_FACET_LPAR);
            NamedList parameters = new NamedList();
            int counter = 0;
            for (Map.Entry<String, PropertyValue> column : this.columns.entrySet()) {
                if (!FacetHandler.isFacetFunction(column.getKey(), this.session)) continue;
                this.extractFacetParameters(facetFunctionPrefix, (NamedList<Object>)parameters, counter, column);
                ++counter;
            }
            SimpleJahiaJcrFacets facets = new SimpleJahiaJcrFacets(searcher, this.docIdSet, SolrParams.toSolrParams((NamedList)parameters), this.index, (Session)this.session, this.nsMappings);
            this.extractFacetInfo(facets.getFacetCounts());
        }
        catch (Exception ex) {
            log.warn("Problem creating facets: ", (Throwable)ex);
        }
        finally {
            try {
                searcher.close();
            }
            catch (IOException e) {
                log.warn("Unable to close searcher: " + e);
            }
        }
    }

    private void extractFacetParameters(String facetFunctionPrefix, NamedList<Object> parameters, int counter, Map.Entry<String, PropertyValue> column) throws RepositoryException {
        String[] paramPairs;
        String key = column.getKey();
        String facetOptions = key.substring(key.indexOf(facetFunctionPrefix) + facetFunctionPrefix.length(), key.lastIndexOf(")"));
        String nodeType = null;
        LinkedList<String> unparsedQueries = null;
        String columnPropertyName = column.getValue().getPropertyName();
        String propertyName = columnPropertyName + "#" + counter;
        boolean isQuery = facetOptions.contains("facet.query");
        String facetType = "facet.field";
        if (isQuery) {
            facetType = "facet.query";
        } else if (facetOptions.contains("date")) {
            facetType = "facet.date";
        } else if (facetOptions.contains("range")) {
            facetType = "facet.range";
        }
        parameters.add(facetType, (Object)propertyName);
        for (String paramPair : paramPairs = StringUtils.split((String)facetOptions, (String)"&")) {
            int separator = paramPair.indexOf(61);
            if (separator < 0) continue;
            String paramName = paramPair.substring(0, separator);
            String paramValue = paramPair.substring(separator + 1);
            if (paramName.equals("nodetype")) {
                nodeType = paramValue;
                continue;
            }
            if (paramName.contains("query")) {
                if (unparsedQueries == null) {
                    unparsedQueries = new LinkedList<String>();
                }
                unparsedQueries.add(paramValue);
                continue;
            }
            String facetOption = this.getFacetOption(paramName);
            parameters.add(this.getFullParameterName(propertyName, facetOption), (Object)paramValue);
        }
        if (StringUtils.isEmpty(nodeType)) {
            nodeType = this.getNodeTypeFromSelector(column.getValue().getSelectorName(), columnPropertyName);
        }
        if (!isQuery) {
            parameters.add(this.getFullParameterName(propertyName, this.getFacetOption("nodetype")), (Object)nodeType);
        }
        if (unparsedQueries != null) {
            ExtendedPropertyDefinition epd = NodeTypeRegistry.getInstance().getNodeType(nodeType).getPropertyDefinition(columnPropertyName);
            for (String unparsedQuery : unparsedQueries) {
                if (unparsedQuery.split("(?<!\\\\):").length == 1 && !columnPropertyName.equals("rep:facet()") && epd != null) {
                    String fieldNameInIndex = this.getFieldNameInIndex(propertyName, epd, "");
                    unparsedQuery = QueryParser.escape((String)fieldNameInIndex) + ":" + unparsedQuery;
                }
                parameters.add(this.getFullParameterName(propertyName, "query"), (Object)unparsedQuery);
            }
        }
    }

    private String getFullParameterName(String propertyName, String facetOption) {
        return FIELD_SPECIFIC_PREFIX + propertyName + "." + facetOption;
    }

    private String getFacetOption(String paramName) {
        String prefix = "facet.";
        return paramName.startsWith("facet.") ? paramName : "facet." + paramName;
    }

    public String getFieldNameInIndex(String field, ExtendedPropertyDefinition epd, String langCode) {
        String fieldName = field;
        try {
            fieldName = this.session.getJCRName(NameFactoryImpl.getInstance().create(this.session.getNamespaceURI(epd.getPrefix()), epd.getLocalName()));
            int idx = fieldName.indexOf(58);
            fieldName = fieldName.substring(0, idx + 1) + (epd != null && epd.isFacetable() ? "FACET:" : "FULL:") + fieldName.substring(idx + 1);
        }
        catch (RepositoryException e) {
            // empty catch block
        }
        return fieldName;
    }

    private String getNodeTypeFromSelector(String selectorName, String propertyName) throws RepositoryException {
        selectorName = StringUtils.removeEnd((String)selectorName, (String)"translationAdded");
        Selector foundSelector = this.selector;
        return foundSelector.getNodeTypeName();
    }

    private void extractFacetInfo(NamedList<Object> info) {
        NamedList rf;
        NamedList df;
        String query;
        FacetField f;
        NamedList ff;
        this._facetQuery = new LinkedHashMap<String, Long>();
        NamedList fq = (NamedList)info.get("facet_queries");
        if (fq != null) {
            for (Map.Entry entry : fq) {
                this._facetQuery.put((String)entry.getKey(), (Long)entry.getValue());
            }
        }
        if ((ff = (NamedList)info.get("facet_fields")) != null) {
            this._facetFields = new ArrayList<FacetField>(ff.size());
            this._limitingFacets = new ArrayList<FacetField>(ff.size());
            long minsize = this.totalSize;
            for (Map.Entry facet : ff) {
                String key = StringUtils.substringBeforeLast((String)((String)facet.getKey()), (String)"#");
                String fieldInIndex = StringUtils.substringAfterLast((String)((String)facet.getKey()), (String)"#");
                f = new FacetField(key);
                for (Map.Entry entry : (NamedList)facet.getValue()) {
                    String facetValue = (String)entry.getKey();
                    query = (String)entry.getKey();
                    Matcher matcher = valueWithQuery.matcher(facetValue);
                    if (matcher.matches()) {
                        query = matcher.group(2);
                        facetValue = matcher.replaceFirst("$1");
                    }
                    f.add(facetValue, ((Number)entry.getValue()).longValue());
                    f.getValues().get(f.getValueCount() - 1).setFilterQuery(ClientUtils.escapeQueryChars(fieldInIndex) + ":" + ClientUtils.escapeQueryChars(query));
                }
                this._facetFields.add(f);
                FacetField nl = f.getLimitingFields(minsize);
                if (nl.getValueCount() <= 0) continue;
                this._limitingFacets.add(nl);
            }
        }
        if ((df = (NamedList)info.get("facet_dates")) != null) {
            this._facetDates = new ArrayList<FacetField>(df.size());
            for (Map.Entry facet : df) {
                NamedList values = (NamedList)facet.getValue();
                String gap = (String)values.get("gap");
                Date end = (Date)values.get("end");
                f = new FacetField(StringUtils.substringBeforeLast((String)((String)facet.getKey()), (String)"#"), gap, end);
                for (Map.Entry entry : values) {
                    try {
                        String key = StringUtils.substringBeforeLast((String)((String)entry.getKey()), (String)"#");
                        query = StringUtils.substringAfterLast((String)((String)entry.getKey()), (String)"#");
                        f.add(key, Long.parseLong(entry.getValue().toString()));
                        if (StringUtils.isEmpty((String)query)) continue;
                        String rangePrefix = null;
                        if (query.contains(RANGEFROM_EXCLUSIVE_PREFIX)) {
                            rangePrefix = RANGEFROM_EXCLUSIVE_PREFIX;
                        } else if (query.contains(RANGEFROM_INCLUSIVE_PREFIX)) {
                            rangePrefix = RANGEFROM_INCLUSIVE_PREFIX;
                        }
                        if (StringUtils.isEmpty((String)rangePrefix)) continue;
                        f.getValues().get(f.getValueCount() - 1).setFilterQuery(ClientUtils.escapeQueryChars(StringUtils.substringBefore((String)query, (String)rangePrefix)) + rangePrefix + StringUtils.substringAfter((String)query, (String)rangePrefix));
                    }
                    catch (NumberFormatException e) {}
                }
                this._facetDates.add(f);
            }
        }
        if ((rf = (NamedList)info.get("facet_ranges")) != null) {
            this._facetRanges = new ArrayList<RangeFacet>(rf.size());
            for (Map.Entry facet : rf) {
                RangeFacet rangeFacet;
                Number after;
                Number before;
                Serializable end;
                Serializable start;
                Object gap;
                NamedList values = (NamedList)facet.getValue();
                Object rawGap = values.get("gap");
                if (rawGap instanceof Number) {
                    gap = (Number)rawGap;
                    start = (Number)values.get("start");
                    end = (Number)values.get("end");
                    before = (Number)values.get("before");
                    after = (Number)values.get("after");
                    rangeFacet = new RangeFacet.Numeric(StringUtils.substringBeforeLast((String)((String)facet.getKey()), (String)"#"), (Number)start, (Number)end, (Number)gap, before, after);
                } else {
                    gap = (String)rawGap;
                    start = (Date)values.get("start");
                    end = (Date)values.get("end");
                    before = (Number)values.get("before");
                    after = (Number)values.get("after");
                    rangeFacet = new RangeFacet.Date(StringUtils.substringBeforeLast((String)((String)facet.getKey()), (String)"#"), (Date)start, (Date)end, (String)gap, before, after);
                }
                NamedList counts = (NamedList)values.get("counts");
                for (Map.Entry entry : counts) {
                    try {
                        String key = StringUtils.substringBeforeLast((String)((String)entry.getKey()), (String)"#");
                        String query2 = StringUtils.substringAfterLast((String)((String)entry.getKey()), (String)"#");
                        rangeFacet.addCount(key, (Integer)entry.getValue());
                        if (StringUtils.isEmpty((String)query2)) continue;
                        String rangePrefix = null;
                        if (query2.contains(RANGEFROM_EXCLUSIVE_PREFIX)) {
                            rangePrefix = RANGEFROM_EXCLUSIVE_PREFIX;
                        } else if (query2.contains(RANGEFROM_INCLUSIVE_PREFIX)) {
                            rangePrefix = RANGEFROM_INCLUSIVE_PREFIX;
                        }
                        if (StringUtils.isEmpty((String)rangePrefix)) continue;
                        rangeFacet.getCounts().get(rangeFacet.getCounts().size() - 1).setFilterQuery(ClientUtils.escapeQueryChars(StringUtils.substringBefore((String)query2, (String)rangePrefix)) + rangePrefix + StringUtils.substringAfter((String)query2, (String)rangePrefix));
                    }
                    catch (NumberFormatException e) {}
                }
                this._facetRanges.add(rangeFacet);
            }
        }
    }

    public FacetRow getFacetsRow() {
        FacetRow row = new FacetRow();
        row.setFacetFields(this._facetFields);
        row.setLimitingFacets(this._limitingFacets);
        row.setFacetDates(this._facetDates);
        row.setRangeFacets(this._facetRanges);
        row.setFacetQuery(this._facetQuery);
        return row;
    }
}

