/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import javax.jcr.query.Row;
import javax.jcr.query.qom.ChildNode;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.DescendantNode;
import javax.jcr.query.qom.DynamicOperand;
import javax.jcr.query.qom.FullTextSearch;
import javax.jcr.query.qom.Literal;
import javax.jcr.query.qom.PropertyValue;
import javax.jcr.query.qom.Selector;
import javax.jcr.query.qom.StaticOperand;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.math.util.MathUtils;
import org.apache.jackrabbit.commons.predicate.Predicate;
import org.apache.jackrabbit.commons.query.qom.OperandEvaluator;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.query.lucene.AnalyzerRegistry;
import org.apache.jackrabbit.core.query.lucene.CountHandler;
import org.apache.jackrabbit.core.query.lucene.FacetHandler;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.JackrabbitIndexSearcher;
import org.apache.jackrabbit.core.query.lucene.JackrabbitTermQuery;
import org.apache.jackrabbit.core.query.lucene.JahiaNodeIndexer;
import org.apache.jackrabbit.core.query.lucene.JahiaSearchIndex;
import org.apache.jackrabbit.core.query.lucene.LuceneQueryFactory;
import org.apache.jackrabbit.core.query.lucene.QueryHits;
import org.apache.jackrabbit.core.query.lucene.ScoreNode;
import org.apache.jackrabbit.core.query.lucene.SearchIndex;
import org.apache.jackrabbit.core.query.lucene.Util;
import org.apache.jackrabbit.core.query.lucene.join.SelectorRow;
import org.apache.jackrabbit.core.security.JahiaAccessManager;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.DocIdBitSet;
import org.apache.lucene.util.OpenBitSet;
import org.apache.lucene.util.OpenBitSetDISI;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.jahia.services.search.facets.JahiaQueryParser;
import org.jahia.utils.LanguageCodeConverters;
import org.jahia.utils.Patterns;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaLuceneQueryFactoryImpl
extends LuceneQueryFactory {
    private static Logger logger = LoggerFactory.getLogger(JahiaLuceneQueryFactoryImpl.class);
    private Locale locale;
    private String queryLanguage;
    public static final FieldSelector ONLY_MAIN_NODE_UUID = new FieldSelector(){

        public FieldSelectorResult accept(String fieldName) {
            if (JahiaNodeIndexer.TRANSLATED_NODE_PARENT == fieldName) {
                return FieldSelectorResult.LOAD;
            }
            if (FieldNames.PARENT == fieldName) {
                return FieldSelectorResult.LOAD;
            }
            return FieldSelectorResult.NO_LOAD;
        }
    };
    public static final FieldSelector OPTIMIZATION_FIELDS = new FieldSelector(){

        public FieldSelectorResult accept(String fieldName) {
            if (JahiaNodeIndexer.TRANSLATED_NODE_PARENT == fieldName) {
                return FieldSelectorResult.LOAD;
            }
            if (FieldNames.PARENT == fieldName) {
                return FieldSelectorResult.LOAD;
            }
            if (JahiaNodeIndexer.ACL_UUID == fieldName) {
                return FieldSelectorResult.LOAD;
            }
            if (JahiaNodeIndexer.CHECK_VISIBILITY == fieldName) {
                return FieldSelectorResult.LOAD;
            }
            if (JahiaNodeIndexer.PUBLISHED == fieldName) {
                return FieldSelectorResult.LOAD;
            }
            if (JahiaNodeIndexer.INVALID_LANGUAGES == fieldName) {
                return FieldSelectorResult.LOAD;
            }
            return FieldSelectorResult.NO_LOAD;
        }
    };

    public JahiaLuceneQueryFactoryImpl(SessionImpl session, SearchIndex index, Map<String, Value> bindVariables) throws RepositoryException {
        super(session, index, bindVariables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Row> execute(Map<String, PropertyValue> columns, Selector selector, Constraint constraint, Sort sort, boolean externalSort, long offsetIn, long limitIn) throws RepositoryException, IOException {
        IndexReader reader = this.index.getIndexReader(true);
        int offset = offsetIn < 0L ? 0 : (int)offsetIn;
        int limit = limitIn < 0L ? Integer.MAX_VALUE : (int)limitIn;
        QueryHits hits = null;
        try {
            JackrabbitIndexSearcher searcher = new JackrabbitIndexSearcher(this.session, reader, this.index.getContext().getItemStateManager());
            searcher.setSimilarity(this.index.getSimilarity());
            Predicate filter = Predicate.TRUE;
            BooleanQuery query = new BooleanQuery();
            LuceneQueryFactory.QueryPair qp = new LuceneQueryFactory.QueryPair(query);
            query.add(this.create(selector), BooleanClause.Occur.MUST);
            if (constraint != null) {
                String name = selector.getSelectorName();
                NodeType type = this.ntManager.getNodeType(selector.getNodeTypeName());
                filter = this.mapConstraintToQueryAndFilter(qp, constraint, Collections.singletonMap(name, type), searcher, reader);
            }
            HashSet<String> foundIds = new HashSet<String>();
            int hasFacets = FacetHandler.hasFacetFunctions(columns, this.session);
            CountHandler.CountType countType = CountHandler.hasCountFunction(columns, this.session);
            boolean isCount = countType != null;
            BitSet bitset = (hasFacets & 1) == 0 ? null : new BitSet();
            LinkedList<Object> rowList = externalSort ? new LinkedList() : null;
            LinkedHashMap<String, Object> rows = externalSort ? null : new LinkedHashMap<String, Object>();
            hits = searcher.evaluate(qp.mainQuery, sort, (long)(offset + limit));
            int currentNode = 0;
            int addedNodes = 0;
            int resultCount = 0;
            int hitsSize = 0;
            ScoreNode node = hits.nextScoreNode();
            HashMap<String, Boolean> checkedAcls = new HashMap<String, Boolean>();
            while (node != null) {
                if (isCount && countType.isApproxCount() && ++hitsSize > countType.getApproxCountLimit()) {
                    if (hits.getSize() > 0) {
                        hitsSize = hits.getSize();
                        break;
                    }
                    node = hits.nextScoreNode();
                    continue;
                }
                IndexedNodeInfo infos = this.getIndexedNodeInfo(node, reader, isCount && countType.isSkipChecks());
                if (foundIds.add(infos.getMainNodeUuid())) {
                    if (isCount && countType.isSkipChecks()) {
                        ++resultCount;
                    } else {
                        try {
                            boolean canRead = true;
                            if (this.isAclUuidInIndex()) {
                                canRead = this.checkIndexedAcl(checkedAcls, infos);
                            }
                            if (!(!canRead || "live".equals(this.session.getWorkspace().getName()) && (infos.getPublished() != null && !"true".equals(infos.getPublished()) || infos.getCheckInvalidLanguages() != null && infos.getCheckInvalidLanguages().contains(this.getLocale().toString())))) {
                                NodeImpl objectNode;
                                if (filter == Predicate.TRUE) {
                                    if ((hasFacets & 2) == 0) {
                                        LazySelectorRow row = null;
                                        if ("1".equals(infos.getCheckVisibility()) || !this.isAclUuidInIndex()) {
                                            NodeImpl objectNode2 = this.session.getNodeById(node.getNodeId());
                                            if (objectNode2.isNodeType("jnt:translation")) {
                                                objectNode2 = (NodeImpl)objectNode2.getParent();
                                            }
                                            if (isCount) {
                                                ++resultCount;
                                            } else {
                                                row = new LazySelectorRow(columns, this.evaluator, selector.getSelectorName(), (Node)objectNode2, (double)node.getScore());
                                            }
                                        } else if (isCount) {
                                            ++resultCount;
                                        } else {
                                            row = new LazySelectorRow(columns, this.evaluator, selector.getSelectorName(), node.getNodeId(), (double)node.getScore());
                                        }
                                        if (row == null) continue;
                                        if (externalSort) {
                                            rowList.add((Object)row);
                                        } else {
                                            if (currentNode >= offset && currentNode - offset < limit) {
                                                rows.put(node.getNodeId().toString(), (Object)row);
                                                ++addedNodes;
                                            }
                                            ++currentNode;
                                            if (addedNodes == limit) break;
                                        }
                                    }
                                    if ((hasFacets & 1) == 1) {
                                        if (!(!this.isAclUuidInIndex() || "live".equals(this.session.getWorkspace().getName()) && "1".equals(infos.getCheckVisibility()))) {
                                            bitset.set(infos.getDocNumber());
                                        } else {
                                            objectNode = this.session.getNodeById(node.getNodeId());
                                            if (objectNode.isNodeType("jnt:translation")) {
                                                objectNode = (NodeImpl)objectNode.getParent();
                                            }
                                            bitset.set(infos.getDocNumber());
                                        }
                                    }
                                } else {
                                    objectNode = this.session.getNodeById(node.getNodeId());
                                    if (objectNode.isNodeType("jnt:translation")) {
                                        objectNode = (NodeImpl)objectNode.getParent();
                                    }
                                    if (isCount) {
                                        ++resultCount;
                                    } else {
                                        SelectorRow row = new SelectorRow(columns, this.evaluator, selector.getSelectorName(), (Node)objectNode, (double)node.getScore());
                                        if (filter.evaluate((Object)row)) {
                                            if ((hasFacets & 2) == 0) {
                                                if (externalSort) {
                                                    rowList.add((Row)row);
                                                } else {
                                                    if (currentNode >= offset && currentNode - offset < limit) {
                                                        rows.put(node.getNodeId().toString(), row);
                                                        ++addedNodes;
                                                    }
                                                    ++currentNode;
                                                    if (addedNodes == limit) break;
                                                }
                                            }
                                            if ((hasFacets & 1) == 1) {
                                                bitset.set(infos.getDocNumber());
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        catch (PathNotFoundException e) {
                        }
                        catch (ItemNotFoundException e) {}
                    }
                } else if ((hasFacets & 2) == 0 && !isCount && !externalSort && !infos.getMainNodeUuid().equals(node.getNodeId().toString()) && rows.containsKey(infos.getMainNodeUuid())) {
                    rows.put(infos.getMainNodeUuid(), rows.remove(infos.getMainNodeUuid()));
                }
                node = hits.nextScoreNode();
            }
            if (rowList == null) {
                rowList = rows != null ? new LinkedList(rows.values()) : new LinkedList();
            }
            if ((hasFacets & 1) == 1) {
                OpenBitSetDISI docIdSet = new OpenBitSetDISI(new DocIdBitSet(bitset).iterator(), bitset.size());
                FacetHandler h = new FacetHandler(columns, selector, (OpenBitSet)docIdSet, this.index, this.session, this.nsMappings);
                h.handleFacets(reader);
                rowList.add(0, h.getFacetsRow());
            } else if (isCount) {
                boolean wasApproxLimitReached = false;
                if (countType.isApproxCount() && hitsSize > countType.getApproxCountLimit()) {
                    resultCount = hitsSize * resultCount / countType.getApproxCountLimit();
                    resultCount = (int)Math.ceil(MathUtils.round((float)resultCount, (int)(resultCount < 1000 ? -1 : (resultCount < 10000 ? -2 : -3)), (int)0));
                    wasApproxLimitReached = true;
                }
                rowList.add(0, CountHandler.createCountRow(resultCount, wasApproxLimitReached));
            }
            LinkedList<Row> linkedList = rowList;
            return linkedList;
        }
        finally {
            if (hits != null) {
                hits.close();
            }
            Util.closeOrRelease((IndexReader)reader);
        }
    }

    private boolean checkIndexedAcl(Map<String, Boolean> checkedAcls, IndexedNodeInfo infos) throws RepositoryException {
        boolean canRead = true;
        Object[] acls = infos.getAclUuid() != null ? Patterns.SPACE.split(infos.getAclUuid()) : ArrayUtils.EMPTY_STRING_ARRAY;
        ArrayUtils.reverse((Object[])acls);
        for (Object acl : acls) {
            Boolean aclChecked;
            if (((String)acl).contains("/")) {
                String singleUser = StringUtils.substringAfter((String)acl, (String)"/");
                acl = StringUtils.substringBefore((String)acl, (String)"/");
                if (singleUser.contains("/")) {
                    String roles = StringUtils.substringBeforeLast((String)singleUser, (String)"/");
                    if (!(singleUser = StringUtils.substringAfterLast((String)singleUser, (String)"/")).equals(this.session.getUserID())) continue;
                    for (String role : StringUtils.split((String)roles, (char)'/')) {
                        if (!((JahiaAccessManager)this.session.getAccessControlManager()).matchPermission(Sets.newHashSet((Object[])new String[]{"{http://www.jcp.org/jcr/1.0}read_" + this.session.getWorkspace().getName()}), role)) continue;
                        return true;
                    }
                } else if (!singleUser.equals(this.session.getUserID())) continue;
            }
            if ((aclChecked = checkedAcls.get(acl)) == null) {
                try {
                    canRead = this.session.getAccessManager().canRead(null, (ItemId)new NodeId((String)acl));
                    checkedAcls.put((String)acl, canRead);
                }
                catch (RepositoryException e) {}
                break;
            }
            canRead = aclChecked;
            break;
        }
        return canRead;
    }

    public boolean isAclUuidInIndex() {
        return this.index instanceof JahiaSearchIndex && ((JahiaSearchIndex)this.index).isAddAclUuidInIndex();
    }

    private IndexedNodeInfo getIndexedNodeInfo(ScoreNode sn, IndexReader reader, boolean onlyMainNodeUuid) throws IOException {
        IndexedNodeInfo info = new IndexedNodeInfo(sn.getDoc(reader));
        Document doc = reader.document(info.getDocNumber(), onlyMainNodeUuid ? ONLY_MAIN_NODE_UUID : OPTIMIZATION_FIELDS);
        if (doc.getField(JahiaNodeIndexer.TRANSLATED_NODE_PARENT) != null) {
            info.setMainNodeUuid(doc.getField(FieldNames.PARENT).stringValue());
        } else {
            info.setMainNodeUuid(sn.getNodeId().toString());
        }
        if (!onlyMainNodeUuid) {
            Field[] checkInvalidLanguagesField;
            Field publishedField;
            Field checkVisibilityField;
            Field aclUuidField;
            if (this.isAclUuidInIndex() && (aclUuidField = doc.getField(JahiaNodeIndexer.ACL_UUID)) != null) {
                info.setAclUuid(aclUuidField.stringValue());
            }
            if ((checkVisibilityField = doc.getField(JahiaNodeIndexer.CHECK_VISIBILITY)) != null) {
                info.setCheckVisibility(checkVisibilityField.stringValue());
            }
            if ((publishedField = doc.getField(JahiaNodeIndexer.PUBLISHED)) != null) {
                info.setPublished(publishedField.stringValue());
            }
            if ((checkInvalidLanguagesField = doc.getFields(JahiaNodeIndexer.INVALID_LANGUAGES)) != null && checkInvalidLanguagesField.length > 0) {
                for (Field field : checkInvalidLanguagesField) {
                    info.addInvalidLanguages(field.stringValue());
                }
            }
        }
        return info;
    }

    protected Query getNodeIdQuery(String field, String path) throws RepositoryException {
        BooleanQuery or = null;
        try {
            if (!field.equals(FieldNames.PARENT)) {
                return super.getNodeIdQuery(field, path);
            }
            JackrabbitTermQuery q1 = new JackrabbitTermQuery(new Term(FieldNames.PARENT, this.session.getNode(path).getIdentifier()));
            JackrabbitTermQuery q2 = new JackrabbitTermQuery(new Term(JahiaNodeIndexer.TRANSLATED_NODE_PARENT, this.session.getNode(path).getIdentifier()));
            or = new BooleanQuery();
            or.add((Query)q1, BooleanClause.Occur.SHOULD);
            or.add((Query)q2, BooleanClause.Occur.SHOULD);
        }
        catch (AccessDeniedException e) {
            return new JackrabbitTermQuery(new Term(FieldNames.UUID, "invalid-node-id"));
        }
        catch (PathNotFoundException e) {
            return new JackrabbitTermQuery(new Term(FieldNames.UUID, "invalid-node-id"));
        }
        return or;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Query getFullTextSearchQuery(FullTextSearch fts) throws RepositoryException {
        Query qobj = null;
        if (!StringUtils.startsWith((String)fts.getPropertyName(), (String)"rep:filter(")) return super.getFullTextSearchQuery(fts);
        try {
            StaticOperand expr = fts.getFullTextSearchExpression();
            if (!(expr instanceof Literal)) throw new RepositoryException("Unknown static operand type: " + expr);
            String expression = ((Literal)expr).getLiteralValue().getString();
            qobj = this.resolveSingleMixedInclusiveExclusiveRangeQuery(expression);
            if (qobj != null) return qobj;
            JahiaQueryParser qp = new JahiaQueryParser(FieldNames.FULLTEXT, (Analyzer)new KeywordAnalyzer());
            qp.setLowercaseExpandedTerms(false);
            return qp.parse(expression);
        }
        catch (ParseException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    private Query resolveSingleMixedInclusiveExclusiveRangeQuery(String expression) {
        Query qobj = null;
        boolean inclusiveEndRange = expression.endsWith("]");
        boolean exclusiveEndRange = expression.endsWith("}");
        int inclusiveBeginRangeCount = StringUtils.countMatches((String)expression, (String)"[");
        int exclusiveBeginRangeCount = StringUtils.countMatches((String)expression, (String)"{");
        if (inclusiveEndRange && exclusiveBeginRangeCount == 1 && inclusiveBeginRangeCount == 0 || exclusiveEndRange && inclusiveBeginRangeCount == 1 && exclusiveBeginRangeCount == 0) {
            String fieldName;
            String string = inclusiveEndRange || exclusiveEndRange ? StringUtils.substringBefore((String)expression, (String)(inclusiveEndRange ? ":{" : ":[")) : (fieldName = "");
            if (fieldName.indexOf(32) == -1) {
                fieldName = fieldName.replace("\\:", ":");
                String rangeExpression = StringUtils.substringBetween((String)expression, (String)(inclusiveEndRange ? "{" : "["), (String)(inclusiveEndRange ? "]" : "}"));
                String part1 = StringUtils.substringBefore((String)rangeExpression, (String)" TO");
                String part2 = StringUtils.substringAfter((String)rangeExpression, (String)"TO ");
                SchemaField sf = new SchemaField(fieldName, (FieldType)JahiaQueryParser.STRING_TYPE);
                qobj = JahiaQueryParser.STRING_TYPE.getRangeQuery(null, sf, part1.equals("*") ? null : part1, part2.equals("*") ? null : part2, !inclusiveEndRange, inclusiveEndRange);
            }
        }
        return qobj;
    }

    protected Predicate mapConstraintToQueryAndFilter(LuceneQueryFactory.QueryPair query, Constraint constraint, Map<String, NodeType> selectorMap, JackrabbitIndexSearcher searcher, IndexReader reader) throws RepositoryException, IOException {
        try {
            if (constraint instanceof DescendantNode && !((DescendantNode)constraint).getAncestorPath().equals("/")) {
                query.subQuery.add((Query)new TermQuery(new Term(JahiaNodeIndexer.TRANSLATED_NODE_PARENT, this.session.getNode(((DescendantNode)constraint).getAncestorPath()).getParent().getIdentifier())), BooleanClause.Occur.MUST_NOT);
            } else if (constraint instanceof ChildNode && !((ChildNode)constraint).getParentPath().equals("/")) {
                query.subQuery.add((Query)new TermQuery(new Term(JahiaNodeIndexer.TRANSLATED_NODE_PARENT, this.session.getNode(((ChildNode)constraint).getParentPath()).getParent().getIdentifier())), BooleanClause.Occur.MUST_NOT);
            }
        }
        catch (AccessDeniedException e) {
        }
        catch (PathNotFoundException e) {
            query.subQuery.add((Query)new JackrabbitTermQuery(new Term(FieldNames.UUID, "invalid-node-id")), BooleanClause.Occur.MUST);
        }
        return super.mapConstraintToQueryAndFilter(query, constraint, selectorMap, searcher, reader);
    }

    public Locale getLocale() {
        if (this.queryLanguage != null) {
            return LanguageCodeConverters.languageCodeToLocale(this.queryLanguage);
        }
        return this.locale;
    }

    public void setQueryLanguageAndLocale(String queryLanguage, Locale locale) {
        this.queryLanguage = queryLanguage;
        this.locale = locale;
    }

    protected Query getComparisonQuery(DynamicOperand left, int transform, String operator, StaticOperand rigth, Map<String, NodeType> selectorMap) throws RepositoryException {
        PropertyValue pv;
        if (left instanceof PropertyValue && (pv = (PropertyValue)left).getPropertyName().equals("_PARENT")) {
            return new JackrabbitTermQuery(new Term(FieldNames.PARENT, this.getValueString(this.evaluator.getValue(rigth), 9)));
        }
        return super.getComparisonQuery(left, transform, operator, rigth, selectorMap);
    }

    protected Analyzer getTextAnalyzer() {
        Analyzer analyzer;
        String lang;
        AnalyzerRegistry analyzerRegistry;
        if ((this.locale != null || this.queryLanguage != null) && (analyzerRegistry = this.index.getAnalyzerRegistry()).acceptKey((Object)(lang = this.getLocale().toString())) && (analyzer = analyzerRegistry.getAnalyzer((Object)lang)) != null) {
            return analyzer;
        }
        return super.getTextAnalyzer();
    }

    class LazySelectorRow
    extends SelectorRow {
        private Node node;
        private NodeId nodeId;

        LazySelectorRow(Map<String, PropertyValue> columns, OperandEvaluator evaluator, String selector, NodeId nodeId, double score) {
            super(columns, evaluator, selector, null, score);
            this.nodeId = nodeId;
        }

        LazySelectorRow(Map<String, PropertyValue> columns, OperandEvaluator evaluator, String selector, Node node, double score) {
            super(columns, evaluator, selector, node, score);
            this.node = node;
        }

        public Node getNode() {
            try {
                if (this.node == null) {
                    NodeImpl originalNode = JahiaLuceneQueryFactoryImpl.this.session.getNodeById(this.nodeId);
                    if (originalNode.isNodeType("jnt:translation")) {
                        originalNode = originalNode.getParent();
                    }
                    if (originalNode != null) {
                        this.node = originalNode;
                    }
                }
            }
            catch (ItemNotFoundException e) {
            }
            catch (PathNotFoundException e) {
            }
            catch (RepositoryException e) {
                logger.error("Cannot get node " + this.nodeId, (Throwable)e);
            }
            return this.node;
        }

        public Node getNode(String selectorName) throws RepositoryException {
            super.getNode(selectorName);
            return this.getNode();
        }
    }

    class IndexedNodeInfo {
        private int docNumber;
        private String mainNodeUuid;
        private String aclUuid;
        private String checkVisibility;
        private String published;
        private List<String> checkInvalidLanguages = null;

        public IndexedNodeInfo(int docNumber) {
            this.docNumber = docNumber;
        }

        public String getMainNodeUuid() {
            return this.mainNodeUuid;
        }

        public void setMainNodeUuid(String mainNodeUuid) {
            this.mainNodeUuid = mainNodeUuid;
        }

        public String getAclUuid() {
            return this.aclUuid;
        }

        public void setAclUuid(String aclUuid) {
            this.aclUuid = aclUuid;
        }

        public String getCheckVisibility() {
            return this.checkVisibility;
        }

        public void setCheckVisibility(String checkVisibility) {
            this.checkVisibility = checkVisibility;
        }

        public String getPublished() {
            return this.published;
        }

        public void setPublished(String published) {
            this.published = published;
        }

        public int getDocNumber() {
            return this.docNumber;
        }

        public List<String> getCheckInvalidLanguages() {
            return this.checkInvalidLanguages;
        }

        public void addInvalidLanguages(String invalidLanguage) {
            if (this.checkInvalidLanguages == null) {
                this.checkInvalidLanguages = new ArrayList<String>();
            }
            this.checkInvalidLanguages.add(invalidLanguage);
        }
    }
}

