/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.qom.QueryObjectModel;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.query.ExecutableQuery;
import org.apache.jackrabbit.core.query.JahiaQueryObjectModelImpl;
import org.apache.jackrabbit.core.query.QueryHandler;
import org.apache.jackrabbit.core.query.lucene.AnalyzerRegistry;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.FieldSelectors;
import org.apache.jackrabbit.core.query.lucene.IndexFormatVersion;
import org.apache.jackrabbit.core.query.lucene.IndexingConfiguration;
import org.apache.jackrabbit.core.query.lucene.IndexingConfigurationImpl;
import org.apache.jackrabbit.core.query.lucene.JackrabbitAnalyzer;
import org.apache.jackrabbit.core.query.lucene.JahiaIndexingConfigurationImpl;
import org.apache.jackrabbit.core.query.lucene.JahiaNodeIndexer;
import org.apache.jackrabbit.core.query.lucene.JahiaQueryImpl;
import org.apache.jackrabbit.core.query.lucene.LanguageCustomizingAnalyzerRegistry;
import org.apache.jackrabbit.core.query.lucene.NamespaceMappings;
import org.apache.jackrabbit.core.query.lucene.SearchIndex;
import org.apache.jackrabbit.core.query.lucene.Util;
import org.apache.jackrabbit.core.query.lucene.constraint.NoDuplicatesConstraint;
import org.apache.jackrabbit.core.query.lucene.hits.AbstractHitCollector;
import org.apache.jackrabbit.core.session.SessionContext;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.jackrabbit.spi.commons.query.QueryNodeFactory;
import org.apache.jackrabbit.spi.commons.query.qom.QueryObjectModelTree;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.shiro.util.StringUtils;
import org.apache.tika.parser.Parser;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.settings.SettingsBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaSearchIndex
extends SearchIndex {
    private static final Logger log = LoggerFactory.getLogger(JahiaSearchIndex.class);
    private static final Name JNT_ACL = NameFactoryImpl.getInstance().create("http://www.jahia.org/jahia/nt/1.0", "acl");
    private static final Name JNT_ACE = NameFactoryImpl.getInstance().create("http://www.jahia.org/jahia/nt/1.0", "ace");
    private int maxClauseCount = 1024;
    private Boolean versionIndex;
    private int batchSize = 100;
    private boolean addAclUuidInIndex = true;
    private Set<String> typesUsingOptimizedACEIndexation = new HashSet<String>();

    public int getMaxClauseCount() {
        return this.maxClauseCount;
    }

    public void setMaxClauseCount(int maxClauseCount) {
        this.maxClauseCount = maxClauseCount;
        BooleanQuery.setMaxClauseCount((int)maxClauseCount);
    }

    protected AnalyzerRegistry getAnalyzerRegistry() {
        IndexingConfiguration indexingConfig = this.getIndexingConfig();
        if (indexingConfig instanceof JahiaIndexingConfigurationImpl) {
            JahiaIndexingConfigurationImpl config = (JahiaIndexingConfigurationImpl)indexingConfig;
            return config.getAnalyzerRegistry();
        }
        return super.getAnalyzerRegistry();
    }

    protected IndexingConfiguration createIndexingConfiguration(NamespaceMappings namespaceMappings) {
        IndexingConfiguration configuration = super.createIndexingConfiguration(namespaceMappings);
        if (configuration instanceof JahiaIndexingConfigurationImpl) {
            JahiaIndexingConfigurationImpl jahiaConfiguration = (JahiaIndexingConfigurationImpl)configuration;
            LanguageCustomizingAnalyzerRegistry registry = jahiaConfiguration.getAnalyzerRegistry();
            Analyzer analyzer = super.getTextAnalyzer();
            registry.setDefaultAnalyzer(analyzer);
            SettingsBean settings = SettingsBean.getInstance();
            Locale defaultLocale = settings.getDefaultLocale();
            Analyzer specific = registry.getAnalyzer(defaultLocale.toString());
            if (specific == null) {
                specific = registry.getAnalyzer(defaultLocale.getLanguage());
            }
            if (specific != null) {
                if (analyzer instanceof JackrabbitAnalyzer) {
                    JackrabbitAnalyzer jrAnalyzer = (JackrabbitAnalyzer)analyzer;
                    jrAnalyzer.setDefaultAnalyzer(specific);
                } else {
                    throw new IllegalArgumentException("Analyzer wasn't a JackrabbitAnalyzer. Couldn't set default language Analyzer as a consequence.");
                }
            }
        }
        return configuration;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void updateNodes(Iterator<NodeId> remove, Iterator<NodeState> add) throws RepositoryException, IOException {
        if (this.isVersionIndex()) {
            super.updateNodes(remove, add);
            return;
        }
        ArrayList<NodeState> addList = new ArrayList<NodeState>();
        ArrayList<NodeId> removeList = new ArrayList<NodeId>();
        HashSet<NodeId> removedIds = new HashSet<NodeId>();
        HashSet<NodeId> addedIds = new HashSet<NodeId>();
        ArrayList<NodeId> aclChangedList = new ArrayList<NodeId>();
        boolean hasAclOrAce = false;
        while (add.hasNext()) {
            NodeState state = add.next();
            if (state == null) continue;
            addedIds.add(state.getNodeId());
            addList.add(state);
            if (hasAclOrAce || !JNT_ACL.equals(state.getNodeTypeName()) && !JNT_ACE.equals(state.getNodeTypeName())) continue;
            hasAclOrAce = true;
        }
        while (remove.hasNext()) {
            NodeId nodeId = remove.next();
            removedIds.add(nodeId);
            removeList.add(nodeId);
        }
        if (this.isAddAclUuidInIndex() && hasAclOrAce) {
            ItemStateManager itemStateManager = this.getContext().getItemStateManager();
            for (NodeState node : new ArrayList(addList)) {
                try {
                    NodeState acl;
                    NodeState nodeParent;
                    if (JNT_ACL.equals(node.getNodeTypeName())) {
                        NodeState nodeParent2 = (NodeState)itemStateManager.getItemState((ItemId)node.getParentId());
                        this.addIdToBeIndexed(nodeParent2.getNodeId(), addedIds, removedIds, addList, removeList);
                        this.recurseTreeForAclIdSetting(nodeParent2, addedIds, removedIds, aclChangedList, itemStateManager);
                    }
                    if (!JNT_ACE.equals(node.getNodeTypeName()) || !this.canUseOptimizedACEIndexation(nodeParent = (NodeState)itemStateManager.getItemState((ItemId)(acl = (NodeState)itemStateManager.getItemState((ItemId)node.getParentId())).getParentId()))) continue;
                    this.addIdToBeIndexed(nodeParent.getNodeId(), addedIds, removedIds, addList, removeList);
                    this.recurseTreeForAclIdSetting(nodeParent, addedIds, removedIds, aclChangedList, itemStateManager);
                }
                catch (ItemStateException e) {
                    log.warn("ACL_UUID field in documents may not be updated, so access rights check in search may not work correctly", (Throwable)e);
                }
            }
        }
        long timer = System.currentTimeMillis();
        super.updateNodes(removeList.iterator(), addList.iterator());
        if (log.isDebugEnabled()) {
            log.debug("Re-indexed nodes in {} ms: {} removed, {} added", new Object[]{System.currentTimeMillis() - timer, removeList.size(), addList.size()});
        }
        if (!aclChangedList.isEmpty()) {
            int aclSubListEnd = Math.min(aclChangedList.size(), this.batchSize);
            for (int aclSubListStart = 0; aclSubListStart < aclChangedList.size(); aclSubListStart += this.batchSize) {
                if (aclSubListStart > 0) {
                    Thread.yield();
                }
                ArrayList<NodeState> aclAddList = new ArrayList<NodeState>();
                ArrayList<NodeId> aclRemoveList = new ArrayList<NodeId>();
                for (NodeId node : aclChangedList.subList(aclSubListStart, aclSubListEnd)) {
                    try {
                        this.addIdToBeIndexed(node, addedIds, removedIds, aclAddList, aclRemoveList);
                    }
                    catch (ItemStateException e) {
                        log.warn("ACL_UUID field in document for nodeId '" + node.toString() + "' may not be updated, so access rights check in search may not work correctly", (Throwable)e);
                    }
                }
                super.updateNodes(aclRemoveList.iterator(), aclAddList.iterator());
                aclSubListEnd = Math.min(aclChangedList.size(), aclSubListEnd + this.batchSize);
            }
            if (log.isDebugEnabled()) {
                log.debug("Re-indexed {} nodes after ACL change in {} ms", new Object[]{aclChangedList.size(), System.currentTimeMillis() - timer});
            }
        }
    }

    private void recurseTreeForAclIdSetting(NodeState node, Set<NodeId> addedIds, Set<NodeId> removedIds, List<NodeId> aclChangedList, ItemStateManager itemStateManager) {
        for (ChildNodeEntry childNodeEntry : node.getChildNodeEntries()) {
            try {
                PropertyId propId;
                PropertyState ps;
                NodeState childNode = (NodeState)this.getContext().getItemStateManager().getItemState((ItemId)childNodeEntry.getId());
                boolean breakInheritance = false;
                if (childNode.hasPropertyName(JahiaNodeIndexer.J_ACL_INHERITED) && (ps = (PropertyState)itemStateManager.getItemState((ItemId)(propId = new PropertyId((NodeId)childNode.getId(), JahiaNodeIndexer.J_ACL_INHERITED)))).getValues().length == 1 && ps.getValues()[0].getBoolean()) {
                    breakInheritance = true;
                }
                if (breakInheritance) continue;
                if (!addedIds.contains(childNodeEntry.getId()) && !removedIds.contains(childNodeEntry.getId())) {
                    aclChangedList.add(childNodeEntry.getId());
                }
                this.recurseTreeForAclIdSetting(childNode, addedIds, removedIds, aclChangedList, itemStateManager);
            }
            catch (ItemStateException e) {
                log.warn("ACL_UUID field in document for nodeId '{}' may not be updated, so access rights check in search may not work correctly", (Object)childNodeEntry.getId().toString());
                log.debug("Exception when checking for creating ACL_UUID in index", (Throwable)e);
            }
            catch (RepositoryException e) {
                log.warn("ACL_UUID field in document for nodeId '{}' may not be updated, so access rights check in search may not work correctly", (Object)childNodeEntry.getId().toString());
                log.debug("Exception when checking for creating ACL_UUID in index", (Throwable)e);
            }
        }
    }

    private void addIdToBeIndexed(NodeId id, Set<NodeId> addedIds, Set<NodeId> removedIds, List<NodeState> addList, List<NodeId> removeList) throws ItemStateException {
        if (!removedIds.contains(id) && !addedIds.contains(id)) {
            removeList.add(id);
            removedIds.add(id);
        }
        if (!addedIds.contains(id) && this.getContext().getItemStateManager().hasItemState((ItemId)id)) {
            addList.add((NodeState)this.getContext().getItemStateManager().getItemState((ItemId)id));
            addedIds.add(id);
        }
    }

    protected Document createDocument(NodeState node, NamespaceMappings nsMappings, IndexFormatVersion indexFormatVersion) throws RepositoryException {
        JahiaNodeIndexer indexer = JahiaNodeIndexer.createNodeIndexer(node, this.getContext().getItemStateManager(), nsMappings, this.getContext().getExecutor(), this.getParser(), this.getContext());
        indexer.setSupportHighlighting(this.getSupportHighlighting());
        indexer.setIndexingConfiguration(this.getIndexingConfig());
        indexer.setIndexFormatVersion(indexFormatVersion);
        indexer.setMaxExtractLength(this.getMaxExtractLength());
        indexer.setSupportSpellchecking(this.getSpellCheckerClass() != null);
        indexer.setAddAclUuidInIndex(this.addAclUuidInIndex);
        indexer.setUseOptimizedACEIndexation(this.canUseOptimizedACEIndexation(node));
        Document doc = indexer.createDoc();
        this.mergeAggregatedNodeIndexes(node, doc, indexFormatVersion);
        return doc;
    }

    private boolean canUseOptimizedACEIndexation(NodeState currentNode) throws RepositoryException {
        ExtendedNodeType nodeType = NodeTypeRegistry.getProviderNodeTypeRegistry().getNodeType(JahiaNodeIndexer.getTypeNameAsString(currentNode.getNodeTypeName(), (NamespaceRegistry)this.getContext().getNamespaceRegistry()));
        for (String type : this.typesUsingOptimizedACEIndexation) {
            if (!nodeType.isNodeType(type)) continue;
            return true;
        }
        return false;
    }

    public QueryObjectModel createQueryObjectModel(SessionContext sessionContext, QueryObjectModelTree qomTree, String language, Node node) throws RepositoryException {
        JahiaQueryObjectModelImpl query = new JahiaQueryObjectModelImpl();
        query.init(sessionContext, (QueryHandler)this, qomTree, language, node);
        return query;
    }

    public ExecutableQuery createExecutableQuery(SessionContext sessionContext, String statement, String language) throws InvalidQueryException {
        JahiaQueryImpl query = new JahiaQueryImpl(sessionContext, this, this.getContext().getPropertyTypeRegistry(), statement, language, (QueryNodeFactory)this.getQueryNodeFactory());
        query.setConstraint(new NoDuplicatesConstraint());
        query.setRespectDocumentOrder(this.getRespectDocumentOrder());
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<NodeId> getWeaklyReferringNodes(NodeId id) throws RepositoryException, IOException {
        final ArrayList docs = new ArrayList();
        ArrayList<NodeId> ids = new ArrayList<NodeId>();
        IndexReader reader = this.getIndexReader(false);
        try {
            IndexSearcher searcher = new IndexSearcher(reader);
            try {
                TermQuery q = new TermQuery(new Term(FieldNames.WEAK_REFS, id.toString()));
                searcher.search((Query)q, (Collector)new AbstractHitCollector(){

                    public void collect(int doc, float score) {
                        docs.add(doc);
                    }
                });
            }
            finally {
                searcher.close();
            }
            for (Integer doc : docs) {
                Document d = reader.document(doc.intValue(), FieldSelectors.UUID);
                ids.add(new NodeId(d.get(FieldNames.UUID)));
            }
        }
        finally {
            Util.closeOrRelease((IndexReader)reader);
        }
        return ids;
    }

    private boolean isVersionIndex() {
        if (this.versionIndex == null) {
            this.versionIndex = this.getIndexingConfigurationClass().equals(IndexingConfigurationImpl.class.getName());
        }
        return this.versionIndex;
    }

    public boolean isAddAclUuidInIndex() {
        return this.addAclUuidInIndex;
    }

    public void setAddAclUuidInIndex(boolean addAclUuidInIndex) {
        this.addAclUuidInIndex = addAclUuidInIndex;
    }

    public Set<String> getTypesUsingOptimizedACEIndexation() {
        return this.typesUsingOptimizedACEIndexation;
    }

    public void setTypesUsingOptimizedACEIndexation(String typesUsingOptimizedACEIndexation) {
        this.typesUsingOptimizedACEIndexation = Sets.newHashSet((Object[])StringUtils.split((String)typesUsingOptimizedACEIndexation));
    }

    protected Parser createParser() {
        return null;
    }
}

