/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene.constraint;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.JahiaNodeIndexer;
import org.apache.jackrabbit.core.query.lucene.ScoreNode;
import org.apache.jackrabbit.core.query.lucene.constraint.Constraint;
import org.apache.jackrabbit.core.query.lucene.constraint.EvaluationContext;
import org.apache.jackrabbit.spi.Name;
import org.apache.lucene.document.Document;

public class NoDuplicatesConstraint
implements Constraint {
    private Set<String> ids = new HashSet<String>();

    public boolean evaluate(ScoreNode[] row, Name[] selectorNames, EvaluationContext context) throws IOException {
        StringBuilder idBuilder = new StringBuilder(1024);
        for (ScoreNode sn : row) {
            if (sn == null) {
                idBuilder.append("null");
                continue;
            }
            int docNb = sn.getDoc(context.getIndexReader());
            Document doc = context.getIndexReader().document(docNb);
            if (doc.getField(JahiaNodeIndexer.TRANSLATED_NODE_PARENT) != null) {
                idBuilder.append(doc.getField(FieldNames.PARENT).stringValue());
                continue;
            }
            idBuilder.append(sn.getNodeId().toString());
        }
        String id = idBuilder.toString();
        return this.ids.add(id);
    }
}

