/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene.join;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.Row;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.DynamicOperand;
import javax.jcr.query.qom.EquiJoinCondition;
import javax.jcr.query.qom.Join;
import javax.jcr.query.qom.Literal;
import javax.jcr.query.qom.Operand;
import javax.jcr.query.qom.PropertyValue;
import javax.jcr.query.qom.QueryObjectModelFactory;
import javax.jcr.query.qom.StaticOperand;
import org.apache.jackrabbit.commons.query.qom.OperandEvaluator;
import org.apache.jackrabbit.core.query.lucene.join.EquiJoinMerger;

public class JahiaEquiJoinMerger
extends EquiJoinMerger {
    private final PropertyValue leftProperty;
    private final PropertyValue rightProperty;
    private boolean includeTranslationNode = false;

    public JahiaEquiJoinMerger(Join join, Map<String, PropertyValue> columns, OperandEvaluator evaluator, QueryObjectModelFactory factory, EquiJoinCondition condition) throws RepositoryException {
        super(join, columns, evaluator, factory, condition);
        PropertyValue property1 = factory.propertyValue(condition.getSelector1Name(), condition.getProperty1Name());
        PropertyValue property2 = factory.propertyValue(condition.getSelector2Name(), condition.getProperty2Name());
        if (this.leftSelectors.contains(property1.getSelectorName()) && this.rightSelectors.contains(property2.getSelectorName())) {
            this.leftProperty = property1;
            this.rightProperty = property2;
        } else if (this.leftSelectors.contains(property2.getSelectorName()) && this.rightSelectors.contains(property1.getSelectorName())) {
            this.leftProperty = property2;
            this.rightProperty = property1;
        } else {
            throw new RepositoryException("Invalid equi-join");
        }
    }

    public List<Constraint> getRightJoinConstraints(Collection<Row> leftRows) throws RepositoryException {
        return this.isIncludeTranslationNode() ? this.getRightJoinConstraintsWithTranslation(leftRows) : super.getRightJoinConstraints(leftRows);
    }

    public List<Constraint> getRightJoinConstraintsWithTranslation(Collection<Row> leftRows) throws RepositoryException {
        HashMap<String, Literal> literals = new HashMap<String, Literal>();
        for (Row leftRow : leftRows) {
            for (Value value : this.evaluator.getValues((Operand)this.leftProperty, leftRow)) {
                literals.put(value.getString(), this.factory.literal(value));
            }
        }
        ArrayList<Constraint> constraints = new ArrayList<Constraint>(literals.size());
        for (Literal literal : literals.values()) {
            constraints.add((Constraint)this.factory.comparison((DynamicOperand)this.rightProperty, "jcr.operator.equal.to", (StaticOperand)literal));
            constraints.add((Constraint)this.factory.comparison((DynamicOperand)this.factory.propertyValue(this.rightProperty.getSelectorName(), "_PARENT"), "jcr.operator.equal.to", (StaticOperand)literal));
        }
        return constraints;
    }

    public boolean isIncludeTranslationNode() {
        return this.includeTranslationNode;
    }

    public void setIncludeTranslationNode(boolean includeTranslationNode) {
        this.includeTranslationNode = includeTranslationNode;
    }
}

