/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security;

import java.io.Serializable;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.AccessDeniedException;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NamespaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.Privilege;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.security.auth.Subject;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.api.security.authorization.PrivilegeManager;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.JahiaRepositoryImpl;
import org.apache.jackrabbit.core.RepositoryContext;
import org.apache.jackrabbit.core.config.WorkspaceConfig;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.security.AMContext;
import org.apache.jackrabbit.core.security.AbstractAccessControlManager;
import org.apache.jackrabbit.core.security.AccessManager;
import org.apache.jackrabbit.core.security.JahiaPrivilegeRegistry;
import org.apache.jackrabbit.core.security.JahiaSystemSession;
import org.apache.jackrabbit.core.security.SystemPrincipal;
import org.apache.jackrabbit.core.security.authorization.AccessControlProvider;
import org.apache.jackrabbit.core.security.authorization.PrivilegeRegistry;
import org.apache.jackrabbit.core.security.authorization.WorkspaceAccessManager;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.DefaultNamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.PathFactoryImpl;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.apache.jackrabbit.spi.commons.namespace.SessionNamespaceResolver;
import org.jahia.exceptions.JahiaInitializationException;
import org.jahia.jaas.JahiaPrincipal;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.cache.CacheService;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.impl.jackrabbit.SpringJackrabbitRepository;
import org.jahia.services.render.filter.cache.CacheClusterEvent;
import org.jahia.services.render.filter.cache.ModuleCacheProvider;
import org.jahia.services.usermanager.JahiaGroup;
import org.jahia.services.usermanager.JahiaGroupManagerService;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.settings.SettingsBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaAccessManager
extends AbstractAccessControlManager
implements AccessManager,
AccessControlManager {
    private static final Logger logger = LoggerFactory.getLogger(JahiaAccessManager.class);
    private static final Map<String, Map<String, String>> PRIVILEGE_NAMES = new ConcurrentHashMap<String, Map<String, String>>(2);
    private static final Subject SYSTEM_SUBJECT = new Subject(true, new HashSet<SystemPrincipal>(Arrays.asList(new SystemPrincipal())), Collections.EMPTY_SET, Collections.EMPTY_SET);
    protected Subject subject;
    protected HierarchyManager hierMgr;
    protected NamePathResolver resolver;
    private JahiaPrivilegeRegistry privilegeRegistry;
    private boolean initialized = false;
    protected String workspaceName;
    private JahiaUserManagerService userService;
    private JahiaGroupManagerService groupService;
    protected JahiaPrincipal jahiaPrincipal = null;
    private Session securitySession;
    private Session defaultWorkspaceSecuritySession;
    private RepositoryContext repositoryContext;
    private WorkspaceConfig workspaceConfig;
    private static volatile org.jahia.services.cache.Cache<String, Set<Privilege>> privilegesInRole = null;
    private static volatile org.jahia.services.cache.Cache<String, Boolean> matchingPermissions = null;
    private Map<String, Boolean> pathPermissionCache = null;
    private Map<String, CompiledAcl> compiledAcls = new HashMap<String, CompiledAcl>();
    private Boolean isAdmin = null;
    private static ThreadLocal<Collection<String>> deniedPathes = new ThreadLocal();
    private boolean isAliased = false;
    private JahiaUser jahiaUser;
    private boolean globalGroupMembershipCheckActivated = false;
    private DefaultNamePathResolver pr;
    private static final Pattern REFERENCE_FIELD_LANGUAGE_PATTERN = Pattern.compile("(.*)j:referenceInField_.*_([a-z]{2}(_[A-Z]{2})?)_[0-9]+([/].*)?$");
    private static final Pattern TRANSLATION_LANGUAGE_PATTERN = Pattern.compile("(.*)j:translation_([a-z]{2}(_[A-Z]{2})?)([/].*)?$");

    public static String getPrivilegeName(String privilegeName, String workspace) {
        String name;
        if (workspace == null) {
            return privilegeName;
        }
        Map<String, String> wsp = PRIVILEGE_NAMES.get(workspace);
        if (wsp == null) {
            wsp = new ConcurrentHashMap<String, String>();
            PRIVILEGE_NAMES.put(workspace, wsp);
        }
        if ((name = wsp.get(privilegeName)) == null) {
            name = privilegeName + "_" + workspace;
            wsp.put(privilegeName, name);
        }
        return name;
    }

    public static void setDeniedPaths(Collection<String> denied) {
        deniedPathes.set(denied);
    }

    public JahiaAccessManager() {
        CacheService cacheService;
        if (privilegesInRole == null && (cacheService = ServicesRegistry.getInstance().getCacheService()) != null) {
            try {
                privilegesInRole = cacheService.getCache("org.jahia.security.privilegesInRolesCache", true);
            }
            catch (JahiaInitializationException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if (matchingPermissions == null && (cacheService = ServicesRegistry.getInstance().getCacheService()) != null) {
            try {
                matchingPermissions = cacheService.getCache("org.jahia.security.matchingPermissions", true);
            }
            catch (JahiaInitializationException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void init(AMContext amContext) throws AccessDeniedException, Exception {
        this.init(amContext, null, null, null, null);
    }

    public void init(AMContext amContext, AccessControlProvider acProvider, WorkspaceAccessManager wspAccessManager) throws AccessDeniedException, Exception {
        this.init(amContext, null, null, null, null);
    }

    public Session getSecuritySession() throws RepositoryException {
        if (this.securitySession != null) {
            return this.securitySession;
        }
        this.securitySession = new JahiaSystemSession(this.repositoryContext, SYSTEM_SUBJECT, this.workspaceConfig);
        return this.securitySession;
    }

    public Session getDefaultWorkspaceSecuritySession() throws RepositoryException {
        if (this.workspaceConfig.getName().equals("default")) {
            return this.getSecuritySession();
        }
        if (this.defaultWorkspaceSecuritySession != null) {
            return this.defaultWorkspaceSecuritySession;
        }
        this.defaultWorkspaceSecuritySession = new JahiaSystemSession(this.repositoryContext, SYSTEM_SUBJECT, this.repositoryContext.getRepository().getConfig().getWorkspaceConfig("default"));
        return this.defaultWorkspaceSecuritySession;
    }

    public boolean isSystemPrincipal() {
        return this.jahiaPrincipal != null && this.jahiaPrincipal.isSystem();
    }

    public void init(AMContext context, AccessControlProvider acProvider, WorkspaceAccessManager wspAccessManager, RepositoryContext repositoryContext, WorkspaceConfig workspaceConfig) throws AccessDeniedException, Exception {
        if (this.initialized) {
            throw new IllegalStateException("already initialized");
        }
        this.pathPermissionCache = Collections.synchronizedMap(new LRUMap(SettingsBean.getInstance().getAccessManagerPathPermissionCacheMaxSize()));
        this.globalGroupMembershipCheckActivated = SettingsBean.getInstance().isGlobalGroupMembershipCheckActivated();
        this.subject = context.getSubject();
        this.resolver = context.getNamePathResolver();
        this.hierMgr = context.getHierarchyManager();
        this.workspaceName = context.getWorkspaceName();
        this.repositoryContext = repositoryContext;
        this.workspaceConfig = workspaceConfig;
        this.privilegeRegistry = new JahiaPrivilegeRegistry(context.getSession().getWorkspace().getNamespaceRegistry());
        Set<JahiaPrincipal> principals = this.subject.getPrincipals(JahiaPrincipal.class);
        if (!principals.isEmpty()) {
            this.jahiaPrincipal = principals.iterator().next();
        }
        this.userService = ServicesRegistry.getInstance().getJahiaUserManagerService();
        this.groupService = ServicesRegistry.getInstance().getJahiaGroupManagerService();
        if (!this.jahiaPrincipal.isSystem() && !" guest ".equals(this.jahiaPrincipal.getName())) {
            this.jahiaUser = this.userService.lookupUser(this.jahiaPrincipal.getName());
        }
        SessionNamespaceResolver nr = new SessionNamespaceResolver(this.getSecuritySession());
        this.pr = new DefaultNamePathResolver((NamespaceResolver)nr, true);
        this.initialized = true;
    }

    public void close() throws Exception {
        if (this.securitySession != null) {
            this.securitySession.logout();
        }
        if (this.defaultWorkspaceSecuritySession != null) {
            this.defaultWorkspaceSecuritySession.logout();
        }
    }

    public void checkPermission(ItemId id, int actions) throws AccessDeniedException, ItemNotFoundException, RepositoryException {
        if (!this.isGranted(id, actions)) {
            throw new AccessDeniedException("Not sufficient privileges for permissions : " + actions + " on " + id);
        }
    }

    public void checkPermission(Path path, int permissions) throws AccessDeniedException, RepositoryException {
        if (!this.isGranted(path, permissions)) {
            throw new AccessDeniedException("Not sufficient privileges for permissions : " + permissions + " on " + path + " [" + deniedPathes.get() + "]");
        }
    }

    protected void checkPermission(String absPath, int permission) throws AccessDeniedException, PathNotFoundException, RepositoryException {
        this.checkValidNodePath(absPath);
        this.checkPermission(this.resolver.getQPath(absPath), permission);
    }

    public boolean hasPrivileges(String absPath, Set<Principal> principals, Privilege[] privileges) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        this.checkInitialized();
        this.checkValidNodePath(absPath);
        this.checkPermission(absPath, 32);
        if (privileges == null || privileges.length == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("No privileges passed -> allowed.");
            }
            return true;
        }
        int privs = PrivilegeRegistry.getBits((Privilege[])privileges);
        Path p = this.resolver.getQPath(absPath);
        return this.isGranted(p, privs);
    }

    protected void checkInitialized() throws IllegalStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
    }

    protected PrivilegeManager getPrivilegeManager() throws RepositoryException {
        return new PrivilegeManager(){

            public Privilege[] getRegisteredPrivileges() throws RepositoryException {
                return JahiaPrivilegeRegistry.getRegisteredPrivileges();
            }

            public Privilege getPrivilege(String privilegeName) throws AccessControlException, RepositoryException {
                return JahiaAccessManager.this.privilegeRegistry.getPrivilege(privilegeName, JahiaAccessManager.this.workspaceName);
            }

            public Privilege registerPrivilege(String privilegeName, boolean isAbstract, String[] declaredAggregateNames) throws AccessDeniedException, NamespaceException, RepositoryException {
                return null;
            }
        };
    }

    public void checkRepositoryPermission(int permissions) throws AccessDeniedException, RepositoryException {
        if (!this.isGranted(PathFactoryImpl.getInstance().getRootPath(), permissions)) {
            throw new AccessDeniedException("Access denied");
        }
    }

    protected void checkValidNodePath(String absPath) throws PathNotFoundException, RepositoryException {
        Path p = this.resolver.getQPath(absPath);
        if (!p.isAbsolute()) {
            throw new RepositoryException("Absolute path expected.");
        }
        if (this.hierMgr.resolveNodePath(p) == null) {
            throw new PathNotFoundException("No such node " + absPath);
        }
    }

    public AccessControlPolicy[] getEffectivePolicies(Set<Principal> principals) throws AccessDeniedException, AccessControlException, UnsupportedRepositoryOperationException, RepositoryException {
        return new AccessControlPolicy[0];
    }

    public Privilege[] getPrivileges(String absPath, Set<Principal> principals) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        return new Privilege[0];
    }

    public boolean isGranted(ItemId id, int actions) throws ItemNotFoundException, RepositoryException {
        if (this.isSystemPrincipal() && deniedPathes.get() == null) {
            return true;
        }
        HashSet<String> perm = new HashSet<String>();
        if ((actions & 1) == 1) {
            perm.add(JahiaAccessManager.getPrivilegeName("{http://www.jcp.org/jcr/1.0}read", this.workspaceName));
        }
        if ((actions & 2) == 2) {
            if (id.denotesNode()) {
                perm.add(JahiaAccessManager.getPrivilegeName("{http://www.jcp.org/jcr/1.0}addChildNodes", this.workspaceName));
            } else {
                perm.add(JahiaAccessManager.getPrivilegeName("{http://www.jcp.org/jcr/1.0}modifyProperties", this.workspaceName));
            }
        }
        if ((actions & 4) == 4) {
            perm.add(id.denotesNode() ? JahiaAccessManager.getPrivilegeName("{http://www.jcp.org/jcr/1.0}removeChildNodes", this.workspaceName) : JahiaAccessManager.getPrivilegeName("{http://www.jcp.org/jcr/1.0}removeNode", this.workspaceName));
        }
        Path path = this.hierMgr.getPath(id);
        return this.isGranted(path, perm);
    }

    public boolean isGranted(Path absPath, int permissions) throws RepositoryException {
        if (this.isSystemPrincipal() && deniedPathes.get() == null) {
            return true;
        }
        HashSet<String> privs = new HashSet<String>();
        if (permissions == 4 || permissions == 2 || permissions == 16) {
            String fullPath = this.pr.getJCRPath(absPath);
            if (permissions == 4 && (fullPath.contains("j:translation_") || fullPath.contains("j:referenceInField_"))) {
                permissions = 2;
            } else {
                absPath = absPath.getAncestor(1);
            }
        }
        for (Privilege privilege : this.privilegeRegistry.getPrivileges(permissions, this.workspaceName)) {
            privs.add(privilege.getName());
        }
        return this.isGranted(absPath, privs);
    }

    public boolean isGranted(Path absPath, Set<String> permissions) throws RepositoryException {
        if (this.isSystemPrincipal() && deniedPathes.get() == null) {
            return true;
        }
        String jcrPath = this.pr.getJCRPath(absPath);
        if (permissions.size() == 1 && jcrPath.equals("/") && permissions.contains(JahiaAccessManager.getPrivilegeName("{http://www.jcp.org/jcr/1.0}read", this.workspaceName))) {
            return true;
        }
        boolean res = false;
        String cacheKey = jcrPath + " : " + permissions;
        Boolean result = this.pathPermissionCache.get(cacheKey);
        if (result != null) {
            return result;
        }
        try {
            String childNodeName;
            Node n;
            PropertyIterator pi;
            if (deniedPathes.get() != null && deniedPathes.get().contains(jcrPath)) {
                this.pathPermissionCache.put(cacheKey, false);
                return false;
            }
            if (this.isSystemPrincipal()) {
                this.pathPermissionCache.put(cacheKey, true);
                return true;
            }
            Item i = null;
            Boolean itemExists = null;
            if ((permissions.contains(JahiaAccessManager.getPrivilegeName("{http://www.jcp.org/jcr/1.0}write", this.workspaceName)) || permissions.contains(JahiaAccessManager.getPrivilegeName("{http://www.jcp.org/jcr/1.0}modifyProperties", this.workspaceName)) || permissions.contains(JahiaAccessManager.getPrivilegeName("{http://www.jcp.org/jcr/1.0}removeNode", this.workspaceName))) && (itemExists = Boolean.valueOf(this.getSecuritySession().itemExists(jcrPath))).booleanValue() && (i = this.getSecuritySession().getItem(jcrPath)).isNode() && ((Node)i).isNodeType("jmix:systemNode")) {
                this.pathPermissionCache.put(cacheKey, false);
                return false;
            }
            if (this.jahiaPrincipal != null && this.isAdmin(this.jahiaPrincipal.getName(), 0)) {
                this.pathPermissionCache.put(cacheKey, true);
                return true;
            }
            int depth = 1;
            if (itemExists == null) {
                itemExists = this.getSecuritySession().itemExists(jcrPath);
            }
            if (!itemExists.booleanValue()) {
                this.pathPermissionCache.put(cacheKey, true);
                return true;
            }
            while (!itemExists.booleanValue()) {
                jcrPath = this.pr.getJCRPath(absPath.getAncestor(depth++));
                itemExists = this.getSecuritySession().itemExists(jcrPath);
            }
            if (i == null) {
                i = this.getSecuritySession().getItem(jcrPath);
            }
            if (i instanceof Version) {
                i = ((Version)i).getContainingHistory();
            }
            if (i instanceof VersionHistory && (pi = ((VersionHistory)i).getReferences()).hasNext()) {
                Property p = pi.nextProperty();
                i = p.getParent();
                jcrPath = i.getPath();
            }
            if (i.isNode()) {
                n = (Node)i;
            } else {
                n = i.getParent();
                jcrPath = StringUtils.substringBeforeLast((String)jcrPath, (String)"/");
            }
            if (permissions.contains(JahiaAccessManager.getPrivilegeName("{http://www.jcp.org/jcr/1.0}modifyProperties", this.workspaceName))) {
                String language;
                Matcher matcher;
                if (jcrPath.contains("j:translation_")) {
                    matcher = TRANSLATION_LANGUAGE_PATTERN.matcher(jcrPath);
                    if (matcher.matches()) {
                        language = matcher.group(2);
                        permissions.remove(JahiaAccessManager.getPrivilegeName("{http://www.jcp.org/jcr/1.0}modifyProperties", this.workspaceName));
                        permissions.add(JahiaAccessManager.getPrivilegeName("{http://www.jcp.org/jcr/1.0}modifyProperties", this.workspaceName) + "_" + language);
                    }
                } else if (jcrPath.contains("j:referenceInField_") && (matcher = REFERENCE_FIELD_LANGUAGE_PATTERN.matcher(jcrPath)).matches()) {
                    language = matcher.group(2);
                    permissions.remove(JahiaAccessManager.getPrivilegeName("{http://www.jcp.org/jcr/1.0}modifyProperties", this.workspaceName));
                    permissions.add(JahiaAccessManager.getPrivilegeName("{http://www.jcp.org/jcr/1.0}modifyProperties", this.workspaceName) + "_" + language);
                }
            }
            if (permissions.contains(JahiaAccessManager.getPrivilegeName("{http://www.jcp.org/jcr/1.0}addChildNodes", this.workspaceName)) && ((childNodeName = this.pr.getJCRName(absPath.getName())).startsWith("j:translation_") || childNodeName.startsWith("j:referenceInField_")) && this.hasPrivileges(jcrPath, new Privilege[]{this.privilegeFromName(JahiaAccessManager.getPrivilegeName("{http://www.jcp.org/jcr/1.0}modifyProperties", this.workspaceName))})) {
                return true;
            }
            String ntName = n.getPrimaryNodeType().getName();
            if (ntName.equals("jnt:acl") || ntName.equals("jnt:ace")) {
                if (permissions.contains(JahiaAccessManager.getPrivilegeName("{http://www.jcp.org/jcr/1.0}read", this.workspaceName))) {
                    permissions.add(JahiaAccessManager.getPrivilegeName("{http://www.jcp.org/jcr/1.0}readAccessControl", this.workspaceName));
                }
                if (permissions.contains(JahiaAccessManager.getPrivilegeName("{http://www.jcp.org/jcr/1.0}modifyProperties", this.workspaceName))) {
                    permissions.add(JahiaAccessManager.getPrivilegeName("{http://www.jcp.org/jcr/1.0}modifyAccessControl", this.workspaceName));
                }
            }
            String site = null;
            if (jcrPath.startsWith("/sites")) {
                if (jcrPath.length() > "/sites".length() + 1) {
                    site = StringUtils.substringBefore((String)jcrPath.substring("/sites".length() + 1), (String)"/");
                }
            } else {
                site = this.resolveSite(n);
            }
            res = this.recurseOnACPs(jcrPath, this.getSecuritySession(), permissions, site);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        this.pathPermissionCache.put(cacheKey, res);
        return res;
    }

    private String resolveSite(Node node) throws RepositoryException {
        while (!node.isNodeType("jnt:virtualsite")) {
            if (node.isNodeType("rep:root")) {
                return null;
            }
            node = node.getParent();
        }
        return node.getName();
    }

    public boolean isGranted(Path parentPath, Name childName, int permissions) throws RepositoryException {
        Path p = PathFactoryImpl.getInstance().create(parentPath, childName, true);
        return this.isGranted(p, permissions);
    }

    public boolean canRead(Path path, ItemId itemId) throws RepositoryException {
        if (path != null) {
            return this.isGranted(path, 1);
        }
        if (itemId != null) {
            return this.isGranted(itemId, 1);
        }
        return false;
    }

    public boolean canAccess(String workspaceName) throws RepositoryException {
        return true;
    }

    private boolean recurseOnACPs(String jcrPath, Session s, Set<String> permissions, String site) throws RepositoryException {
        HashSet<String> foundRoles = new HashSet<String>();
        permissions = new HashSet<String>(permissions);
        while (jcrPath.length() > 0) {
            CompiledAcl acl = this.compiledAcls.get(jcrPath);
            if (acl == null) {
                Node node;
                acl = new CompiledAcl();
                this.compiledAcls.put(jcrPath, acl);
                Item i = s.getItem(jcrPath);
                if (i.isNode() && (node = (Node)i).hasNode("j:acl")) {
                    Node aclNode = node.getNode("j:acl");
                    NodeIterator aces = aclNode.getNodes();
                    while (aces.hasNext()) {
                        Node aceNode = aces.nextNode();
                        try {
                            String role;
                            Value[] roleValues;
                            String principal = aceNode.getProperty("j:principal").getString();
                            if (!this.matchUser(principal, site)) continue;
                            CompiledAce ace = new CompiledAce();
                            acl.aces.add(ace);
                            ace.principal = principal;
                            boolean bl = ace.granted = !aceNode.getProperty("j:aceType").getString().equals("DENY");
                            if (aceNode.isNodeType("jnt:externalAce")) {
                                for (Value role1 : roleValues = aceNode.getProperty("j:roles").getValues()) {
                                    role = role1.getString();
                                    ace.roles.add(role + "/" + aceNode.getProperty("j:externalPermissionsName").getString());
                                }
                                continue;
                            }
                            for (Value role1 : roleValues = aceNode.getProperty("j:roles").getValues()) {
                                role = role1.getString();
                                ace.roles.add(role);
                            }
                        }
                        catch (RepositoryException e) {
                            logger.error("Can't read ACE " + aceNode.getPath(), (Throwable)e);
                        }
                    }
                    acl.broken = aclNode.hasProperty("j:inherit") && !aclNode.getProperty("j:inherit").getBoolean();
                }
            }
            for (CompiledAce perm : acl.aces) {
                for (String role : perm.roles) {
                    String key = perm.principal + ":" + role;
                    if (foundRoles.contains(key)) continue;
                    foundRoles.add(key);
                    if (!perm.granted || !this.matchPermission(permissions, role)) continue;
                    return true;
                }
            }
            if (acl.broken) {
                return false;
            }
            if ("/".equals(jcrPath)) {
                return false;
            }
            if (jcrPath.lastIndexOf(47) > 0) {
                jcrPath = jcrPath.substring(0, jcrPath.lastIndexOf(47));
                continue;
            }
            jcrPath = "/";
        }
        return false;
    }

    public Set<Privilege> getPermissionsInRole(String role) throws RepositoryException {
        if (privilegesInRole != null) {
            Set<Privilege> permsInRole = privilegesInRole.get(role);
            if (permsInRole == null) {
                permsInRole = this.internalGetPermissionsInRole(role);
                privilegesInRole.put(role, permsInRole);
            }
            return permsInRole;
        }
        return this.internalGetPermissionsInRole(role);
    }

    private Set<Privilege> internalGetPermissionsInRole(String role) throws RepositoryException {
        Node roleNode;
        String externalPermission = null;
        String roleName = role;
        if (roleName.contains("/")) {
            externalPermission = StringUtils.substringAfter((String)role, (String)"/");
            roleName = StringUtils.substringBefore((String)role, (String)"/");
        }
        Set<Privilege> privileges = (roleNode = this.findRoleNode(roleName)) != null ? this.getPrivileges(roleNode, externalPermission) : Collections.emptySet();
        return privileges;
    }

    private Node findRoleNode(String role) throws RepositoryException {
        try {
            NodeIterator nodes = this.getDefaultWorkspaceSecuritySession().getWorkspace().getQueryManager().createQuery("select * from [jnt:role] as r where localname()='" + role + "' and isdescendantnode(r,['/roles'])", "JCR-SQL2").execute().getNodes();
            if (nodes.hasNext()) {
                return nodes.nextNode();
            }
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        return null;
    }

    private Set<Privilege> getPrivileges(Node roleNode, String externalPermission) throws RepositoryException {
        HashSet<Privilege> privileges;
        block17: {
            Value[] perms;
            Session s;
            block16: {
                Value[] perms2;
                privileges = new HashSet();
                Node roleParent = roleNode.getParent();
                if (roleParent.isNodeType("jnt:role")) {
                    privileges = this.getPrivileges(roleParent, externalPermission);
                }
                if (externalPermission != null) {
                    if (roleNode.hasNode(externalPermission)) {
                        roleNode = roleNode.getNode(externalPermission);
                    } else {
                        return privileges;
                    }
                }
                s = roleNode.getSession();
                if (!roleNode.hasProperty("j:permissionNames")) break block16;
                for (Value value : perms2 = roleNode.getProperty("j:permissionNames").getValues()) {
                    try {
                        try {
                            Privilege privilege = this.privilegeRegistry.getPrivilege(value.getString(), null);
                            privileges.add(privilege);
                        }
                        catch (AccessControlException e) {
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug("Permission not available : " + value.getString(), (Throwable)e);
                        }
                    }
                    catch (RepositoryException e) {
                    }
                    catch (IllegalStateException e) {
                        // empty catch block
                    }
                }
                break block17;
            }
            if (!roleNode.hasProperty("j:permissions")) break block17;
            for (Value value : perms = roleNode.getProperty("j:permissions").getValues()) {
                try {
                    Node p = s.getNodeByIdentifier(value.getString());
                    try {
                        Privilege privilege = this.privilegeRegistry.getPrivilege(p);
                        privileges.add(privilege);
                    }
                    catch (AccessControlException e) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("Permission not available : " + p, (Throwable)e);
                    }
                }
                catch (RepositoryException e) {
                }
                catch (IllegalStateException e) {
                    // empty catch block
                }
            }
        }
        return privileges;
    }

    public boolean matchPermission(Set<String> permissions, String role) throws RepositoryException {
        Boolean cachedValue;
        int permissionsSize = permissions.size();
        StringBuilder stringBuilder = new StringBuilder(role);
        for (String permission : permissions) {
            stringBuilder.append(permission);
        }
        String entryKey = stringBuilder.toString();
        Boolean bl = cachedValue = this.isAliased ? null : matchingPermissions.get(entryKey);
        if (cachedValue == null) {
            Set<Privilege> permsInRole = this.getPermissionsInRole(role);
            if (logger.isDebugEnabled()) {
                logger.debug("Checking role {}", (Object)role);
            }
            for (Privilege privilege : permsInRole) {
                String privilegeName = privilege.getName();
                if (this.checkPrivilege(permissions, privilegeName, entryKey)) {
                    return true;
                }
                for (Privilege sub : privilege.getAggregatePrivileges()) {
                    if (!this.checkPrivilege(permissions, sub.getName(), entryKey)) continue;
                    return true;
                }
            }
            if (permissionsSize == permissions.size()) {
                matchingPermissions.put(entryKey, Boolean.FALSE);
            }
            return false;
        }
        if (cachedValue.booleanValue()) {
            permissions.clear();
            return true;
        }
        return false;
    }

    private boolean checkPrivilege(Set<String> permissions, String name, String cacheEntryKey) {
        if (!(this.isAliased && name.contains("_default") || !this.checkPrivilege(permissions, name))) {
            if (!this.isAliased) {
                matchingPermissions.put(cacheEntryKey, Boolean.TRUE);
            }
            return true;
        }
        return this.isAliased && name.contains("_live") && this.checkPrivilege(permissions, name.replaceAll("_live", "_" + this.workspaceName));
    }

    private boolean checkPrivilege(Set<String> permissions, String privilegeName) {
        if (permissions.contains(privilegeName)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Found privilege {}", (Object)privilegeName);
            }
            permissions.remove(privilegeName);
            if (permissions.isEmpty()) {
                return true;
            }
        }
        return false;
    }

    private boolean matchUser(String principal, String site) {
        String principalName = principal.substring(2);
        return principal.charAt(0) == 'u' ? this.jahiaPrincipal.isGuest() && principalName.equals("guest") || principalName.equals(this.jahiaPrincipal.getName()) : principal.charAt(0) == 'g' && (principalName.equals("guest") || !this.jahiaPrincipal.isGuest() && (this.isUserMemberOf(principalName, site) || this.globalGroupMembershipCheckActivated && this.isUserMemberOf(principalName, null)));
    }

    public boolean hasPrivileges(String absPath, Privilege[] privileges) throws PathNotFoundException, RepositoryException {
        this.checkInitialized();
        this.checkValidNodePath(absPath);
        if (privileges == null || privileges.length == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("No privileges passed -> allowed.");
            }
            return true;
        }
        HashSet<String> privs = new HashSet<String>();
        for (Privilege privilege : privileges) {
            privs.add(privilege.getName());
        }
        Path p = this.resolver.getQPath(absPath);
        return this.isGranted(p, privs);
    }

    public Privilege[] getPrivileges(String absPath) throws PathNotFoundException, RepositoryException {
        if (this.isAdmin(this.jahiaPrincipal.getName(), 0)) {
            return this.getSupportedPrivileges(absPath);
        }
        Set<String> grantedRoles = this.getRoles(absPath);
        HashSet<Privilege> results = new HashSet<Privilege>();
        for (String role : grantedRoles) {
            Set<Privilege> permissionsInRole = this.getPermissionsInRole(role);
            if (!permissionsInRole.isEmpty()) {
                results.addAll(permissionsInRole);
                continue;
            }
            logger.warn("Role " + role + " is missing despite still being in use in path " + absPath + " (or parent). Please re-create it in the administration, remove all uses and then you can delete it !");
        }
        return results.toArray(new Privilege[results.size()]);
    }

    public AccessControlPolicy[] getEffectivePolicies(String absPath) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        return new AccessControlPolicy[0];
    }

    public void setAliased(boolean aliased) {
        this.isAliased = aliased;
    }

    public boolean isAdmin(String username, int siteId) {
        if (this.isAdmin == null) {
            if (" guest ".equals(username)) {
                return false;
            }
            JahiaUser user = this.userService.lookupUser(username);
            if (user != null) {
                this.isAdmin = user.isAdminMember(siteId);
                return this.isAdmin;
            }
            this.isAdmin = false;
            return this.isAdmin;
        }
        return this.isAdmin;
    }

    private boolean isUserMemberOf(String groupname, String site) {
        if ("guest".equals(groupname)) {
            return true;
        }
        if ("users".equals(groupname) && site == null && !"guest".equals(this.jahiaPrincipal.getName())) {
            return true;
        }
        JahiaGroup group = this.groupService.lookupGroup(site, groupname);
        if (group == null) {
            group = this.groupService.lookupGroup(null, groupname);
        }
        return this.jahiaUser != null && group != null && group.isMember(this.jahiaUser);
    }

    public Set<String> getRoles(String absPath) throws PathNotFoundException, RepositoryException {
        HashSet<String> grantedRoles;
        block10: {
            grantedRoles = new HashSet<String>();
            HashSet<String> foundRoles = new HashSet<String>();
            Session s = this.getDefaultWorkspaceSecuritySession();
            Node n = s.getNode(absPath);
            String site = this.resolveSite(n);
            try {
                while (true) {
                    if (n.hasNode("j:acl")) {
                        Node acl = n.getNode("j:acl");
                        NodeIterator aces = acl.getNodes();
                        while (aces.hasNext()) {
                            Value[] roles;
                            String principal;
                            Node ace = aces.nextNode();
                            if (!ace.isNodeType("jnt:ace") || !this.matchUser(principal = ace.getProperty("j:principal").getString(), site)) continue;
                            boolean granted = ace.getProperty("j:aceType").getString().equals("GRANT");
                            String roleSuffix = "";
                            if (ace.isNodeType("jnt:externalAce")) {
                                roleSuffix = "/" + ace.getProperty("j:externalPermissionsName").getString();
                            }
                            for (Value r : roles = ace.getProperty("j:roles").getValues()) {
                                String role = r.getString();
                                if (foundRoles.contains(principal + ":" + role + roleSuffix)) continue;
                                if (granted) {
                                    grantedRoles.add(role + roleSuffix);
                                }
                                foundRoles.add(principal + ":" + role + roleSuffix);
                            }
                        }
                        if (acl.hasProperty("j:inherit") && !acl.getProperty("j:inherit").getBoolean()) {
                            return grantedRoles;
                        }
                    }
                    if (!n.getPath().equals("/")) {
                        n = n.getParent();
                        continue;
                    }
                    break;
                }
            }
            catch (ItemNotFoundException e) {
                if (!logger.isDebugEnabled()) break block10;
                logger.debug(e.getMessage(), (Throwable)e);
            }
        }
        return grantedRoles;
    }

    public static void flushPrivilegesInRoles() {
        if (privilegesInRole != null) {
            privilegesInRole.flush();
        }
        if (matchingPermissions != null) {
            Cache htmlCacheEventSync;
            matchingPermissions.flush();
            if (SettingsBean.getInstance().isClusterActivated() && (htmlCacheEventSync = JahiaAccessManager.getHtmlCacheEventSync()) != null) {
                htmlCacheEventSync.put(new Element((Serializable)((Object)("FLUSH_MATCHINGPERMISSIONS-" + UUID.randomUUID())), (Serializable)new CacheClusterEvent("", JahiaAccessManager.getClusterRevision())));
            }
        }
    }

    private static Cache getHtmlCacheEventSync() {
        Cache htmlCacheEventSync = null;
        try {
            htmlCacheEventSync = ModuleCacheProvider.getInstance().getSyncCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return htmlCacheEventSync;
    }

    private static long getClusterRevision() {
        return ((JahiaRepositoryImpl)((SpringJackrabbitRepository)JCRSessionFactory.getInstance().getDefaultProvider().getRepository()).getRepository()).getContext().getClusterNode().getRevision();
    }

    public static void flushMatchingPermissions() {
        if (matchingPermissions != null) {
            matchingPermissions.flush();
        }
    }

    private static class CacheKey
    implements Serializable {
        transient JahiaAccessManager accessManager;
        String roleName;

        private CacheKey(JahiaAccessManager accessManager, String roleName) {
            this.accessManager = accessManager;
            this.roleName = roleName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return !(this.roleName != null ? !this.roleName.equals(cacheKey.roleName) : cacheKey.roleName != null);
        }

        public int hashCode() {
            return this.roleName != null ? this.roleName.hashCode() : 0;
        }

        public String toString() {
            return this.roleName;
        }
    }

    class CompiledAce {
        String principal;
        Set<String> roles = new HashSet<String>();
        boolean granted;

        CompiledAce() {
        }
    }

    class CompiledAcl {
        boolean broken = false;
        Set<CompiledAce> aces = new HashSet<CompiledAce>();

        CompiledAcl() {
        }
    }
}

