/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security;

import java.security.Principal;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.Credentials;
import javax.jcr.SimpleCredentials;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.commons.id.IdentifierGenerator;
import org.apache.commons.id.IdentifierGeneratorFactory;
import org.apache.jackrabbit.core.security.AnonymousPrincipal;
import org.apache.jackrabbit.core.security.SystemPrincipal;
import org.apache.jackrabbit.core.security.principal.AdminPrincipal;
import org.jahia.jaas.JahiaPrincipal;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.services.usermanager.jcr.JCRUserManagerProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaLoginModule
implements LoginModule {
    private static final Logger logger = LoggerFactory.getLogger(JahiaLoginModule.class);
    public static final String SYSTEM = " system ";
    public static final String GUEST = " guest ";
    private static IdentifierGenerator idGen = IdentifierGeneratorFactory.newInstance().sessionIdGenerator();
    private static Map<String, Token> systemPass = new ConcurrentHashMap<String, Token>();
    private JahiaUserManagerService userService;
    private Subject subject;
    private Set<Principal> principals = new HashSet<Principal>();
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
        this.userService = ServicesRegistry.getInstance().getJahiaUserManagerService();
    }

    @Override
    public boolean login() throws LoginException {
        try {
            Callback[] callbacks = new Callback[]{new NameCallback("name?"), new PasswordCallback("pass?", false)};
            this.callbackHandler.handle(callbacks);
            String name = ((NameCallback)callbacks[0]).getName();
            char[] pass = ((PasswordCallback)callbacks[1]).getPassword();
            if (name != null) {
                if (SYSTEM.equals(name)) {
                    String key = new String(pass);
                    Token token = JahiaLoginModule.removeToken(name, key);
                    if (token != null) {
                        this.principals.add((Principal)new JahiaPrincipal(SYSTEM, true, false));
                        this.principals.add((Principal)new SystemPrincipal());
                    }
                } else if (name.startsWith(SYSTEM)) {
                    String key = new String(pass);
                    Token token = JahiaLoginModule.removeToken(name, key);
                    if (token != null) {
                        this.principals.add((Principal)new JahiaPrincipal(name.substring(SYSTEM.length()), true, false));
                        this.principals.add((Principal)new SystemPrincipal());
                    }
                } else if (GUEST.equals(name)) {
                    this.principals.add((Principal)new JahiaPrincipal(GUEST, false, true));
                    this.principals.add((Principal)new AnonymousPrincipal());
                } else {
                    String key = new String(pass);
                    Token token = JahiaLoginModule.removeToken(name, key);
                    JahiaUser user = null;
                    user = this.userService != null ? this.userService.lookupUser(name) : JCRUserManagerProvider.getInstance().lookupUser(name);
                    if (token != null || user.verifyPassword(key)) {
                        this.principals.add((Principal)new JahiaPrincipal(name));
                        if (user.isAdminMember(0)) {
                            this.principals.add((Principal)new AdminPrincipal(name));
                        }
                    }
                }
                if (this.principals.isEmpty()) {
                    throw new FailedLoginException();
                }
            }
        }
        catch (UnsupportedCallbackException e) {
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return !this.principals.isEmpty();
    }

    public static Token removeToken(String name, String key) {
        if (systemPass.get(key) != null && JahiaLoginModule.systemPass.get((Object)key).username.equals(name)) {
            return systemPass.remove(key);
        }
        return null;
    }

    public static Token getToken(String name, String key) {
        if (systemPass.get(key) != null && JahiaLoginModule.systemPass.get((Object)key).username.equals(name)) {
            return systemPass.get(key);
        }
        return null;
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.principals.isEmpty()) {
            return false;
        }
        this.subject.getPrincipals().addAll(this.principals);
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (this.principals.isEmpty()) {
            return false;
        }
        this.logout();
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().removeAll(this.principals);
        this.principals.clear();
        return true;
    }

    private static String getSystemPass(String user, List<String> deniedPathes) {
        String p = idGen.nextIdentifier().toString();
        systemPass.put(p, new Token(user, deniedPathes));
        return p;
    }

    public static Credentials getSystemCredentials() {
        return new SimpleCredentials(SYSTEM, JahiaLoginModule.getSystemPass(SYSTEM, null).toCharArray());
    }

    public static Credentials getSystemCredentials(String username) {
        if (username == null) {
            return JahiaLoginModule.getSystemCredentials();
        }
        return new SimpleCredentials(SYSTEM + username, JahiaLoginModule.getSystemPass(SYSTEM + username, null).toCharArray());
    }

    public static Credentials getSystemCredentials(String username, List<String> deniedPathes) {
        if (username == null) {
            return JahiaLoginModule.getSystemCredentials();
        }
        return new SimpleCredentials(SYSTEM + username, JahiaLoginModule.getSystemPass(SYSTEM + username, deniedPathes).toCharArray());
    }

    public static Credentials getGuestCredentials() {
        return new SimpleCredentials(GUEST, new char[0]);
    }

    public static Credentials getCredentials(String username) {
        return new SimpleCredentials(username, JahiaLoginModule.getSystemPass(username, null).toCharArray());
    }

    public static Credentials getCredentials(String username, List<String> deniedPathes) {
        return new SimpleCredentials(username, JahiaLoginModule.getSystemPass(username, deniedPathes).toCharArray());
    }

    public static class Token {
        public String username;
        public List<String> deniedPath;

        Token(String username, List<String> deniedPath) {
            this.username = username;
            this.deniedPath = deniedPath;
        }
    }
}

