/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.Privilege;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.core.security.JahiaAccessManager;
import org.apache.jackrabbit.core.security.PrivilegeImpl;
import org.jahia.services.content.JCRContentUtils;

public final class JahiaPrivilegeRegistry {
    private static Map<Integer, String> STANDARD_PRIVILEGES = new HashMap<Integer, String>();
    private static final Map<String, Privilege> map;
    private static Privilege[] registeredPrivileges;
    private NamespaceRegistry ns;

    public static void init(Session session) throws RepositoryException {
        JahiaPrivilegeRegistry.init(session, null);
    }

    public static void addModulePrivileges(Session session, String path) throws RepositoryException {
        JahiaPrivilegeRegistry.init(session, path);
    }

    private static void init(Session session, String path) throws RepositoryException {
        Node perms = session.getNode(path != null ? path + "/permissions" : "/permissions");
        HashSet<Privilege> privileges = new HashSet<Privilege>(20);
        JahiaPrivilegeRegistry.registerPrivileges(perms, privileges);
        for (Privilege p : privileges) {
            map.put(p.getName(), p);
        }
        registeredPrivileges = map.values().toArray(new Privilege[map.size()]);
    }

    public JahiaPrivilegeRegistry(NamespaceRegistry ns) {
        this.ns = ns;
    }

    private static Privilege registerPrivileges(Node node, Set<Privilege> privileges) throws RepositoryException {
        HashSet<Privilege> subPrivileges = new HashSet<Privilege>();
        NodeIterator ni = node.getNodes();
        while (ni.hasNext()) {
            Node subNode = (Node)ni.next();
            Privilege subPriv = JahiaPrivilegeRegistry.registerPrivileges(subNode, privileges);
            if (subPriv == null) continue;
            subPrivileges.add(subPriv);
        }
        try {
            String expandedName = JCRContentUtils.getExpandedName(node.getName(), node.getSession().getWorkspace().getNamespaceRegistry());
            boolean isAbstract = node.hasProperty("j:isAbstract") && node.getProperty("j:isAbstract").getBoolean();
            PrivilegeImpl priv = (PrivilegeImpl)map.get(expandedName);
            if (priv == null) {
                priv = new PrivilegeImpl(node.getName(), expandedName, isAbstract, subPrivileges, node.getPath());
            } else {
                priv.addPrivileges(subPrivileges);
            }
            privileges.add(priv);
            return priv;
        }
        catch (NamespaceException ne) {
            return null;
        }
    }

    public Set<Privilege> getPrivileges(int permissions, String workspace) throws AccessControlException, RepositoryException {
        HashSet<Privilege> r = new HashSet<Privilege>();
        for (Map.Entry<Integer, String> entry : STANDARD_PRIVILEGES.entrySet()) {
            if ((permissions & entry.getKey()) != entry.getKey()) continue;
            r.add(this.getPrivilege(entry.getValue(), workspace));
        }
        if ((permissions & 0x1000) == 4096) {
            r.add(this.getPrivilege(STANDARD_PRIVILEGES.get(4), workspace));
            r.add(this.getPrivilege(STANDARD_PRIVILEGES.get(8), workspace));
        }
        return r;
    }

    public static Privilege[] getRegisteredPrivileges() {
        return registeredPrivileges;
    }

    public Privilege getPrivilege(String privilegeName, String workspaceName) throws AccessControlException, RepositoryException {
        String s;
        Privilege privilege;
        if (!privilegeName.contains("{") && privilegeName.contains("/")) {
            privilegeName = StringUtils.substringAfterLast((String)privilegeName, (String)"/");
        }
        if ((privilege = map.get(s = JahiaAccessManager.getPrivilegeName(privilegeName = JCRContentUtils.getExpandedName(privilegeName, this.ns), workspaceName))) != null) {
            return privilege;
        }
        privilege = map.get(privilegeName);
        if (privilege != null) {
            return privilege;
        }
        throw new AccessControlException("Unknown privilege " + privilegeName);
    }

    public Privilege getPrivilege(Node node) throws AccessControlException, RepositoryException {
        String privilegeName = JCRContentUtils.getExpandedName(node.getName(), this.ns);
        Privilege privilege = map.get(privilegeName);
        if (privilege != null) {
            return privilege;
        }
        throw new AccessControlException("Unknown privilege " + privilegeName);
    }

    static {
        STANDARD_PRIVILEGES.put(1, "{http://www.jcp.org/jcr/1.0}read");
        STANDARD_PRIVILEGES.put(2, "{http://www.jcp.org/jcr/1.0}modifyProperties");
        STANDARD_PRIVILEGES.put(4, "{http://www.jcp.org/jcr/1.0}addChildNodes");
        STANDARD_PRIVILEGES.put(8, "{http://www.jcp.org/jcr/1.0}removeChildNodes");
        STANDARD_PRIVILEGES.put(16, "{http://www.jcp.org/jcr/1.0}modifyProperties");
        STANDARD_PRIVILEGES.put(32, "{http://www.jcp.org/jcr/1.0}readAccessControl");
        STANDARD_PRIVILEGES.put(64, "{http://www.jcp.org/jcr/1.0}modifyAccessControl");
        STANDARD_PRIVILEGES.put(128, "{http://www.jcp.org/jcr/1.0}nodeTypeManagement");
        STANDARD_PRIVILEGES.put(256, "{http://www.jcp.org/jcr/1.0}versionManagement");
        STANDARD_PRIVILEGES.put(512, "{http://www.jcp.org/jcr/1.0}lockManagement");
        STANDARD_PRIVILEGES.put(1024, "{http://www.jcp.org/jcr/1.0}lockManagement");
        STANDARD_PRIVILEGES.put(2048, "{http://www.jcp.org/jcr/1.0}retentionManagement");
        map = new LinkedHashMap<String, Privilege>();
    }
}

