/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee;

import java.io.IOException;
import java.util.List;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceFactory;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.apache.jackrabbit.webdav.DavServletRequest;
import org.apache.jackrabbit.webdav.DavServletResponse;
import org.apache.jackrabbit.webdav.DavSession;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.io.InputContext;
import org.apache.jackrabbit.webdav.io.OutputContext;
import org.apache.jackrabbit.webdav.jcr.JahiaRootCollection;
import org.apache.jackrabbit.webdav.jcr.JahiaServerRootCollection;
import org.apache.jackrabbit.webdav.jcr.JcrDavSession;
import org.apache.jackrabbit.webdav.lock.ActiveLock;
import org.apache.jackrabbit.webdav.lock.LockInfo;
import org.apache.jackrabbit.webdav.lock.LockManager;
import org.apache.jackrabbit.webdav.lock.Scope;
import org.apache.jackrabbit.webdav.lock.Type;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.PropEntry;
import org.apache.jackrabbit.webdav.simple.ResourceConfig;
import org.apache.jackrabbit.webdav.simple.ResourceFactoryImpl;
import org.apache.jackrabbit.webdav.version.DeltaVResource;
import org.apache.jackrabbit.webdav.version.LabelInfo;
import org.apache.jackrabbit.webdav.version.MergeInfo;
import org.apache.jackrabbit.webdav.version.OptionsInfo;
import org.apache.jackrabbit.webdav.version.OptionsResponse;
import org.apache.jackrabbit.webdav.version.UpdateInfo;
import org.apache.jackrabbit.webdav.version.VersionControlledResource;
import org.apache.jackrabbit.webdav.version.VersionHistoryResource;
import org.apache.jackrabbit.webdav.version.VersionResource;
import org.apache.jackrabbit.webdav.version.report.Report;
import org.apache.jackrabbit.webdav.version.report.ReportInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaResourceFactoryImpl
extends ResourceFactoryImpl {
    private static final Logger logger = LoggerFactory.getLogger(JahiaResourceFactoryImpl.class);
    private final LockManager lockMgr;

    public JahiaResourceFactoryImpl(LockManager lockMgr, ResourceConfig resourceConfig) {
        super(lockMgr, resourceConfig);
        this.lockMgr = lockMgr;
    }

    public DavResource createResource(DavResourceLocator locator, DavServletRequest request, DavServletResponse response) throws DavException {
        try {
            if (locator.isRootLocation()) {
                JahiaRootCollection jahiaRootCollection = new JahiaRootCollection(locator, (JcrDavSession)request.getDavSession(), (DavResourceFactory)this);
                jahiaRootCollection.addLockManager(this.lockMgr);
                return jahiaRootCollection;
            }
            if ("default".equals(locator.getWorkspaceName()) && "/repository".equals(locator.getRepositoryPath())) {
                JahiaServerRootCollection jahiaServerRootCollection = new JahiaServerRootCollection(locator, (JcrDavSession)request.getDavSession(), (DavResourceFactory)this);
                jahiaServerRootCollection.addLockManager(this.lockMgr);
                return jahiaServerRootCollection;
            }
            return this.createResource(super.createResource(locator, request, response), this.getNode(request.getDavSession(), locator.getRepositoryPath()));
        }
        catch (RepositoryException e) {
            throw new DavException(500, (Throwable)e);
        }
    }

    public DavResource createResource(DavResourceLocator locator, DavSession session) throws DavException {
        try {
            if (locator.isRootLocation()) {
                JahiaRootCollection jahiaRootCollection = new JahiaRootCollection(locator, (JcrDavSession)session, (DavResourceFactory)this);
                jahiaRootCollection.addLockManager(this.lockMgr);
                return jahiaRootCollection;
            }
            if ("default".equals(locator.getWorkspaceName()) && "/repository".equals(locator.getRepositoryPath())) {
                JahiaServerRootCollection jahiaServerRootCollection = new JahiaServerRootCollection(locator, (JcrDavSession)session, (DavResourceFactory)this);
                jahiaServerRootCollection.addLockManager(this.lockMgr);
                return jahiaServerRootCollection;
            }
            return this.createResource(super.createResource(locator, session), this.getNode(session, locator.getRepositoryPath()));
        }
        catch (RepositoryException e) {
            throw new DavException(500, (Throwable)e);
        }
    }

    public DavResource createResource(DavResource r, Node n) throws DavException {
        if (r instanceof VersionHistoryResource) {
            return new VersionHistoryResourceImpl((VersionHistoryResource)r, n);
        }
        if (r instanceof VersionResource) {
            return new VersionResourceImpl((VersionResource)r, n);
        }
        if (r instanceof VersionControlledResource) {
            return new VersionControlledResourceImpl((VersionControlledResource)r, n);
        }
        if (r instanceof DeltaVResource) {
            return new DeltaVResourceImpl((DeltaVResource)r, n);
        }
        return new DavResourceImpl(r, n);
    }

    private Node getNode(DavSession sessionImpl, String repoPath) throws RepositoryException {
        Node node = null;
        try {
            Session session;
            Item item;
            if (repoPath != null && (item = (session = ((JcrDavSession)sessionImpl).getRepositorySession()).getItem(repoPath)) instanceof Node) {
                node = (Node)item;
            }
        }
        catch (PathNotFoundException e) {
            // empty catch block
        }
        return node;
    }

    class VersionControlledResourceImpl
    extends DeltaVResourceImpl
    implements VersionControlledResource {
        VersionControlledResource resource;

        VersionControlledResourceImpl(VersionControlledResource resource, Node node) {
            super((DeltaVResource)resource, node);
            this.resource = resource;
        }

        public String checkin() throws DavException {
            return this.resource.checkin();
        }

        public void checkout() throws DavException {
            this.resource.checkout();
        }

        public void uncheckout() throws DavException {
            this.resource.uncheckout();
        }

        public MultiStatus update(UpdateInfo updateInfo) throws DavException {
            return this.resource.update(updateInfo);
        }

        public MultiStatus merge(MergeInfo mergeInfo) throws DavException {
            return this.resource.merge(mergeInfo);
        }

        public void label(LabelInfo labelInfo) throws DavException {
            this.resource.label(labelInfo);
        }

        public VersionHistoryResource getVersionHistory() throws DavException {
            return this.resource.getVersionHistory();
        }

        public void addVersionControl() throws DavException {
            this.resource.addVersionControl();
        }
    }

    class VersionHistoryResourceImpl
    extends DeltaVResourceImpl
    implements VersionHistoryResource {
        VersionHistoryResource resource;

        VersionHistoryResourceImpl(VersionHistoryResource resource, Node node) {
            super((DeltaVResource)resource, node);
            this.resource = resource;
        }

        public VersionResource[] getVersions() throws DavException {
            return this.resource.getVersions();
        }
    }

    class VersionResourceImpl
    extends DeltaVResourceImpl
    implements VersionResource {
        VersionResource resource;

        VersionResourceImpl(VersionResource resource, Node node) {
            super((DeltaVResource)resource, node);
            this.resource = resource;
        }

        public void label(LabelInfo labelInfo) throws DavException {
            this.resource.label(labelInfo);
        }

        public VersionHistoryResource getVersionHistory() throws DavException {
            return this.resource.getVersionHistory();
        }
    }

    class DeltaVResourceImpl
    extends DavResourceImpl
    implements DeltaVResource {
        DeltaVResource resource;

        DeltaVResourceImpl(DeltaVResource resource, Node node) {
            super((DavResource)resource, node);
            this.resource = resource;
        }

        public OptionsResponse getOptionResponse(OptionsInfo optionsInfo) {
            return this.resource.getOptionResponse(optionsInfo);
        }

        public Report getReport(ReportInfo reportInfo) throws DavException {
            return this.resource.getReport(reportInfo);
        }

        public void addWorkspace(DavResource workspace) throws DavException {
            this.resource.addWorkspace(workspace);
        }

        public DavResource[] getReferenceResources(DavPropertyName hrefPropertyName) throws DavException {
            return this.resource.getReferenceResources(hrefPropertyName);
        }
    }

    class DavResourceImpl
    implements DavResource {
        DavResource resource;
        Node node;

        DavResourceImpl(DavResource resource, Node node) {
            this.resource = resource;
            this.node = node;
        }

        public String getComplianceClass() {
            return this.resource.getComplianceClass();
        }

        public String getSupportedMethods() {
            return this.resource.getSupportedMethods();
        }

        public boolean exists() {
            return this.resource.exists();
        }

        public boolean isCollection() {
            return this.resource.isCollection();
        }

        public String getDisplayName() {
            return this.resource.getDisplayName();
        }

        public DavResourceLocator getLocator() {
            return this.resource.getLocator();
        }

        public String getResourcePath() {
            return this.resource.getResourcePath();
        }

        public String getHref() {
            return this.resource.getHref();
        }

        public long getModificationTime() {
            return this.resource.getModificationTime();
        }

        public void spool(OutputContext outputContext) throws IOException {
            this.resource.spool(outputContext);
        }

        public DavPropertyName[] getPropertyNames() {
            return this.resource.getPropertyNames();
        }

        public DavProperty<?> getProperty(DavPropertyName name) {
            return this.resource.getProperty(name);
        }

        public DavPropertySet getProperties() {
            return this.resource.getProperties();
        }

        public void setProperty(DavProperty<?> property) throws DavException {
            this.resource.setProperty(property);
        }

        public void removeProperty(DavPropertyName propertyName) throws DavException {
            this.resource.removeProperty(propertyName);
        }

        public MultiStatusResponse alterProperties(List<? extends PropEntry> changeList) throws DavException {
            return this.resource.alterProperties(changeList);
        }

        public DavResource getCollection() {
            return this.resource.getCollection();
        }

        public void addMember(DavResource resource, InputContext inputContext) throws DavException {
            this.resource.addMember(resource, inputContext);
        }

        public DavResourceIterator getMembers() {
            return this.resource.getMembers();
        }

        public void removeMember(DavResource member) throws DavException {
            this.resource.removeMember(member);
        }

        public void move(DavResource destination) throws DavException {
            try {
                if (this.node != null) {
                    this.node.checkout();
                    this.node.getParent().checkout();
                }
                String p = destination.getLocator().getRepositoryPath();
                p = p.substring(0, p.lastIndexOf(47));
                Node destNode = JahiaResourceFactoryImpl.this.getNode(destination.getSession(), p);
                if (destNode != null) {
                    destNode.checkout();
                }
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            this.resource.move(destination);
        }

        public void copy(DavResource destination, boolean shallow) throws DavException {
            this.resource.copy(destination, shallow);
        }

        public boolean isLockable(Type type, Scope scope) {
            return this.resource.isLockable(type, scope);
        }

        public boolean hasLock(Type type, Scope scope) {
            return this.resource.hasLock(type, scope);
        }

        public ActiveLock getLock(Type type, Scope scope) {
            return this.resource.getLock(type, scope);
        }

        public ActiveLock[] getLocks() {
            return this.resource.getLocks();
        }

        public ActiveLock lock(LockInfo reqLockInfo) throws DavException {
            return this.resource.lock(reqLockInfo);
        }

        public ActiveLock refreshLock(LockInfo reqLockInfo, String lockToken) throws DavException {
            return this.resource.refreshLock(reqLockInfo, lockToken);
        }

        public void unlock(String lockToken) throws DavException {
            block2: {
                try {
                    this.resource.unlock(lockToken);
                }
                catch (DavException e) {
                    if (e.getErrorCode() == 412) break block2;
                    throw e;
                }
            }
        }

        public void addLockManager(LockManager lockmgr) {
            this.resource.addLockManager(lockmgr);
        }

        public DavResourceFactory getFactory() {
            return this.resource.getFactory();
        }

        public DavSession getSession() {
            return this.resource.getSession();
        }
    }
}

