/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee;

import java.security.Principal;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.SimpleCredentials;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.jackrabbit.core.security.JahiaLoginModule;
import org.apache.jackrabbit.server.BasicCredentialsProvider;

public class JahiaSessionCredentials
extends BasicCredentialsProvider {
    public JahiaSessionCredentials(String s) {
        super(s);
    }

    public Credentials getCredentials(HttpServletRequest request) throws LoginException, ServletException {
        Principal jahiaUser = (Principal)request.getSession(true).getAttribute("org.jahia.usermanager.jahiauser");
        if (jahiaUser != null) {
            String n = jahiaUser.getName();
            if (n.startsWith("{")) {
                n = n.substring(n.indexOf(125) + 1);
            } else if (n.contains(":")) {
                n = n.substring(0, n.indexOf(58));
            }
            request.setAttribute("isGuest", (Object)Boolean.FALSE);
            return JahiaLoginModule.getCredentials(n);
        }
        SimpleCredentials c = (SimpleCredentials)super.getCredentials(request);
        if (c != null) {
            return c;
        }
        request.setAttribute("isGuest", (Object)Boolean.TRUE);
        return JahiaLoginModule.getGuestCredentials();
    }
}

