/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee;

import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.jackrabbit.j2ee.DavLocatorFactoryImpl;
import org.apache.jackrabbit.j2ee.JahiaResourceFactoryImpl;
import org.apache.jackrabbit.j2ee.JahiaSessionCredentials;
import org.apache.jackrabbit.j2ee.SimpleWebdavServlet;
import org.apache.jackrabbit.server.CredentialsProvider;
import org.apache.jackrabbit.server.SessionProvider;
import org.apache.jackrabbit.server.SessionProviderImpl;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavLocatorFactory;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceFactory;
import org.apache.jackrabbit.webdav.WebdavRequest;
import org.apache.jackrabbit.webdav.WebdavResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaWebdavServlet
extends SimpleWebdavServlet {
    private static final long serialVersionUID = 43821067248762234L;
    private static transient Logger logger = LoggerFactory.getLogger(JahiaWebdavServlet.class);
    private transient SessionProvider sessionProvider;
    private transient DavLocatorFactory locatorFactory;
    private static final String resourcePathPrefix = "/repository";

    public DavLocatorFactory getLocatorFactory() {
        if (this.locatorFactory == null) {
            this.locatorFactory = new DavLocatorFactoryImpl(resourcePathPrefix);
        }
        return this.locatorFactory;
    }

    public synchronized SessionProvider getSessionProvider() {
        if (this.sessionProvider == null) {
            this.sessionProvider = new SessionProviderImpl((CredentialsProvider)new JahiaSessionCredentials(""));
        }
        return this.sessionProvider;
    }

    protected boolean execute(WebdavRequest request, WebdavResponse response, int method, DavResource resource) throws ServletException, IOException, DavException {
        if (logger.isDebugEnabled()) {
            switch (method) {
                case 2: {
                    logger.debug("Calling GET method " + request.getPathTranslated());
                    break;
                }
                case 3: {
                    logger.debug("Calling HEAD method " + request.getPathTranslated());
                    break;
                }
                case 7: {
                    logger.debug("Calling PROPFIND method " + request.getPathTranslated());
                    break;
                }
                case 8: {
                    logger.debug("Calling PROPPATCH method " + request.getPathTranslated());
                    break;
                }
                case 4: {
                    logger.debug("Calling POST method " + request.getPathTranslated());
                    break;
                }
                case 6: {
                    logger.debug("Calling PUT method " + request.getPathTranslated());
                    break;
                }
                case 5: {
                    logger.debug("Calling DELETE method " + request.getPathTranslated());
                    break;
                }
                case 10: {
                    logger.debug("Calling COPY method " + request.getPathTranslated());
                    break;
                }
                case 11: {
                    logger.debug("Calling MOVE method " + request.getPathTranslated());
                    break;
                }
                case 9: {
                    logger.debug("Calling MKCOL method " + request.getPathTranslated());
                    break;
                }
                case 1: {
                    logger.debug("Calling OPTIONS method " + request.getPathTranslated());
                    break;
                }
                case 12: {
                    logger.debug("Calling LOCK method " + request.getPathTranslated());
                    break;
                }
                case 13: {
                    logger.debug("Calling UNLOCK method " + request.getPathTranslated());
                    break;
                }
                case 14: {
                    logger.debug("Calling ORDERPATCH method " + request.getPathTranslated());
                    break;
                }
                case 15: {
                    logger.debug("Calling SUBSCRIBE method " + request.getPathTranslated());
                    break;
                }
                case 16: {
                    logger.debug("Calling UNSUBSCRIBE method " + request.getPathTranslated());
                    break;
                }
                case 17: {
                    logger.debug("Calling POLL method " + request.getPathTranslated());
                    break;
                }
                case 18: {
                    logger.debug("Calling SEARCH method " + request.getPathTranslated());
                    break;
                }
                case 20: {
                    logger.debug("Calling VERSION method " + request.getPathTranslated());
                    break;
                }
                case 24: {
                    logger.debug("Calling LABEL method " + request.getPathTranslated());
                    break;
                }
                case 19: {
                    logger.debug("Calling REPORT method " + request.getPathTranslated());
                    break;
                }
                case 21: {
                    logger.debug("Calling CHECKIN method " + request.getPathTranslated());
                    break;
                }
                case 22: {
                    logger.debug("Calling CHECKOUT method " + request.getPathTranslated());
                    break;
                }
                case 23: {
                    logger.debug("Calling UNCHECKOUT method " + request.getPathTranslated());
                    break;
                }
                case 25: {
                    logger.debug("Calling MERGE method " + request.getPathTranslated());
                    break;
                }
                case 26: {
                    logger.debug("Calling UPDATE method " + request.getPathTranslated());
                    break;
                }
                case 27: {
                    logger.debug("Calling MKWORKSPACE method " + request.getPathTranslated());
                    break;
                }
                case 29: {
                    logger.debug("Calling MKACTIVITY method " + request.getPathTranslated());
                    break;
                }
                case 28: {
                    logger.debug("Calling BASELINE method " + request.getPathTranslated());
                    break;
                }
                case 30: {
                    logger.debug("Calling ACL method " + request.getPathTranslated());
                    break;
                }
                case 31: {
                    logger.debug("Calling REBIND method " + request.getPathTranslated());
                    break;
                }
                case 32: {
                    logger.debug("Calling UNBIND method " + request.getPathTranslated());
                    break;
                }
                case 33: {
                    logger.debug("Calling BIND method " + request.getPathTranslated());
                    break;
                }
                default: {
                    logger.debug("Call to unknown method");
                }
            }
        }
        if (method != 2 && Boolean.TRUE.equals(request.getAttribute("isGuest"))) {
            throw new DavException(401);
        }
        return super.execute(request, response, method, resource);
    }

    public void init() throws ServletException {
        super.init();
        this.setResourceFactory((DavResourceFactory)new JahiaResourceFactoryImpl(this.getLockManager(), this.getResourceConfig()));
    }
}

