/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.solr.schema.FieldType;
import org.apache.solr.search.function.DocValues;
import org.apache.solr.search.function.FieldCacheSource;
import org.apache.solr.search.function.StringIndexDocValues;
import org.apache.solr.search.function.ValueSource;

class DateFieldSource
extends FieldCacheSource {
    private static final long serialVersionUID = -9008658166881650393L;
    FieldType ft;
    private static int hcode = DateFieldSource.class.hashCode();

    public DateFieldSource(String name, FieldType ft) {
        super(name);
        this.ft = ft;
    }

    public String description() {
        return "date(" + this.field + ')';
    }

    public DocValues getValues(Map context, IndexReader reader) throws IOException {
        return new StringIndexDocValues((ValueSource)this, reader, this.field){

            protected String toTerm(String readableValue) {
                return DateFieldSource.this.ft.toInternal(readableValue);
            }

            public float floatVal(int doc) {
                return this.intVal(doc);
            }

            public int intVal(int doc) {
                int ord = this.order[doc];
                return ord;
            }

            public long longVal(int doc) {
                return this.intVal(doc);
            }

            public double doubleVal(int doc) {
                return this.intVal(doc);
            }

            public String strVal(int doc) {
                int ord = this.order[doc];
                return DateFieldSource.this.ft.indexedToReadable(this.lookup[ord]);
            }

            public String toString(int doc) {
                return DateFieldSource.this.description() + '=' + this.intVal(doc);
            }
        };
    }

    public boolean equals(Object o) {
        return o instanceof DateFieldSource && super.equals(o);
    }

    public int hashCode() {
        return hcode + super.hashCode();
    }
}

