/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.commons.server;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.server.rpc.RPC;
import com.google.gwt.user.server.rpc.RPCRequest;
import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.google.gwt.user.server.rpc.SerializationPolicy;
import com.google.gwt.user.server.rpc.SerializationPolicyProvider;
import java.lang.reflect.Method;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jahia.ajax.gwt.commons.server.RequestResponseAware;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

public class GWTController
extends RemoteServiceServlet
implements Controller,
ServletContextAware,
ApplicationContextAware {
    private static final long serialVersionUID = -74193665963116797L;
    private static final Logger logger = LoggerFactory.getLogger(GWTController.class);
    private String remoteServiceName;
    private Integer sessionExpiryTime = null;
    private ServletContext servletContext;
    private ApplicationContext applicationContext;
    private boolean allowPostMethodOnly = true;
    private boolean requireAuthenticatedUser = true;

    public void setSessionExpiryTime(int sessionExpiryTime) {
        this.sessionExpiryTime = sessionExpiryTime;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        long startTime = System.currentTimeMillis();
        if (this.allowPostMethodOnly && !"POST".equals(request.getMethod())) {
            response.sendError(404);
            return null;
        }
        if (this.requireAuthenticatedUser && JahiaUserManagerService.isGuest(JCRSessionFactory.getInstance().getCurrentUser())) {
            response.sendError(403);
            return null;
        }
        HttpSession session = request.getSession(false);
        if (session != null && this.sessionExpiryTime != null && session.getMaxInactiveInterval() != this.sessionExpiryTime * 60) {
            session.setMaxInactiveInterval(this.sessionExpiryTime * 60);
        }
        this.doPost(request, response);
        if (logger.isDebugEnabled()) {
            logger.debug("Handled request to GWT service '{}' in {} ms", (Object)this.remoteServiceName, (Object)(System.currentTimeMillis() - startTime));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String processCall(String payload) throws SerializationException {
        RemoteService remoteService = null;
        RPCRequest rpcRequest = null;
        try {
            remoteService = (RemoteService)this.applicationContext.getBean(this.remoteServiceName);
            this.setServiceData(remoteService, false);
            rpcRequest = RPC.decodeRequest((String)payload, remoteService.getClass(), (SerializationPolicyProvider)this);
            if (logger.isDebugEnabled()) {
                logger.debug("Executing method " + rpcRequest.getMethod());
            }
            String string = RPC.invokeAndEncodeResponse((Object)remoteService, (Method)rpcRequest.getMethod(), (Object[])rpcRequest.getParameters(), (SerializationPolicy)rpcRequest.getSerializationPolicy());
            return string;
        }
        catch (Exception e) {
            if (rpcRequest != null) {
                logger.error("An error occurred calling the GWT service method " + rpcRequest.getMethod() + ". Cause: " + e.getMessage(), (Throwable)e);
            } else {
                logger.error("An error occurred calling the GWT service " + (remoteService != null ? remoteService.getClass().getName() : this.remoteServiceName) + ". Cause: " + e.getMessage(), (Throwable)e);
            }
            String string = RPC.encodeResponseForFailure(null, (Throwable)e);
            return string;
        }
        finally {
            if (remoteService != null) {
                this.setServiceData(remoteService, true);
            }
        }
    }

    protected SerializationPolicy doGetSerializationPolicy(HttpServletRequest request, String moduleBaseURL, String strongName) {
        SerializationPolicy policy = super.doGetSerializationPolicy(request, moduleBaseURL, strongName);
        if (policy == null) {
            return new SerializationPolicy(){

                public boolean shouldDeserializeFields(Class<?> clazz) {
                    return clazz != Object.class;
                }

                public boolean shouldSerializeFields(Class<?> clazz) {
                    return clazz != Object.class;
                }

                public void validateDeserialize(Class<?> clazz) throws SerializationException {
                }

                public void validateSerialize(Class<?> clazz) throws SerializationException {
                }
            };
        }
        return policy;
    }

    public void setRemoteServiceName(String remoteServiceName) {
        this.remoteServiceName = remoteServiceName;
    }

    private void setServiceData(RemoteService remoteService, boolean cleanUp) {
        if (remoteService instanceof RequestResponseAware) {
            RequestResponseAware service = (RequestResponseAware)remoteService;
            service.setRequest(cleanUp ? null : this.getThreadLocalRequest());
            service.setResponse(cleanUp ? null : this.getThreadLocalResponse());
        }
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void log(String message, Throwable t) {
        logger.error(message, t);
    }

    public void log(String msg) {
        logger.info(msg);
    }

    public void setAllowPostMethodOnly(boolean allowPostMethodOnly) {
        this.allowPostMethodOnly = allowPostMethodOnly;
    }

    public void setRequireAuthenticatedUser(boolean requireAuthenticatedUser) {
        this.requireAuthenticatedUser = requireAuthenticatedUser;
    }
}

