/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.commons.server;

import org.atmosphere.client.TrackMessageSizeInterceptor;
import org.atmosphere.config.service.Disconnect;
import org.atmosphere.config.service.ManagedService;
import org.atmosphere.config.service.Post;
import org.atmosphere.config.service.Ready;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.gwt20.managed.AtmosphereMessageInterceptor;
import org.atmosphere.gwt20.server.GwtRpcInterceptor;
import org.atmosphere.interceptor.AtmosphereResourceLifecycleInterceptor;
import org.atmosphere.interceptor.BroadcastOnPostAtmosphereInterceptor;
import org.atmosphere.interceptor.IdleResourceInterceptor;
import org.atmosphere.interceptor.SuspendTrackerInterceptor;
import org.jahia.services.usermanager.JahiaUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedService(path="/atmosphere/rpc", interceptors={AtmosphereResourceLifecycleInterceptor.class, TrackMessageSizeInterceptor.class, GwtRpcInterceptor.class, SuspendTrackerInterceptor.class, AtmosphereMessageInterceptor.class, BroadcastOnPostAtmosphereInterceptor.class, IdleResourceInterceptor.class})
public class ManagedGWTResource {
    static final Logger logger = LoggerFactory.getLogger(ManagedGWTResource.class);
    public static final String GWT_BROADCASTER_ID = "org.jahia.broadcaster";

    @Ready
    public void onReady(AtmosphereResource r) {
        r.suspend();
        BroadcasterFactory.getDefault().lookup((Object)GWT_BROADCASTER_ID, true).addAtmosphereResource(r);
        JahiaUser user = (JahiaUser)r.getRequest().getSession(true).getAttribute("org.jahia.usermanager.jahiauser");
        if (user != null) {
            BroadcasterFactory.getDefault().lookup((Object)(GWT_BROADCASTER_ID + user.getName()), true).addAtmosphereResource(r);
        }
        logger.debug("Received RPC GET");
    }

    @Disconnect
    public void disconnected(AtmosphereResourceEvent event) {
        if (event.isCancelled()) {
            logger.info("User:" + event.getResource().uuid() + " unexpectedly disconnected");
        } else if (event.isClosedByClient() && logger.isDebugEnabled()) {
            logger.debug("User:" + event.getResource().uuid() + " closed the connection");
        }
    }

    @Post
    public void post(AtmosphereResource r) {
        if (logger.isDebugEnabled()) {
            logger.info("POST received with transport {}", (Object)r.transport());
        }
    }
}

