/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.commons.server.rpc;

import com.extjs.gxt.ui.client.data.BasePagingLoadResult;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.jahia.ajax.gwt.client.data.GWTJahiaGroup;
import org.jahia.ajax.gwt.client.data.GWTJahiaUser;
import org.jahia.ajax.gwt.client.service.UserManagerService;
import org.jahia.ajax.gwt.commons.server.JahiaRemoteService;
import org.jahia.data.viewhelper.principal.PrincipalViewHelper;
import org.jahia.exceptions.JahiaException;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.sites.JahiaSite;
import org.jahia.services.sites.JahiaSitesService;
import org.jahia.services.usermanager.JahiaGroup;
import org.jahia.services.usermanager.JahiaGroupManagerService;
import org.jahia.services.usermanager.JahiaPrincipal;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserManagerServiceImpl
extends JahiaRemoteService
implements UserManagerService {
    private static Logger logger = LoggerFactory.getLogger(UserManagerServiceImpl.class);
    private static final Pattern NBSP_PATTERN = Pattern.compile("&nbsp;");
    private static final Comparator<? super GWTJahiaUser> USERNAME_COMPARARTOR = new Comparator<GWTJahiaUser>(){

        @Override
        public int compare(GWTJahiaUser o1, GWTJahiaUser o2) {
            return o1.getUsername().compareTo(o2.getUsername());
        }
    };
    private static final Comparator<? super GWTJahiaGroup> GROUPNAME_COMPARATOR = new Comparator<GWTJahiaGroup>(){

        @Override
        public int compare(GWTJahiaGroup o1, GWTJahiaGroup o2) {
            return o1.getGroupname().compareTo(o2.getGroupname());
        }
    };
    private JahiaUserManagerService userManagerService;
    private JahiaGroupManagerService groupManagerService;
    private JahiaSitesService sitesService;

    public void setUserManagerService(JahiaUserManagerService userManagerService) {
        this.userManagerService = userManagerService;
    }

    public void setGroupManagerService(JahiaGroupManagerService groupManagerService) {
        this.groupManagerService = groupManagerService;
    }

    public void setSitesService(JahiaSitesService sitesService) {
        this.sitesService = sitesService;
    }

    public BasePagingLoadResult<GWTJahiaUser> searchUsers(String match, int offset, int limit, List<Integer> siteIds) {
        try {
            int size;
            Properties criterias = new Properties();
            criterias.setProperty("*", match);
            ArrayList<GWTJahiaUser> result = new ArrayList<GWTJahiaUser>();
            Set<Principal> users = this.userManagerService.searchUsers(criterias);
            if (users != null) {
                for (JahiaUser jahiaUser : users) {
                    String userName = PrincipalViewHelper.getDisplayName(jahiaUser, this.getUILocale());
                    GWTJahiaUser data = new GWTJahiaUser(jahiaUser.getUsername(), jahiaUser.getUserKey(), userName);
                    Properties p = jahiaUser.getProperties();
                    for (Object o : p.keySet()) {
                        data.set((String)o, p.get(o));
                    }
                    data.setProvider(jahiaUser.getProviderName());
                    result.add(data);
                }
            }
            if (offset > (size = result.size())) {
                result = new ArrayList();
                size = 0;
                offset = 0;
            } else {
                if (size > 1) {
                    Collections.sort(result, USERNAME_COMPARARTOR);
                }
                result = new ArrayList(result.subList(offset, Math.min(size, offset + limit)));
            }
            return new BasePagingLoadResult(result, offset, size);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public BasePagingLoadResult<GWTJahiaGroup> searchGroups(String match, int offset, int limit, List<Integer> siteIds) {
        try {
            List<Integer> sites = siteIds;
            if (sites == null || sites.size() == 0) {
                sites = new ArrayList<Integer>();
                sites.add(this.getSite().getID());
            }
            ArrayList<GWTJahiaGroup> result = new ArrayList<GWTJahiaGroup>();
            HashSet<JahiaGroup> groups = new HashSet<JahiaGroup>();
            for (Integer siteId : sites) {
                Properties criterias = new Properties();
                criterias.setProperty("groupname", match);
                Set<JahiaGroup> siteGroups = this.groupManagerService.searchGroups(siteId, criterias);
                if (siteGroups == null) continue;
                groups.addAll(siteGroups);
            }
            HashMap siteMap = new HashMap(sites.size());
            for (JahiaGroup group : groups) {
                if (group.isHidden()) continue;
                GWTJahiaGroup data = new GWTJahiaGroup(group.getGroupname(), group.getGroupKey(), PrincipalViewHelper.getDisplayName(group, this.getUILocale()));
                Integer siteId = group.getSiteID();
                if (siteId > 0) {
                    JahiaSite jahiaSite;
                    JahiaSite jahiaSite2 = jahiaSite = siteMap.containsKey(siteId) ? (JahiaSite)siteMap.get(siteId) : this.sitesService.getSite(siteId);
                    if (jahiaSite != null) {
                        data.setSiteName(jahiaSite.getTitle());
                    }
                }
                data.setSiteId(siteId);
                data.setProvider(group.getProviderName());
                result.add(data);
            }
            int size = result.size();
            if (offset > size) {
                result = new ArrayList();
                size = 0;
                offset = 0;
            } else {
                if (size > 1) {
                    Collections.sort(result, GROUPNAME_COMPARATOR);
                }
                result = new ArrayList(result.subList(offset, Math.min(size, offset + limit)));
            }
            BasePagingLoadResult pagingLoadResult = new BasePagingLoadResult(result, offset, size);
            return pagingLoadResult;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String[] getFormattedPrincipal(String userkey, char type, String[] textpattern) {
        PrincipalViewHelper pvh = new PrincipalViewHelper(textpattern);
        JahiaPrincipal p = type == 'u' ? ServicesRegistry.getInstance().getJahiaUserManagerService().lookupUserByKey(userkey) : ServicesRegistry.getInstance().getJahiaGroupManagerService().lookupGroup(userkey);
        String principalTextOption = pvh.getPrincipalTextOption(p);
        principalTextOption = NBSP_PATTERN.matcher(principalTextOption).replaceAll(" ");
        return new String[]{principalTextOption, pvh.getPrincipalValueOption(p)};
    }

    public BasePagingLoadResult<GWTJahiaUser> searchUsersInContext(String match, int offset, int limit, String context) {
        if (context != null) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            if (context.equals("currentSite")) {
                JCRSiteNode site = this.getSite();
                if (site != null) {
                    list.add(site.getID());
                }
            } else if (context.startsWith("site:")) {
                String sitekey = context.substring(5);
                try {
                    JahiaSite site = this.sitesService.getSiteByKey(sitekey);
                    if (site != null) {
                        list.add(site.getID());
                    }
                }
                catch (JahiaException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            } else if (context.startsWith("sharedOnly")) {
                list.add(0);
            }
            return this.searchUsers(match, offset, limit, list);
        }
        return null;
    }

    public BasePagingLoadResult<GWTJahiaGroup> searchGroupsInContext(String match, int offset, int limit, String context) {
        if (context != null) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            list.add(0);
            if (context.equals("currentSite")) {
                JCRSiteNode site = this.getSite();
                if (site != null) {
                    list.add(site.getID());
                }
            } else if (context.startsWith("site:")) {
                String sitekey = context.substring(5);
                try {
                    JahiaSite site = this.sitesService.getSiteByKey(sitekey);
                    if (site != null) {
                        list.add(site.getID());
                    }
                }
                catch (JahiaException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            return this.searchGroups(match, offset, limit, list);
        }
        return null;
    }
}

