/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeProperty;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeType;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.service.GWTJahiaServiceException;
import org.jahia.ajax.gwt.helper.ContentDefinitionHelper;
import org.jahia.ajax.gwt.helper.ContentManagerHelper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRStoreProvider;
import org.jahia.services.content.JCRStoreService;
import org.jahia.services.content.ProviderFactory;
import org.jahia.services.content.decorator.JCRMountPointNode;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.utils.i18n.Messages;

public class ContentHubHelper {
    private JCRSessionFactory sessionFactory;
    private JCRStoreService jcrStoreService;
    private ContentDefinitionHelper definitionHelper;
    private ContentManagerHelper contentManager;

    public void setSessionFactory(JCRSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public List<GWTJahiaNodeType> getProviderFactoriesType(Locale uiLocale) throws GWTJahiaServiceException {
        try {
            ArrayList<GWTJahiaNodeType> providerFactoriesType = new ArrayList<GWTJahiaNodeType>();
            for (ProviderFactory factory : this.jcrStoreService.getProviderFactories().values()) {
                ExtendedNodeType type = NodeTypeRegistry.getInstance().getNodeType(factory.getNodeTypeName());
                providerFactoriesType.add(this.definitionHelper.getGWTJahiaNodeType(type, uiLocale));
            }
            return providerFactoriesType;
        }
        catch (NoSuchNodeTypeException e) {
            throw new GWTJahiaServiceException((Throwable)e);
        }
    }

    public void mount(String mountName, String providerType, List<GWTJahiaNodeProperty> properties, JCRSessionWrapper session, Locale uiLocale) throws GWTJahiaServiceException {
        HashMap<String, String> parents = new HashMap<String, String>();
        parents.put("mounts", "jnt:systemFolder");
        GWTJahiaNode n = this.contentManager.createNode("/mounts", mountName, providerType, null, properties, session, uiLocale, parents, false);
        try {
            if (!((JCRMountPointNode)session.getNode(n.getPath())).checkMountPointValidity()) {
                n.removeAll();
                throw new GWTJahiaServiceException(Messages.getInternal("failure.mount.label", uiLocale) + " " + mountName);
            }
            session.save();
        }
        catch (RepositoryException e) {
            throw new GWTJahiaServiceException(Messages.getInternal("failure.mount.label", uiLocale) + " " + mountName);
        }
    }

    public void unmount(String path, JCRSessionWrapper session, Locale uiLocale) throws GWTJahiaServiceException {
        try {
            JCRStoreProvider provider = JCRSessionFactory.getInstance().getMountPoints().get(path);
            if (provider != null && provider.isDynamicallyMounted()) {
                provider.stop();
            }
            JCRNodeWrapper node = session.getNode(path);
            node.remove();
            session.save();
        }
        catch (RepositoryException e) {
            throw new GWTJahiaServiceException(Messages.getInternal("failure.unmount.label", uiLocale) + " " + path);
        }
    }

    public Map<String, String> getStoredPasswordsProviders(JahiaUser user) {
        HashMap<String, String> results = new HashMap<String, String>();
        results.put(null, user.getUsername());
        for (JCRStoreProvider provider : this.sessionFactory.getProviders().values()) {
            if (!"storedPasswords".equals(provider.getAuthenticationType())) continue;
            results.put(provider.getKey(), user.getProperty("storedUsername_" + provider.getKey()));
        }
        return results;
    }

    public void storePasswordForProvider(JahiaUser user, String providerKey, String username, String password) {
        if (username == null) {
            user.removeProperty("storedUsername_" + providerKey);
        } else {
            user.setProperty("storedUsername_" + providerKey, username);
        }
        if (password == null) {
            user.removeProperty("storedPassword_" + providerKey);
        } else {
            user.setProperty("storedPassword_" + providerKey, password);
        }
    }

    public void setJcrStoreService(JCRStoreService jcrStoreService) {
        this.jcrStoreService = jcrStoreService;
    }

    public void setDefinitionHelper(ContentDefinitionHelper definitionHelper) {
        this.definitionHelper = definitionHelper;
    }

    public void setContentManager(ContentManagerHelper contentManager) {
        this.contentManager = contentManager;
    }
}

