/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import org.jahia.ajax.gwt.client.data.GWTJahiaSearchQuery;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.service.GWTJahiaServiceException;
import org.jahia.ajax.gwt.client.service.content.ExistingFileException;
import org.jahia.ajax.gwt.helper.ContentManagerHelper;
import org.jahia.ajax.gwt.helper.NavigationHelper;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRStoreService;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.query.QueryWrapper;
import org.jahia.services.search.SearchCriteria;
import org.jahia.services.search.jcr.JahiaJCRSearchProvider;
import org.jahia.utils.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchHelper {
    private static Logger logger = LoggerFactory.getLogger(SearchHelper.class);
    private JCRStoreService jcrService;
    private NavigationHelper navigation;
    private ContentManagerHelper contentManager;
    private JahiaJCRSearchProvider jcrSearchProvider;

    public void setJcrService(JCRStoreService jcrService) {
        this.jcrService = jcrService;
    }

    public void setNavigation(NavigationHelper navigation) {
        this.navigation = navigation;
    }

    public void setContentManager(ContentManagerHelper contentManager) {
        this.contentManager = contentManager;
    }

    public List<GWTJahiaNode> search(String searchString, int limit, JCRSiteNode site, JCRSessionWrapper currentUserSession) throws GWTJahiaServiceException {
        try {
            Query q = this.createQuery(SearchHelper.formatQuery(searchString), currentUserSession);
            return this.navigation.executeQuery(q, null, null, null, site != null ? Arrays.asList(site.getSiteKey()) : null);
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return new ArrayList<GWTJahiaNode>();
        }
    }

    public List<GWTJahiaNode> search(GWTJahiaSearchQuery search, int limit, int offset, boolean showOnlyNodesWithTemplates, JCRSiteNode site, JCRSessionWrapper currentUserSession) throws GWTJahiaServiceException {
        try {
            Query q = this.createQuery(search, limit, offset, currentUserSession);
            if (logger.isDebugEnabled()) {
                logger.debug("Executing query: " + q.getStatement());
            }
            return this.navigation.executeQuery(q, search.getNodeTypes(), search.getMimeTypes(), search.getFilters(), Arrays.asList("icon", "jcr:created", "jcr:createdBy", "tags", "childrenInfo", "j:view", "j:width", "j:height", "publicationInfo", "primaryTypeLabel", "permissions"), search.getSites(), showOnlyNodesWithTemplates);
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return new ArrayList<GWTJahiaNode>();
        }
    }

    public List<GWTJahiaNode> search(String searchString, int limit, List<String> nodeTypes, List<String> mimeTypes, List<String> filters, JCRSiteNode site, JCRSessionWrapper currentUserSession) throws GWTJahiaServiceException {
        try {
            Query q = this.createQuery(SearchHelper.formatQuery(searchString), currentUserSession);
            return this.navigation.executeQuery(q, nodeTypes, mimeTypes, filters, site != null ? Arrays.asList(site.getSiteKey()) : null);
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return new ArrayList<GWTJahiaNode>();
        }
    }

    public List<GWTJahiaNode> searchSQL(String searchString, int limit, List<String> nodeTypes, List<String> mimeTypes, List<String> filters, List<String> fields, JCRSiteNode site, JCRSessionWrapper currentUserSession) throws GWTJahiaServiceException {
        try {
            if (searchString.contains("$site") && site != null) {
                searchString = searchString.replace("$site", site.getPath());
            }
            if (searchString.contains("$systemsite") && site != null) {
                searchString = searchString.replace("$systemsite", JCRContentUtils.getSystemSitePath());
            }
            QueryWrapper q = currentUserSession.getWorkspace().getQueryManager().createQuery(searchString, "JCR-SQL2");
            q.setLimit(limit);
            return this.navigation.executeQuery(q, nodeTypes, mimeTypes, filters, fields, site != null ? Arrays.asList(site.getSiteKey()) : null, false);
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return new ArrayList<GWTJahiaNode>();
        }
    }

    public List<GWTJahiaNode> getSavedSearch(JCRSiteNode site, JCRSessionWrapper currentUserSession) {
        JCRNodeWrapper user;
        ArrayList<GWTJahiaNode> result = new ArrayList<GWTJahiaNode>();
        try {
            user = this.jcrService.getUserFolder(currentUserSession.getUser());
        }
        catch (Exception e) {
            logger.error("no user folder for site " + site.getSiteKey() + " and user " + currentUserSession.getUser().getUsername());
            return result;
        }
        try {
            String s = "select * from [nt:query] as q where isdescendantnode(q, ['" + user.getPath() + "'])";
            QueryWrapper q = currentUserSession.getWorkspace().getQueryManager().createQuery(s, "JCR-SQL2");
            return this.navigation.executeQuery(q, null, null, null, null);
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return result;
        }
    }

    public GWTJahiaNode saveSearch(String searchString, String name, JCRSiteNode site, JCRSessionWrapper currentUserSession, Locale uiLocale) throws GWTJahiaServiceException {
        try {
            JCRNodeWrapper queryStore;
            JCRNodeWrapper user;
            if (name == null) {
                throw new GWTJahiaServiceException(Messages.getInternal("label.gwt.error.could.not.store.query.with.null.name", uiLocale));
            }
            Query q = this.createQuery(searchString, currentUserSession);
            try {
                user = this.jcrService.getUserFolder(currentUserSession.getUser());
            }
            catch (Exception e) {
                logger.error("no user folder for site " + site.getSiteKey() + " and user " + currentUserSession.getUser().getUsername());
                throw new GWTJahiaServiceException(Messages.getInternal("label.gwt.error.no.user.folder.to.store.query", uiLocale));
            }
            if (!user.hasNode("savedSearch")) {
                currentUserSession.checkout(user);
                queryStore = user.createCollection("savedSearch");
            } else {
                queryStore = currentUserSession.getNode(user.getPath() + "/savedSearch");
                currentUserSession.checkout(queryStore);
            }
            String path = queryStore.getPath() + "/" + name;
            if (this.contentManager.checkExistence(path, currentUserSession, uiLocale)) {
                throw new ExistingFileException("The node " + path + " alreadey exists.");
            }
            q.storeAsNode(path);
            user.getSession().save();
            return this.navigation.getGWTJahiaNode(currentUserSession.getNode(path));
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new GWTJahiaServiceException(Messages.getInternal("label.gwt.error.could.not.store.query", uiLocale));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new GWTJahiaServiceException(Messages.getInternal("label.gwt.error.could.not.store.query", uiLocale));
        }
    }

    public GWTJahiaNode saveSearch(GWTJahiaSearchQuery search, String path, String name, JCRSessionWrapper session, Locale uiLocale) throws GWTJahiaServiceException {
        try {
            if (name == null) {
                throw new GWTJahiaServiceException(Messages.getInternal("label.gwt.error.could.not.store.query.with.null.name", uiLocale));
            }
            JCRNodeWrapper parent = null;
            parent = path == null ? this.jcrService.getUserFolder(session.getUser()) : session.getNode(path);
            String saveSearchPath = parent.getPath() + "/" + this.contentManager.findAvailableName(parent, name);
            parent.checkout();
            logger.debug("Save search path: " + saveSearchPath);
            Query q = this.createQuery(search, session);
            q.storeAsNode(saveSearchPath);
            session.save();
            return this.navigation.getGWTJahiaNode(session.getNode(saveSearchPath));
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new GWTJahiaServiceException(Messages.getInternal("label.gwt.error.could.not.store.query", uiLocale));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new GWTJahiaServiceException(Messages.getInternal("label.gwt.error.could.not.store.query", uiLocale));
        }
    }

    public static String formatQuery(String rawQuery) {
        if (rawQuery == null || rawQuery.length() == 0) {
            return "";
        }
        if (rawQuery.startsWith("*") || rawQuery.endsWith("*")) {
            return rawQuery;
        }
        return "*" + rawQuery + "*";
    }

    public void setJcrSearchProvider(JahiaJCRSearchProvider jcrSearchProvider) {
        this.jcrSearchProvider = jcrSearchProvider;
    }

    public Query createQuery(String searchString, JCRSessionWrapper session) throws RepositoryException {
        SearchCriteria criteria = new SearchCriteria();
        criteria.getTerms().get(0).setTerm(searchString);
        return this.jcrSearchProvider.buildQuery(criteria, session);
    }

    private Query createQuery(GWTJahiaSearchQuery gwtQuery, JCRSessionWrapper session) throws InvalidQueryException, RepositoryException {
        return this.createQuery(gwtQuery, 0, 0, session);
    }

    private Query createQuery(final GWTJahiaSearchQuery gwtQuery, int limit, int offset, JCRSessionWrapper session) throws InvalidQueryException, RepositoryException {
        String siteKey;
        SearchCriteria criteria = new SearchCriteria();
        if (offset > 0) {
            criteria.setOffset(offset);
        }
        if (limit > 0) {
            criteria.setLimit(limit);
        }
        if (gwtQuery.getPages() != null && !gwtQuery.getPages().isEmpty()) {
            criteria.getPagePath().setValue(((GWTJahiaNode)gwtQuery.getPages().get(0)).getPath());
            criteria.getPagePath().setIncludeChildren(true);
        }
        if (gwtQuery.getNodeTypes() != null && gwtQuery.getNodeTypes().size() == 1) {
            criteria.setNodeType((String)gwtQuery.getNodeTypes().get(0));
            gwtQuery.setNodeTypes(new LinkedList());
        }
        if (gwtQuery.getLanguage() != null && gwtQuery.getLanguage().getLanguage() != null) {
            criteria.getLanguages().setValue(gwtQuery.getLanguage().getLanguage());
        }
        if (gwtQuery.getQuery() != null && gwtQuery.getQuery().length() > 0) {
            criteria.getTerms().get(0).setTerm(gwtQuery.getQuery());
            SearchCriteria.Term.SearchFields fields = criteria.getTerms().get(0).getFields();
            fields.setSiteContent(gwtQuery.isInContents());
            fields.setFilename(gwtQuery.isInName());
            fields.setFileContent(gwtQuery.isInFiles());
            fields.setTitle(gwtQuery.isInMetadatas());
            fields.setDescription(gwtQuery.isInMetadatas());
            fields.setKeywords(gwtQuery.isInMetadatas());
            fields.setTags(gwtQuery.isInTags());
        }
        Date startDate = null;
        SearchCriteria.DateValue creationDate = new SearchCriteria.DateValue();
        creationDate.setType(SearchCriteria.DateValue.Type.RANGE);
        criteria.setCreated(creationDate);
        SearchCriteria.DateValue lastModifiedDate = new SearchCriteria.DateValue();
        lastModifiedDate.setType(SearchCriteria.DateValue.Type.RANGE);
        criteria.setLastModified(lastModifiedDate);
        SearchCriteria.DateValue lastPublished = criteria.getProperties().get("jmix:lastPublished").get("j:lastPublished").getDateValue();
        criteria.getProperties().get("jmix:lastPublished").get("j:lastPublished").setType(SearchCriteria.NodeProperty.Type.DATE);
        criteria.getProperties().get("jmix:lastPublished").get("j:lastPublished").setName("j:lastPublished");
        lastPublished.setType(SearchCriteria.DateValue.Type.RANGE);
        if (gwtQuery.getTimeInDays() != null) {
            int timeInDays = Integer.parseInt(gwtQuery.getTimeInDays());
            Calendar cal = Calendar.getInstance();
            if (timeInDays < 30) {
                cal.add(5, -timeInDays);
            } else if (timeInDays < 365) {
                cal.add(2, -(timeInDays / 30));
            } else {
                cal.add(1, -(timeInDays / 365));
            }
            startDate = cal.getTime();
        }
        if (gwtQuery.getEndLastModifiedDate() != null) {
            lastModifiedDate.setToAsDate(gwtQuery.getEndLastModifiedDate());
            if (startDate != null) {
                lastModifiedDate.setFromAsDate(startDate);
            }
        } else if (gwtQuery.getEndCreatedDate() != null) {
            creationDate.setToAsDate(gwtQuery.getEndCreatedDate());
            if (startDate != null) {
                creationDate.setFromAsDate(startDate);
            }
        } else if (gwtQuery.getEndPublishedDate() != null) {
            lastPublished.setToAsDate(gwtQuery.getEndPublishedDate());
            if (startDate != null) {
                lastPublished.setFromAsDate(startDate);
            }
        }
        if (gwtQuery.getStartCreatedDate() != null) {
            creationDate.setFromAsDate(gwtQuery.getStartCreatedDate());
            criteria.setCreated(creationDate);
        }
        if (gwtQuery.getStartLastModifiedDate() != null) {
            lastModifiedDate.setFromAsDate(gwtQuery.getStartLastModifiedDate());
            criteria.setLastModified(lastModifiedDate);
        }
        if (gwtQuery.getStartPublishedDate() != null) {
            lastPublished.setFromAsDate(gwtQuery.getStartPublishedDate());
        }
        if (gwtQuery.getOriginSiteUuid() != null && (siteKey = JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<String>(){

            @Override
            public String doInJCR(JCRSessionWrapper session) throws RepositoryException {
                try {
                    JCRNodeWrapper nodeWrapper = session.getNodeByIdentifier(gwtQuery.getOriginSiteUuid());
                    return nodeWrapper.getName();
                }
                catch (ItemNotFoundException e) {
                    logger.error("Unable for find site node by UUID: " + gwtQuery.getOriginSiteUuid(), (Throwable)e);
                    return null;
                }
            }
        })) != null) {
            criteria.setOriginSiteKey(siteKey);
        }
        if (gwtQuery.getSites() != null) {
            SearchCriteria.CommaSeparatedMultipleValue sites = new SearchCriteria.CommaSeparatedMultipleValue();
            sites.setValues(gwtQuery.getSites().toArray(new String[gwtQuery.getSites().size()]));
            criteria.setSites(sites);
        }
        if (gwtQuery.getBasePath() != null) {
            SearchCriteria.HierarchicalValue filePath = new SearchCriteria.HierarchicalValue();
            filePath.setValue(gwtQuery.getBasePath());
            filePath.setIncludeChildren(true);
            criteria.setFilePath(filePath);
        }
        return this.jcrSearchProvider.buildQuery(criteria, session);
    }
}

