/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.helper;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.jcr.AccessDeniedException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.jahia.ajax.gwt.client.data.GWTRenderResult;
import org.jahia.ajax.gwt.client.data.GWTStaticAssetEntry;
import org.jahia.ajax.gwt.client.service.GWTJahiaServiceException;
import org.jahia.bin.Render;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.channels.Channel;
import org.jahia.services.channels.ChannelService;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.content.nodetypes.ConstraintsHelper;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.RenderException;
import org.jahia.services.render.RenderService;
import org.jahia.services.render.Resource;
import org.jahia.services.uicomponents.bean.editmode.EditConfiguration;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateHelper {
    private static Logger logger = LoggerFactory.getLogger(TemplateHelper.class);
    private static final String CSS = "css";
    private static final String JAVASCRIPT = "javascript";
    private RenderService renderService;
    private ChannelService channelService;
    public static final int LIVE = 0;
    public static final int PREVIEW = 1;
    public static final int EDIT = 2;

    public void setRenderService(RenderService renderService) {
        this.renderService = renderService;
    }

    public void setChannelService(ChannelService channelService) {
        this.channelService = channelService;
    }

    public GWTRenderResult getRenderedContent(String path, String template, String configuration, final Map<String, List<String>> contextParams, boolean editMode, String configName, HttpServletRequest request, HttpServletResponse response, JCRSessionWrapper currentUserSession, Locale uiLocale, String channelIdentifier, String channelVariant) throws GWTJahiaServiceException {
        GWTRenderResult result = null;
        try {
            String constraints;
            Channel activeChannel;
            JCRNodeWrapper node = currentUserSession.getNode(path);
            Resource r = new Resource(node, "html", template, configuration);
            request.setAttribute("mode", (Object)"edit");
            request = new HttpServletRequestWrapper((HttpServletRequest)request){

                public String getParameter(String name) {
                    if (contextParams != null && contextParams.containsKey(name)) {
                        return (String)((List)contextParams.get(name)).get(0);
                    }
                    return super.getParameter(name);
                }

                public Map getParameterMap() {
                    HashMap r = new HashMap(super.getParameterMap());
                    if (contextParams != null) {
                        for (Map.Entry entry : contextParams.entrySet()) {
                            r.put(entry.getKey(), ((List)entry.getValue()).toArray(new String[((List)entry.getValue()).size()]));
                        }
                    }
                    return r;
                }

                public Enumeration getParameterNames() {
                    return new Vector(this.getParameterMap().keySet()).elements();
                }

                public String[] getParameterValues(String name) {
                    if (contextParams != null && contextParams.containsKey(name)) {
                        List list = (List)contextParams.get(name);
                        return list.toArray(new String[list.size()]);
                    }
                    return super.getParameterValues(name);
                }
            };
            RenderContext renderContext = new RenderContext((HttpServletRequest)request, response, currentUserSession.getUser());
            renderContext.setEditMode(editMode);
            if ("contributemode".equals(configName)) {
                renderContext.setContributionMode(true);
            }
            renderContext.setMainResource(r);
            EditConfiguration editConfiguration = null;
            if (configName != null) {
                editConfiguration = (EditConfiguration)SpringContextSingleton.getBean(configName);
            }
            renderContext.setEditModeConfig(editConfiguration);
            String permission = null;
            if (editConfiguration != null) {
                permission = editConfiguration.getRequiredPermission();
                renderContext.setServletPath(editConfiguration.getDefaultUrlMapping());
            } else {
                renderContext.setServletPath(Render.getRenderServletPath());
            }
            if (permission != null && !node.getResolveSite().hasPermission(permission)) {
                throw new GWTJahiaServiceException(Messages.getInternal("label.gwt.error.access.denied", uiLocale));
            }
            if (contextParams != null) {
                for (Map.Entry<String, List<String>> entry : contextParams.entrySet()) {
                    r.getModuleParams().put(entry.getKey(), (Serializable)((Object)entry.getValue().get(0)));
                }
            }
            JCRSiteNode site = node.getResolveSite();
            renderContext.setSite(site);
            if (channelIdentifier != null && (activeChannel = this.channelService.getChannel(channelIdentifier)) != null) {
                renderContext.setChannel(activeChannel);
            }
            response.setCharacterEncoding(SettingsBean.getInstance().getCharacterEncoding());
            String res = this.renderService.render(r, renderContext);
            Map map = (Map)renderContext.getRequest().getAttribute("staticAssets");
            if (channelIdentifier != null && !channelIdentifier.equals("generic")) {
                Map css = (Map)map.get(CSS);
                TreeMap cssWithParam = new TreeMap();
                for (Map.Entry entry : css.entrySet()) {
                    String k = (String)entry.getKey() + "?channel=" + channelIdentifier + (channelVariant != null ? "&variant=" + channelVariant : "");
                    cssWithParam.put(k, entry.getValue());
                }
                map.put(CSS, cssWithParam);
            }
            if ((constraints = ConstraintsHelper.getConstraints(node)) == null) {
                constraints = "";
            }
            HashMap m = new HashMap();
            if (map != null) {
                for (Map.Entry entry : map.entrySet()) {
                    ArrayList<GWTStaticAssetEntry> fileEntries = new ArrayList<GWTStaticAssetEntry>();
                    for (Map.Entry filetypeEntries : ((Map)entry.getValue()).entrySet()) {
                        String filePath = (String)filetypeEntries.getKey();
                        Map fileOptions = (Map)filetypeEntries.getValue();
                        fileEntries.add(new GWTStaticAssetEntry(filePath, fileOptions));
                    }
                    m.put(entry.getKey(), fileEntries);
                }
            }
            result = new GWTRenderResult(res, m, constraints, node.getDisplayableName());
        }
        catch (PathNotFoundException e) {
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.not.found.for.user", uiLocale, path, currentUserSession.getUser().getName()));
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.repository.exception.on.path", uiLocale, path));
        }
        catch (RenderException e) {
            if (e.getCause() instanceof AccessDeniedException) {
                throw new GWTJahiaServiceException(Messages.getInternal("label.gwt.error.access.denied", uiLocale));
            }
            logger.error(e.getMessage(), (Throwable)e);
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.render.exception", uiLocale, e.getMessage()));
        }
        return result;
    }

    public Map<String, Set<String>> getAvailableResources(String moduleName) {
        HashMap<String, Set<String>> m = new HashMap<String, Set<String>>();
        m.put(CSS, this.getAvailableResources(moduleName, CSS, ".css"));
        m.put(JAVASCRIPT, this.getAvailableResources(moduleName, JAVASCRIPT, ".js"));
        return m;
    }

    public Set<String> getAvailableResources(String moduleName, String type, String ext) {
        return this.getAvailableResources(moduleName, type, ext, true);
    }

    public Set<String> getAvailableResources(String moduleName, String type, String ext, boolean checkDependencies) {
        HashSet<String> resources = new HashSet<String>();
        JahiaTemplatesPackage aPackage = ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackageById(moduleName);
        LinkedHashSet<JahiaTemplatesPackage> packages = new LinkedHashSet<JahiaTemplatesPackage>();
        packages.add(aPackage);
        if (checkDependencies) {
            packages.addAll(aPackage.getDependencies());
        }
        for (JahiaTemplatesPackage pack : packages) {
            org.springframework.core.io.Resource[] rs;
            String resourceName;
            if (pack.getSourcesFolder() != null && new File(pack.getSourcesFolder(), "src/main/resources").exists()) {
                File f = new File(pack.getSourcesFolder(), "src/main/resources/" + type);
                if (!f.exists() || !f.isDirectory()) continue;
                for (File file : f.listFiles()) {
                    resourceName = file.getName();
                    if (!resourceName.endsWith(ext)) continue;
                    resources.add(resourceName);
                }
                continue;
            }
            for (org.springframework.core.io.Resource resource : rs = pack.getResources(type)) {
                resourceName = resource.getFilename();
                if (!resourceName.endsWith(ext)) continue;
                resources.add(resourceName);
            }
        }
        return resources;
    }
}

