/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.helper;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.security.Privilege;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.script.SimpleScriptContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.core.security.JahiaPrivilegeRegistry;
import org.apache.jackrabbit.core.security.PrivilegeImpl;
import org.jahia.ajax.gwt.client.data.GWTJahiaProperty;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.toolbar.GWTColumn;
import org.jahia.ajax.gwt.client.data.toolbar.GWTConfiguration;
import org.jahia.ajax.gwt.client.data.toolbar.GWTEditConfiguration;
import org.jahia.ajax.gwt.client.data.toolbar.GWTEngineConfiguration;
import org.jahia.ajax.gwt.client.data.toolbar.GWTEngineTab;
import org.jahia.ajax.gwt.client.data.toolbar.GWTJahiaToolbar;
import org.jahia.ajax.gwt.client.data.toolbar.GWTJahiaToolbarItem;
import org.jahia.ajax.gwt.client.data.toolbar.GWTJahiaToolbarMenu;
import org.jahia.ajax.gwt.client.data.toolbar.GWTManagerConfiguration;
import org.jahia.ajax.gwt.client.data.toolbar.GWTRepository;
import org.jahia.ajax.gwt.client.data.toolbar.GWTSidePanelTab;
import org.jahia.ajax.gwt.client.data.toolbar.monitor.GWTJahiaStateInfo;
import org.jahia.ajax.gwt.client.service.GWTJahiaServiceException;
import org.jahia.ajax.gwt.client.widget.toolbar.action.ActionItem;
import org.jahia.ajax.gwt.client.widget.toolbar.action.LanguageAware;
import org.jahia.ajax.gwt.helper.ChannelHelper;
import org.jahia.ajax.gwt.helper.LanguageHelper;
import org.jahia.ajax.gwt.helper.NavigationHelper;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.decorator.JCRNodeDecorator;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.sites.JahiaSite;
import org.jahia.services.sites.JahiaSitesService;
import org.jahia.services.uicomponents.bean.Visibility;
import org.jahia.services.uicomponents.bean.contentmanager.Column;
import org.jahia.services.uicomponents.bean.contentmanager.ManagerConfiguration;
import org.jahia.services.uicomponents.bean.contentmanager.Repository;
import org.jahia.services.uicomponents.bean.editmode.EditConfiguration;
import org.jahia.services.uicomponents.bean.editmode.EngineConfiguration;
import org.jahia.services.uicomponents.bean.editmode.EngineTab;
import org.jahia.services.uicomponents.bean.editmode.SidePanelTab;
import org.jahia.services.uicomponents.bean.toolbar.Item;
import org.jahia.services.uicomponents.bean.toolbar.Menu;
import org.jahia.services.uicomponents.bean.toolbar.Property;
import org.jahia.services.uicomponents.bean.toolbar.Toolbar;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.utils.LanguageCodeConverters;
import org.jahia.utils.ScriptEngineUtils;
import org.jahia.utils.Url;
import org.jahia.utils.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UIConfigHelper {
    private static final Logger logger = LoggerFactory.getLogger(UIConfigHelper.class);
    private LanguageHelper languages;
    private NavigationHelper navigation;
    private ChannelHelper channelHelper;
    private ScriptEngineUtils scriptEngineUtils;

    public void setNavigation(NavigationHelper navigation) {
        this.navigation = navigation;
    }

    public void setChannelHelper(ChannelHelper channelHelper) {
        this.channelHelper = channelHelper;
    }

    public void setLanguages(LanguageHelper languages) {
        this.languages = languages;
    }

    public GWTJahiaToolbar getGWTToolbarSet(JCRNodeWrapper contextNode, JCRSiteNode site, JahiaUser jahiaUser, Locale locale, Locale uiLocale, HttpServletRequest request, String toolbarGroup) throws GWTJahiaServiceException {
        try {
            Toolbar toolbar = (Toolbar)SpringContextSingleton.getBean(toolbarGroup);
            Visibility visibility = toolbar.getVisibility();
            if (visibility != null && visibility.getRealValue(contextNode, jahiaUser, locale, request) || visibility == null) {
                return this.createGWTToolbar(contextNode, site, jahiaUser, locale, uiLocale, request, toolbar);
            }
            logger.info("Toolbar are not visible.");
            return null;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.during.loading.toolbars", uiLocale, e.getMessage()));
        }
    }

    public List<GWTJahiaToolbar> createGWTToolbarSet(JCRNodeWrapper contextNode, JCRSiteNode site, JahiaUser jahiaUser, Locale locale, Locale uiLocale, HttpServletRequest request, List<Toolbar> toolbarSet) {
        if (toolbarSet == null || toolbarSet.isEmpty()) {
            logger.debug("toolbar set list is empty");
            return null;
        }
        ArrayList<GWTJahiaToolbar> gwtJahiaToolbarSet = new ArrayList<GWTJahiaToolbar>();
        for (Toolbar toolbar : toolbarSet) {
            Visibility visibility = toolbar.getVisibility();
            if (visibility != null && visibility.getRealValue(contextNode, jahiaUser, locale, request) || visibility == null) {
                GWTJahiaToolbar gwtToolbar = this.createGWTToolbar(contextNode, site, jahiaUser, locale, uiLocale, request, toolbar);
                if (gwtToolbar == null || gwtToolbar.getGwtToolbarItems() == null || gwtToolbar.getGwtToolbarItems().isEmpty()) continue;
                gwtJahiaToolbarSet.add(gwtToolbar);
                continue;
            }
            logger.debug("toolbar: " + toolbar.getName() + ":  not visible");
        }
        return gwtJahiaToolbarSet;
    }

    public GWTJahiaStateInfo updateGWTJahiaStateInfo(JCRSiteNode site, JahiaUser jahiaUser, Locale uiLocale, GWTJahiaStateInfo gwtJahiaStateInfo) throws GWTJahiaServiceException {
        try {
            if (gwtJahiaStateInfo == null) {
                gwtJahiaStateInfo = new GWTJahiaStateInfo();
                gwtJahiaStateInfo.setLastViewTime(System.currentTimeMillis());
                if (gwtJahiaStateInfo.isNeedRefresh()) {
                    gwtJahiaStateInfo.setIconStyle("gwt-toolbar-icon-notification-refresh");
                }
            } else if (gwtJahiaStateInfo.isNeedRefresh()) {
                return gwtJahiaStateInfo;
            }
            gwtJahiaStateInfo.setAlertMessage(null);
            return gwtJahiaStateInfo;
        }
        catch (Exception e) {
            logger.error("Error when triing to load Jahia state info due to", (Throwable)e);
            throw new GWTJahiaServiceException(Messages.getInternal("label.gwt.error.when.trying.to.load.jahia.state", uiLocale));
        }
    }

    public GWTJahiaToolbar createGWTToolbar(JCRNodeWrapper contextNode, JCRSiteNode site, JahiaUser jahiaUser, Locale locale, Locale uiLocale, HttpServletRequest request, Toolbar toolbar) {
        if (toolbar == null) {
            logger.debug("Toolbar parameter is null.");
            return null;
        }
        if (toolbar.getItems() == null || toolbar.getItems().isEmpty()) {
            logger.debug("toolbar[" + toolbar.getName() + "] itemsgroup list is empty");
            return null;
        }
        GWTJahiaToolbar gwtToolbar = new GWTJahiaToolbar();
        gwtToolbar.setName(toolbar.getName());
        gwtToolbar.setTitle(this.getResources(toolbar.getTitleKey(), uiLocale != null ? uiLocale : locale, site, jahiaUser));
        gwtToolbar.setDisplayTitle(toolbar.isDisplayTitle());
        ArrayList<Object> gwtToolbarItemsGroupList = new ArrayList<Object>();
        int index = 0;
        for (Item item : toolbar.getItems()) {
            Visibility visibility = item.getVisibility();
            if (visibility != null && visibility.getRealValue(contextNode, jahiaUser, locale, request) || visibility == null) {
                if (item instanceof Menu) {
                    GWTJahiaToolbarMenu gwtMenu = this.createGWTItemsGroup(contextNode, site, jahiaUser, locale, uiLocale, request, gwtToolbar.getName(), index, (Menu)item);
                    if (gwtMenu != null && gwtMenu.getGwtToolbarItems() != null && !gwtMenu.getGwtToolbarItems().isEmpty()) {
                        gwtToolbarItemsGroupList.add(gwtMenu);
                    }
                } else {
                    GWTJahiaToolbarItem gwtItem = this.createGWTItem(site, jahiaUser, locale, uiLocale, request, item);
                    if (gwtItem != null) {
                        gwtToolbarItemsGroupList.add(gwtItem);
                    }
                }
            } else {
                logger.debug("toolbar[" + gwtToolbar.getName() + "] - itemsGroup [" + item.getId() + "," + item.getTitleKey() + "]  not visible");
            }
            ++index;
        }
        gwtToolbar.setGwtToolbarItems(gwtToolbarItemsGroupList);
        int barLayout = this.getLayoutAsInt(toolbar.getLayout());
        if (barLayout == -1) {
            barLayout = 0;
        }
        for (GWTJahiaToolbarItem gWTJahiaToolbarItem : gwtToolbarItemsGroupList) {
            if (gWTJahiaToolbarItem.getLayout() != -1) continue;
            gWTJahiaToolbarItem.setLayout(barLayout);
        }
        return gwtToolbar;
    }

    public GWTManagerConfiguration getGWTManagerConfiguration(JCRNodeWrapper contextNode, JCRSiteNode site, JahiaUser jahiaUser, Locale locale, Locale uiLocale, HttpServletRequest request, String name) throws GWTJahiaServiceException {
        try {
            ManagerConfiguration config = (ManagerConfiguration)SpringContextSingleton.getBean(name);
            if (config != null) {
                GWTColumn col;
                logger.debug("Config. " + name + " found.");
                GWTManagerConfiguration gwtConfig = new GWTManagerConfiguration();
                gwtConfig.setName(name);
                String title = null;
                title = config.getTitleKey() != null ? this.getResources(config.getTitleKey(), uiLocale, site, jahiaUser) : this.getResources("label." + name, uiLocale, site, jahiaUser);
                if (title != null) {
                    gwtConfig.setTitle(title);
                }
                gwtConfig.setNodeTypes(config.getNodeTypes());
                gwtConfig.setFolderTypes(config.getFolderTypes());
                gwtConfig.setHideLeftPanel(config.isHideLeftPanel());
                gwtConfig.setFilters(config.getFilters());
                gwtConfig.setMimeTypes(config.getMimeTypes());
                gwtConfig.setHiddenRegex(config.getHiddenRegex());
                gwtConfig.setHiddenTypes(config.getHiddenTypes());
                gwtConfig.setDefaultView(config.getDefaultView());
                gwtConfig.setEnableDragAndDrop(config.isEnableDragAndDrop());
                gwtConfig.setAllowedNodeTypesForDragAndDrop(config.getAllowedNodeTypesForDragAndDrop());
                gwtConfig.setForbiddenNodeTypesForDragAndDrop(config.getForbiddenNodeTypesForDragAndDrop());
                gwtConfig.setEnableFileDoubleClick(config.isEnableFileDoubleClick());
                gwtConfig.setAllowsMultipleSelection(config.isAllowsMultipleSelection());
                gwtConfig.setExpandRoot(config.isExpandRoot());
                gwtConfig.setAllowRootNodeEditing(config.isAllowRootNodeEditing());
                gwtConfig.setDisplaySearch(config.isDisplaySearch());
                gwtConfig.setDisplaySearchInPage(config.isDisplaySearchInPage());
                gwtConfig.setDisplaySearchInTag(config.isDisplaySearchInTag());
                gwtConfig.setDisplaySearchInFile(config.isDisplaySearchInFile());
                gwtConfig.setDisplaySearchInContent(config.isDisplaySearchInContent());
                gwtConfig.setSearchInFile(config.isSearchInFile());
                gwtConfig.setSearchInContent(config.isSearchInContent());
                gwtConfig.setSearchInCurrentSiteOnly(config.isSearchInCurrentSiteOnly());
                gwtConfig.setSearchBasePath(config.getSearchBasePath());
                gwtConfig.setShowOnlyNodesWithTemplates(config.isShowOnlyNodesWithTemplates());
                gwtConfig.setDisplaySearchInDateMeta(config.isDisplaySearchInDateMeta());
                gwtConfig.setEditableGrid(config.isEditableGrid());
                gwtConfig.setComponentsPaths(config.getComponentsPaths());
                gwtConfig.setToolbars(this.createGWTToolbarSet(contextNode, site, jahiaUser, locale, uiLocale, request, config.getToolbars()));
                gwtConfig.setContextMenu(this.createGWTToolbar(contextNode, site, jahiaUser, locale, uiLocale, request, config.getContextMenu()));
                for (Column column : config.getTableColumns()) {
                    if (!this.checkVisibility(contextNode, jahiaUser, locale, request, column.getVisibility())) continue;
                    col = this.createGWTColumn(column, site, locale, uiLocale);
                    gwtConfig.addTableColumn(col);
                }
                for (Column column : config.getTreeColumns()) {
                    if (!this.checkVisibility(contextNode, jahiaUser, locale, request, column.getVisibility())) continue;
                    col = this.createGWTColumn(column, site, locale, uiLocale);
                    gwtConfig.addTreeColumn(col);
                }
                for (Repository repository : config.getRepositories()) {
                    if (!this.checkVisibility(contextNode, jahiaUser, locale, request, repository.getVisibility())) continue;
                    GWTRepository repository2 = new GWTRepository();
                    repository2.setKey(repository.getKey());
                    if (repository.getTitleKey() != null) {
                        repository2.setTitle(this.getResources(repository.getTitleKey(), uiLocale != null ? uiLocale : locale, site, jahiaUser));
                    } else if (repository.getTitle() != null) {
                        repository2.setTitle(repository.getTitle());
                    } else {
                        repository2.setTitle(repository.getKey());
                    }
                    repository2.setPaths(new ArrayList());
                    for (String path : repository.getPaths()) {
                        if (path.equals("$rootPath")) {
                            repository2.getPaths().add(contextNode.getPath());
                            continue;
                        }
                        repository2.getPaths().add(path);
                    }
                    gwtConfig.addRepository(repository2);
                }
                if (config.getEngineConfigurations() != null && !config.getEngineConfigurations().isEmpty()) {
                    gwtConfig.setEngineConfigurations(this.createGWTEngineConfigurations(contextNode, site, jahiaUser, locale, uiLocale, request, config.getEngineConfigurations(), config.getEngineTabs()));
                }
                if (config.getEngineTabs() != null && !config.getEngineTabs().isEmpty()) {
                    List<GWTEngineTab> managerTabs = this.createGWTEngineList(contextNode, site, jahiaUser, locale, uiLocale, request, config.getEngineTabs());
                    gwtConfig.setManagerEngineTabs(managerTabs);
                }
                gwtConfig.setSuppressPublicationInfo(config.isSuppressPublicationInfo());
                gwtConfig.setSiteNode(this.navigation.getGWTJahiaNode(site, GWTJahiaNode.DEFAULT_SITE_FIELDS, uiLocale));
                this.setAvailablePermissions((GWTConfiguration)gwtConfig);
                return gwtConfig;
            }
            logger.error("Config. " + name + " not found.");
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.config.not.found", uiLocale, name));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.config.not.found", uiLocale, name, e.getLocalizedMessage()));
        }
    }

    private GWTColumn createGWTColumn(Column item, JCRSiteNode site, Locale locale, Locale uiLocale) {
        GWTColumn col = new GWTColumn();
        col.setKey(item.getKey());
        if (item.getTitleKey() != null) {
            col.setTitle(item.getTitleKey().equals("empty") ? "" : this.getResources(item.getTitleKey(), uiLocale != null ? uiLocale : locale, site, null));
        } else if (item.getDeclaringNodeType() != null) {
            try {
                ExtendedPropertyDefinition epd = NodeTypeRegistry.getInstance().getNodeType(item.getDeclaringNodeType()).getPropertyDefinition(item.getKey());
                col.setTitle(epd.getLabel(uiLocale != null ? uiLocale : locale));
            }
            catch (Exception e) {
                logger.error("Cannot get node type name", (Throwable)e);
                col.setTitle("");
            }
        } else if (item.getTitle() != null) {
            col.setTitle(item.getTitle());
        } else {
            col.setTitle("");
        }
        if (item.getSize().equals("*")) {
            col.setSize(-1);
        } else {
            col.setSize(Integer.parseInt(item.getSize()));
        }
        return col;
    }

    private GWTJahiaToolbarMenu createGWTItemsGroup(JCRNodeWrapper contextNode, JCRSiteNode site, JahiaUser jahiaUser, Locale locale, Locale uiLocale, HttpServletRequest request, String toolbarName, int index, Menu menu) {
        List<Item> list = menu.getItems();
        if (list == null || list.isEmpty()) {
            logger.debug("toolbar[" + toolbarName + "] itemlist is empty");
            return null;
        }
        ArrayList<GWTJahiaToolbarItem> gwtToolbarItemsList = new ArrayList<GWTJahiaToolbarItem>();
        for (Item item : list) {
            this.addToolbarItem(contextNode, site, jahiaUser, locale, uiLocale, request, gwtToolbarItemsList, item);
        }
        if (gwtToolbarItemsList == null || gwtToolbarItemsList.isEmpty()) {
            logger.debug("toolbar[" + toolbarName + "] itemlist is empty");
            return null;
        }
        GWTJahiaToolbarMenu gwtToolbarMenu = new GWTJahiaToolbarMenu();
        gwtToolbarMenu.setId(toolbarName + "_" + index);
        gwtToolbarMenu.setIcon(menu.getIcon());
        if (menu.getTitleKey() != null) {
            gwtToolbarMenu.setItemsGroupTitle(this.getResources(menu.getTitleKey(), uiLocale != null ? uiLocale : locale, site, jahiaUser));
        } else {
            gwtToolbarMenu.setItemsGroupTitle(menu.getTitle());
        }
        gwtToolbarMenu.setGwtToolbarItems(gwtToolbarItemsList);
        return gwtToolbarMenu;
    }

    private int getLayoutAsInt(String layout) {
        int layoutInt = -1;
        if (layout != null) {
            if (layout.equalsIgnoreCase("button")) {
                layoutInt = 0;
            } else if (layout.equalsIgnoreCase("label")) {
                layoutInt = 1;
            } else if (layout.equalsIgnoreCase("button-label")) {
                layoutInt = 2;
            } else if (layout.equalsIgnoreCase("menu")) {
                layoutInt = 3;
            } else if (layout.equalsIgnoreCase("menu-radio")) {
                layoutInt = 4;
            } else if (layout.equalsIgnoreCase("menu-checkbox")) {
                layoutInt = 5;
            } else {
                logger.debug("Warning: layout " + layout + " unknown.");
            }
        }
        return layoutInt;
    }

    private void addToolbarItem(JCRNodeWrapper contextNode, JCRSiteNode site, JahiaUser jahiaUser, Locale locale, Locale uiLocale, HttpServletRequest request, List<GWTJahiaToolbarItem> gwtToolbarItemsList, Item item) {
        if (item instanceof Menu) {
            for (Item subItem : ((Menu)item).getItems()) {
                this.addToolbarItem(contextNode, site, jahiaUser, locale, uiLocale, request, gwtToolbarItemsList, subItem);
            }
        } else {
            logger.debug("Item: " + item.getId());
            Visibility visibility = item.getVisibility();
            if (visibility != null && visibility.getRealValue(contextNode, jahiaUser, locale, request) || visibility == null) {
                GWTJahiaToolbarItem gwtToolbarItem = this.createGWTItem(site, jahiaUser, locale, uiLocale, request, item);
                if (gwtToolbarItem != null) {
                    gwtToolbarItemsList.add(gwtToolbarItem);
                }
            } else {
                logger.debug("Item: " + item.getTitleKey() + ":  not visible");
            }
        }
    }

    private GWTJahiaToolbarItem createGWTItem(JCRSiteNode site, JahiaUser jahiaUser, Locale locale, Locale uiLocale, HttpServletRequest request, Item item) {
        GWTJahiaToolbarItem gwtToolbarItem = new GWTJahiaToolbarItem();
        gwtToolbarItem.setId(item.getId());
        if (item.getTitleKey() != null) {
            gwtToolbarItem.setTitle(this.getResources(item.getTitleKey(), uiLocale != null ? uiLocale : locale, site, jahiaUser));
        } else {
            gwtToolbarItem.setTitle(item.getTitle());
        }
        gwtToolbarItem.setDisplayTitle(item.isDisplayTitle());
        if (item.getDescriptionKey() != null) {
            gwtToolbarItem.setDescription(this.getResources(item.getDescriptionKey(), uiLocale != null ? uiLocale : locale, site, jahiaUser));
        } else {
            gwtToolbarItem.setDescription(gwtToolbarItem.getTitle());
        }
        gwtToolbarItem.setIcon(item.getIcon());
        if (item.getSelected() != null) {
            gwtToolbarItem.setSelected(item.getSelected().getRealValue(site, jahiaUser, locale));
        } else {
            gwtToolbarItem.setSelected(false);
        }
        HashMap<String, GWTJahiaProperty> pMap = new HashMap<String, GWTJahiaProperty>();
        for (Property currentProperty : item.getProperties()) {
            GWTJahiaProperty gwtProperty = new GWTJahiaProperty();
            gwtProperty.setName(currentProperty.getName());
            gwtProperty.setValue(currentProperty.getRealValue(site, jahiaUser, locale));
            pMap.put(gwtProperty.getName(), gwtProperty);
        }
        gwtToolbarItem.setLayout(this.getLayoutAsInt(item.getLayout()));
        gwtToolbarItem.setRequiredPermission(item.getRequiredPermission());
        gwtToolbarItem.setHideWhenDisabled(item.isHideWhenDisabled());
        gwtToolbarItem.setProperties(pMap);
        ActionItem actionItem = item.getActionItem();
        if (actionItem instanceof LanguageAware) {
            ((LanguageAware)actionItem).setSelectedLang(this.languages.getCurrentLang(locale));
        }
        gwtToolbarItem.setActionItem(actionItem);
        return gwtToolbarItem;
    }

    public GWTEditConfiguration getGWTEditConfiguration(String name, String contextPath, JahiaUser jahiaUser, Locale locale, Locale uiLocale, HttpServletRequest request, JCRSessionWrapper session) throws GWTJahiaServiceException {
        try {
            EditConfiguration config = (EditConfiguration)SpringContextSingleton.getBean(name);
            if (config != null) {
                String defaultLanguage;
                List<Locale> languagesAsLocales;
                GWTEditConfiguration gwtConfig = new GWTEditConfiguration();
                gwtConfig.setName(config.getName());
                String defaultLocation = config.getDefaultLocation();
                if (defaultLocation.contains("$defaultSiteHome")) {
                    JahiaSite resolvedSite;
                    JahiaSitesService siteService = JahiaSitesService.getInstance();
                    JahiaSite jahiaSite = resolvedSite = !Url.isLocalhost(request.getServerName()) ? siteService.getSiteByServerName(request.getServerName(), session) : null;
                    if (resolvedSite == null) {
                        resolvedSite = JahiaSitesService.getInstance().getDefaultSite(session);
                        if (resolvedSite != null && !((JCRSiteNode)resolvedSite).hasPermission(config.getRequiredPermission())) {
                            resolvedSite = null;
                        }
                        if (resolvedSite == null) {
                            List<JCRSiteNode> sites = JahiaSitesService.getInstance().getSitesNodeList(session);
                            for (JCRSiteNode site : sites) {
                                if ("systemsite".equals(site.getName()) || !site.hasPermission(config.getRequiredPermission())) continue;
                                resolvedSite = site;
                                break;
                            }
                        }
                    }
                    if (resolvedSite != null) {
                        JCRSiteNode siteNode = (JCRSiteNode)session.getNode(((JCRNodeDecorator)((Object)resolvedSite)).getPath());
                        defaultLocation = defaultLocation.replace("$defaultSiteHome", siteNode.getHome().getPath());
                    } else {
                        defaultLocation = null;
                    }
                } else if (defaultLocation.contains("$user")) {
                    defaultLocation = defaultLocation.replace("$user", jahiaUser.getLocalPath());
                }
                gwtConfig.setDefaultLocation(defaultLocation);
                JCRNodeWrapper contextNode = null;
                JCRSiteNode site = null;
                if (contextPath == null) {
                    int nodeNameIndex = StringUtils.indexOf((String)defaultLocation, (String)".", (int)StringUtils.lastIndexOf((String)defaultLocation, (String)"/"));
                    contextPath = StringUtils.substring((String)defaultLocation, (int)0, (int)nodeNameIndex);
                    if (defaultLocation != null && session.nodeExists(contextPath)) {
                        contextNode = session.getNode(contextPath);
                        site = contextNode.getResolveSite();
                    }
                } else if (session.nodeExists(contextPath)) {
                    contextNode = session.getNode(contextPath);
                    site = contextNode.getResolveSite();
                }
                if (site == null) {
                    contextNode = session.getNode("/sites/systemsite");
                    site = contextNode.getResolveSite();
                }
                if ((languagesAsLocales = site.getLanguagesAsLocales()) != null && !languagesAsLocales.contains(locale) && StringUtils.isNotEmpty((String)(defaultLanguage = site.getDefaultLanguage()))) {
                    locale = LanguageCodeConverters.languageCodeToLocale(defaultLanguage);
                }
                gwtConfig.setTopToolbar(this.createGWTToolbar(contextNode, site, jahiaUser, locale, uiLocale, request, config.getTopToolbar()));
                gwtConfig.setSidePanelToolbar(this.createGWTToolbar(contextNode, site, jahiaUser, locale, uiLocale, request, config.getSidePanelToolbar()));
                gwtConfig.setMainModuleToolbar(this.createGWTToolbar(contextNode, site, jahiaUser, locale, uiLocale, request, config.getMainModuleToolbar()));
                gwtConfig.setContextMenu(this.createGWTToolbar(contextNode, site, jahiaUser, locale, uiLocale, request, config.getContextMenu()));
                gwtConfig.setTabs(this.createGWTSidePanelTabList(contextNode, site, jahiaUser, locale, uiLocale, request, config.getTabs()));
                gwtConfig.setEngineConfigurations(this.createGWTEngineConfigurations(contextNode, site, jahiaUser, locale, uiLocale, request, config.getEngineConfigurations()));
                gwtConfig.setSitesLocation(config.getSitesLocation());
                gwtConfig.setEnableDragAndDrop(config.isEnableDragAndDrop());
                gwtConfig.setDefaultUrlMapping(config.getDefaultUrlMapping());
                gwtConfig.setComponentsPaths(config.getComponentsPaths());
                gwtConfig.setEditableTypes(config.getEditableTypes());
                gwtConfig.setNonEditableTypes(config.getNonEditableTypes());
                gwtConfig.setSkipMainModuleTypesDomParsing(config.getSkipMainModuleTypesDomParsing());
                gwtConfig.setVisibleTypes(config.getVisibleTypes());
                gwtConfig.setNonVisibleTypes(config.getNonVisibleTypes());
                gwtConfig.setExcludedNodeTypes(config.getExcludedNodeTypes());
                ArrayList<String> configsList = new ArrayList<String>();
                for (EditConfiguration configuration : SpringContextSingleton.getInstance().getContext().getBeansOfType(EditConfiguration.class).values()) {
                    if (!StringUtils.equals((String)configuration.getSitesLocation(), (String)config.getSitesLocation()) || StringUtils.equals((String)config.getSitesLocation(), (String)"/sites/systemsite")) continue;
                    configsList.add(configuration.getName());
                }
                gwtConfig.setSamePathConfigsList(configsList);
                gwtConfig.setSiteNode(this.navigation.getGWTJahiaNode(site, GWTJahiaNode.DEFAULT_SITE_FIELDS, uiLocale));
                if (config.isLoadSitesList()) {
                    List<GWTJahiaNode> sites = this.navigation.retrieveRoot(Arrays.asList(config.getSitesLocation()), Arrays.asList("jnt:virtualsite"), null, null, GWTJahiaNode.DEFAULT_SITEMAP_FIELDS, null, null, site, session, uiLocale, false, false, null, null);
                    String permission = ((EditConfiguration)SpringContextSingleton.getBean(name)).getRequiredPermission();
                    HashMap<String, GWTJahiaNode> sitesMap = new HashMap<String, GWTJahiaNode>();
                    for (GWTJahiaNode aSite : sites) {
                        if (!session.getNodeByUUID(aSite.getUUID()).hasPermission(permission)) continue;
                        sitesMap.put(aSite.getSiteUUID(), aSite);
                    }
                    GWTJahiaNode systemSite = this.navigation.getGWTJahiaNode(session.getNode("/sites/systemsite"), GWTJahiaNode.DEFAULT_SITEMAP_FIELDS);
                    if (!sitesMap.containsKey(systemSite.getUUID())) {
                        sitesMap.put(systemSite.getUUID(), systemSite);
                    }
                    gwtConfig.setSitesMap(sitesMap);
                }
                this.setAvailablePermissions((GWTConfiguration)gwtConfig);
                gwtConfig.setChannels(this.channelHelper.getChannels());
                gwtConfig.setUseFullPublicationInfoInMainAreaModules(config.isUseFullPublicationInfoInMainAreaModules());
                gwtConfig.setSupportChannelsDisplay(config.isSupportChannelsDisplay());
                return gwtConfig;
            }
            throw new GWTJahiaServiceException(Messages.getInternal("label.gwt.error.bean.editconfig.not.found.in.spring.config.file", uiLocale));
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.config.not.found", uiLocale, name, e.getLocalizedMessage()));
        }
    }

    private void setAvailablePermissions(GWTConfiguration config) throws RepositoryException, GWTJahiaServiceException {
        Privilege[] p = JahiaPrivilegeRegistry.getRegisteredPrivileges();
        ArrayList<String> l = new ArrayList<String>();
        for (Privilege privilege : p) {
            l.add(((PrivilegeImpl)privilege).getPrefixedName());
        }
        config.setPermissions(l);
    }

    private List<GWTSidePanelTab> createGWTSidePanelTabList(JCRNodeWrapper contextNode, JCRSiteNode site, JahiaUser jahiaUser, Locale locale, Locale uiLocale, HttpServletRequest request, List<SidePanelTab> tabs) {
        ArrayList<GWTSidePanelTab> gwtSidePanelTabList = new ArrayList<GWTSidePanelTab>();
        for (SidePanelTab sidePanelTab : tabs) {
            GWTColumn col;
            if (!this.checkVisibility(contextNode, jahiaUser, locale, request, sidePanelTab.getVisibility())) continue;
            GWTSidePanelTab gwtSidePanel = new GWTSidePanelTab(sidePanelTab.getKey());
            gwtSidePanel.setTooltip(this.getResources("label.selectorTab." + sidePanelTab.getKey(), uiLocale, site, jahiaUser));
            gwtSidePanel.setTreeContextMenu(this.createGWTToolbar(contextNode, site, jahiaUser, locale, uiLocale, request, sidePanelTab.getTreeContextMenu()));
            gwtSidePanel.setTableContextMenu(this.createGWTToolbar(contextNode, site, jahiaUser, locale, uiLocale, request, sidePanelTab.getTableContextMenu()));
            gwtSidePanel.setIcon(sidePanelTab.getIcon());
            gwtSidePanel.setRequiredPermission(sidePanelTab.getRequiredPermission());
            gwtSidePanel.setTabItem(sidePanelTab.getTabItem());
            for (Column item : sidePanelTab.getTableColumns()) {
                if (!this.checkVisibility(contextNode, jahiaUser, locale, request, item.getVisibility())) continue;
                col = this.createGWTColumn(item, site, locale, uiLocale);
                gwtSidePanel.addTableColumn(col);
            }
            for (Column item : sidePanelTab.getTreeColumns()) {
                if (!this.checkVisibility(contextNode, jahiaUser, locale, request, item.getVisibility())) continue;
                col = this.createGWTColumn(item, site, locale, uiLocale);
                gwtSidePanel.addTreeColumn(col);
            }
            gwtSidePanelTabList.add(gwtSidePanel);
        }
        return gwtSidePanelTabList;
    }

    private Map<String, GWTEngineConfiguration> createGWTEngineConfigurations(JCRNodeWrapper contextNode, JCRSiteNode site, JahiaUser jahiaUser, Locale locale, Locale uiLocale, HttpServletRequest request, Map<String, EngineConfiguration> engineConfigurations) {
        return this.createGWTEngineConfigurations(contextNode, site, jahiaUser, locale, uiLocale, request, engineConfigurations, new ArrayList<EngineTab>());
    }

    private Map<String, GWTEngineConfiguration> createGWTEngineConfigurations(JCRNodeWrapper contextNode, JCRSiteNode site, JahiaUser jahiaUser, Locale locale, Locale uiLocale, HttpServletRequest request, Map<String, EngineConfiguration> engineConfigurations, List<EngineTab> defaultEngineTabs) {
        HashMap<String, GWTEngineConfiguration> gwtEngineConfigurations = new HashMap<String, GWTEngineConfiguration>();
        if (engineConfigurations != null) {
            for (Map.Entry<String, EngineConfiguration> type : engineConfigurations.entrySet()) {
                GWTEngineConfiguration gwtEngineConfiguration = new GWTEngineConfiguration();
                EngineConfiguration engineConfiguration = type.getValue();
                List<EngineTab> engineTabs = engineConfiguration.getEngineTabs();
                if (engineTabs == null) {
                    engineTabs = defaultEngineTabs;
                }
                gwtEngineConfiguration.setEngineTabs(this.createGWTEngineList(contextNode, site, jahiaUser, locale, uiLocale, request, engineTabs));
                gwtEngineConfiguration.setCreationButtons(engineConfiguration.getCreationButtons());
                gwtEngineConfiguration.setEditionButtons(engineConfiguration.getEditionButtons());
                gwtEngineConfiguration.setCommonButtons(engineConfiguration.getCommonButtons());
                gwtEngineConfigurations.put(type.getKey(), gwtEngineConfiguration);
            }
        }
        return gwtEngineConfigurations;
    }

    private List<GWTEngineTab> createGWTEngineList(JCRNodeWrapper contextNode, JCRSiteNode site, JahiaUser jahiaUser, Locale locale, Locale uiLocale, HttpServletRequest request, List<EngineTab> engines) {
        ArrayList<GWTEngineTab> engineTabs = new ArrayList<GWTEngineTab>();
        for (EngineTab engineTab : engines) {
            if (!this.checkVisibility(contextNode, jahiaUser, locale, request, engineTab.getVisibility())) continue;
            GWTEngineTab gwtTab = this.createGWTEngineTab(engineTab, site, locale, uiLocale);
            engineTabs.add(gwtTab);
        }
        return engineTabs;
    }

    private GWTEngineTab createGWTEngineTab(EngineTab engineTab, JCRSiteNode site, Locale locale, Locale uiLocale) {
        GWTEngineTab gwtTab = new GWTEngineTab();
        gwtTab.setId(engineTab.getId());
        if (engineTab.getTitleKey() != null) {
            gwtTab.setTitle(this.getResources(engineTab.getTitleKey(), uiLocale != null ? uiLocale : locale, site, null));
        } else {
            gwtTab.setTitle(engineTab.getTitle());
        }
        gwtTab.setTabItem(engineTab.getTabItem());
        gwtTab.setRequiredPermission(engineTab.getRequiredPermission());
        return gwtTab;
    }

    private String getResources(String key, Locale locale, JCRSiteNode site, JahiaUser jahiaUser) {
        if (key == null || key.length() == 0) {
            return key;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Resources key: " + key);
        }
        String baseName = null;
        String value = null;
        if (key.contains("@")) {
            baseName = StringUtils.substringAfter((String)key, (String)"@");
            key = StringUtils.substringBefore((String)key, (String)"@");
        }
        if ((value = Messages.get(baseName, site != null ? site.getTemplatePackage() : null, key, locale, null)) == null || value.length() == 0) {
            value = Messages.getInternal(key, locale);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Resources value: " + value);
        }
        if (value.contains("${")) {
            try {
                ScriptEngine scriptEngine = this.scriptEngineUtils.getEngineByName("velocity");
                SimpleScriptContext scriptContext = new SimpleScriptContext();
                SimpleBindings bindings = new SimpleBindings();
                bindings.put("currentSite", (Object)site);
                bindings.put("currentUser", (Object)jahiaUser);
                scriptContext.setBindings(bindings, 100);
                scriptContext.setBindings(scriptEngine.getContext().getBindings(200), 200);
                scriptContext.setWriter(new StringWriter());
                scriptContext.setErrorWriter(new StringWriter());
                scriptEngine.eval(value, (ScriptContext)scriptContext);
                return scriptContext.getWriter().toString().trim();
            }
            catch (ScriptException e) {
                logger.error("Error while executing script [" + value + "]", (Throwable)e);
            }
        }
        return value;
    }

    private boolean checkVisibility(JCRNodeWrapper contextNode, JahiaUser jahiaUser, Locale locale, HttpServletRequest request, Visibility visibility) {
        return visibility == null || visibility.getRealValue(contextNode, jahiaUser, locale, request);
    }

    public void setScriptEngineUtils(ScriptEngineUtils scriptEngineUtils) {
        this.scriptEngineUtils = scriptEngineUtils;
    }
}

