/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin;

import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jahia.bin.JahiaController;
import org.jahia.bin.errors.DefaultErrorHandler;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.usermanager.JahiaUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;

public abstract class BaseFindController
extends JahiaController {
    private static final Logger logger = LoggerFactory.getLogger(BaseFindController.class);
    protected int defaultLimit = 20;
    protected int hardLimit = 100;

    public void setDefaultLimit(int defaultLimit) {
        this.defaultLimit = defaultLimit;
    }

    public void setHardLimit(int hardLimit) {
        this.hardLimit = hardLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        long startTime = System.currentTimeMillis();
        String sessionId = null;
        try {
            if (logger.isInfoEnabled()) {
                sessionId = request.getSession().getId();
            }
            if (request.getMethod().equals("GET") || request.getMethod().equals("POST")) {
                this.handle(request, response);
            } else if (request.getMethod().equals("OPTIONS")) {
                response.setHeader("Allow", "GET, OPTIONS, POST");
            } else {
                response.sendError(405);
            }
        }
        catch (Exception e) {
            DefaultErrorHandler.getInstance().handle(e, request, response);
        }
        finally {
            if (logger.isInfoEnabled()) {
                StringBuilder sb = new StringBuilder(100);
                sb.append("Rendered [").append(request.getRequestURI());
                JahiaUser user = JCRTemplate.getInstance().getSessionFactory().getCurrentUser();
                if (user != null) {
                    sb.append("] user=[").append(user.getUsername());
                }
                sb.append("] ip=[").append(request.getRemoteAddr()).append("] sessionID=[").append(sessionId).append("] in [").append(System.currentTimeMillis() - startTime).append("ms]");
                logger.info(sb.toString());
            }
        }
        return null;
    }

    protected void handle(HttpServletRequest request, HttpServletResponse response) throws Exception {
    }

    public static class PropertyFilter {
        public static final PropertyFilter EMPTY = new PropertyFilter();
        private Set<String> excludes;
        private Set<String> includes;

        public Set<String> getExcludes() {
            return this.excludes;
        }

        public Set<String> getIncludes() {
            return this.includes;
        }

        public void setExcludes(Set<String> excludes) {
            this.excludes = excludes != null && excludes.size() == 0 ? null : excludes;
        }

        public void setIncludes(Set<String> includes) {
            this.includes = includes != null && includes.size() == 0 ? null : includes;
        }
    }
}

