/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin;

import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.jahia.bin.Render;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.render.RenderContext;
import org.jahia.services.uicomponents.bean.editmode.EditConfiguration;
import org.jahia.services.usermanager.JahiaUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dashboard
extends Render {
    private static final long serialVersionUID = -6197445426874881037L;
    private static Logger logger = LoggerFactory.getLogger(Dashboard.class);
    private EditConfiguration editConfiguration;

    @Override
    protected RenderContext createRenderContext(HttpServletRequest req, HttpServletResponse resp, JahiaUser user) {
        RenderContext context = super.createRenderContext(req, resp, user);
        context.setEditMode(true);
        context.setEditModeConfig(this.editConfiguration);
        try {
            context.setSite((JCRSiteNode)JCRSessionFactory.getInstance().getCurrentUserSession("live").getNode("/sites/systemsite"));
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        context.setForceUILocaleForJCRSession(true);
        return context;
    }

    @Override
    protected boolean hasAccess(JCRNodeWrapper node) {
        if (node == null) {
            logger.error("Site key is null.");
            return false;
        }
        try {
            String nodePath = node.getPath();
            if (!nodePath.startsWith("/modules") && !nodePath.startsWith(node.getSession().getUser().getLocalPath())) {
                logger.error("User : " + node.getSession().getUser().getUsername() + "tried to access the dashboard " + nodePath);
                return false;
            }
            if (node.getResolveSite() == null) {
                return false;
            }
            String checkedPath = StringUtils.replace((String)StringUtils.replace((String)this.editConfiguration.getNodeCheckPermission(), (String)"$site", (String)node.getResolveSite().getPath()), (String)"$user", (String)node.getSession().getUser().getLocalPath());
            if (this.editConfiguration.getNodeCheckPermission() == null) {
                checkedPath = node.getResolveSite().getPath();
            }
            return node.getSession().getNode(checkedPath).hasPermission(this.editConfiguration.getRequiredPermission()) && super.hasAccess(node);
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    @Override
    protected boolean isDisabled() {
        return false;
    }

    public EditConfiguration getEditConfiguration() {
        return this.editConfiguration;
    }

    public void setEditConfiguration(EditConfiguration editConfiguration) {
        this.editConfiguration = editConfiguration;
    }
}

