/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin;

import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.jahia.bin.Action;
import org.jahia.bin.ActionResult;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.URLResolver;
import org.json.JSONObject;

public class DefaultDeleteAction
extends Action {
    @Override
    public ActionResult doExecute(HttpServletRequest req, RenderContext renderContext, Resource resource, JCRSessionWrapper session, Map<String, List<String>> parameters, URLResolver urlResolver) throws Exception {
        JCRNodeWrapper node = session.getNode(urlResolver.getPath());
        String url = null;
        String mark = req.getParameter("jcrMarkForDeletion");
        if (mark != null && mark.length() > 0) {
            if (Boolean.valueOf(mark).booleanValue()) {
                node.markForDeletion(req.getParameter("jcrDeletionMessage"));
            } else {
                node.unmarkForDeletion();
            }
            url = node.getPath();
        } else {
            JCRNodeWrapper parent = node.getParent();
            if (!parent.isCheckedOut()) {
                session.checkout(parent);
            }
            if (!node.isCheckedOut()) {
                session.checkout(node);
            }
            node.remove();
            url = parent.getPath();
        }
        session.save();
        String requestWith = req.getHeader("x-requested-with");
        if (req.getHeader("accept").contains("application/json") && requestWith != null && requestWith.equals("XMLHttpRequest")) {
            return ActionResult.OK_JSON;
        }
        return new ActionResult(204, url, new JSONObject());
    }
}

