/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.jahia.bin.JahiaController;
import org.jahia.bin.errors.DefaultErrorHandler;
import org.jahia.exceptions.JahiaBadRequestException;
import org.jahia.exceptions.JahiaUnauthorizedException;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.importexport.ImportExportService;
import org.jahia.services.sites.JahiaSite;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.servlet.ModelAndView;

public class Export
extends JahiaController
implements ServletContextAware {
    private static Logger logger = LoggerFactory.getLogger(Export.class);
    public static final String CLEANUP = "cleanup";
    private static final String CONTROLLER_MAPPING = "/export";
    private static final Pattern URI_PATTERN = Pattern.compile("/export/(live|default)/(.*)\\.(xml|zip)");
    private String cleanupXsl;
    private ImportExportService importExportService;
    private String templatesCleanupXsl;

    public static String getExportServletPath() {
        return "/cms/export";
    }

    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            Matcher m;
            this.checkUserLoggedIn();
            Matcher matcher = m = StringUtils.isNotEmpty((String)request.getPathInfo()) ? URI_PATTERN.matcher(request.getPathInfo()) : null;
            if (m == null || !m.matches()) {
                throw new JahiaBadRequestException("Requested URI '" + request.getRequestURI() + "' is malformed");
            }
            String workspace = m.group(1);
            String nodePath = "/" + m.group(2);
            String exportFormat = m.group(3);
            if (StringUtils.isNotEmpty((String)request.getParameter("exportformat"))) {
                exportFormat = request.getParameter("exportformat");
            }
            Map<String, Object> params = this.getParams(request);
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession(workspace);
            JCRNodeWrapper exportRoot = null;
            if (request.getParameter("root") != null) {
                exportRoot = session.getNode(request.getParameter("root"));
            }
            if ("all".equals(exportFormat)) {
                if (!this.getCurrentUser().isRoot()) {
                    throw new JahiaUnauthorizedException("Only root user can perform export of all content");
                }
                response.setContentType("application/zip");
                WebUtils.setNoCacheHeaders(response);
                params.put("allfiles", Boolean.TRUE);
                params.put("templates", Boolean.TRUE);
                params.put("siteinfos", Boolean.TRUE);
                params.put("definitions", Boolean.TRUE);
                params.put("wf", Boolean.TRUE);
                params.put("xsl_path", this.cleanupXsl);
                ServletOutputStream outputStream = response.getOutputStream();
                this.importExportService.exportAll((OutputStream)outputStream, params);
                outputStream.close();
            } else if ("site".equals(exportFormat)) {
                if (!this.getCurrentUser().isRoot()) {
                    throw new JahiaUnauthorizedException("Only root user can perform export of a site");
                }
                ArrayList<JCRSiteNode> sites = new ArrayList<JCRSiteNode>();
                String[] sitekeys = request.getParameterValues("sitebox");
                if (sitekeys != null) {
                    for (String sitekey : sitekeys) {
                        JahiaSite site = ServicesRegistry.getInstance().getJahiaSitesService().getSiteByKey(sitekey);
                        sites.add((JCRSiteNode)site);
                    }
                }
                if (!sites.isEmpty()) {
                    response.setContentType("application/zip");
                    WebUtils.setNoCacheHeaders(response);
                    params.put("allfiles", Boolean.TRUE);
                    params.put("templates", Boolean.TRUE);
                    params.put("siteinfos", Boolean.TRUE);
                    params.put("definitions", Boolean.TRUE);
                    if (request.getParameter("live") == null || Boolean.valueOf(request.getParameter("live")).booleanValue()) {
                        params.put("includeLive", Boolean.TRUE);
                    }
                    if (request.getParameter("users") == null && SettingsBean.getInstance().getPropertiesFile().getProperty("siteExportUsersDefaultValue") != null) {
                        Boolean siteExportUsersDefaultValue = Boolean.valueOf(SettingsBean.getInstance().getPropertiesFile().getProperty("siteExportUsersDefaultValue"));
                        if (siteExportUsersDefaultValue.booleanValue()) {
                            params.put("includeUsers", Boolean.TRUE);
                        } else {
                            params.remove("includeUsers");
                        }
                    } else if (request.getParameter("users") != null) {
                        if (Boolean.valueOf(request.getParameter("users")).booleanValue()) {
                            params.put("includeUsers", Boolean.TRUE);
                        } else {
                            params.remove("includeUsers");
                        }
                    } else {
                        params.put("includeUsers", Boolean.TRUE);
                    }
                    params.put("includeRoles", Boolean.TRUE);
                    params.put("wf", Boolean.TRUE);
                    params.put("xsl_path", this.cleanupXsl);
                    ServletOutputStream outputStream = response.getOutputStream();
                    this.importExportService.exportSites((OutputStream)outputStream, params, sites);
                    outputStream.close();
                }
            } else if ("xml".equals(exportFormat)) {
                JCRNodeWrapper node = session.getNode(nodePath);
                response.setContentType("text/xml");
                WebUtils.setNoCacheHeaders(response);
                if ("template".equals(request.getParameter(CLEANUP))) {
                    params.put("xsl_path", this.templatesCleanupXsl);
                } else if ("simple".equals(request.getParameter(CLEANUP))) {
                    params.put("xsl_path", this.cleanupXsl);
                }
                ServletOutputStream outputStream = response.getOutputStream();
                Cookie exportedNode = new Cookie("exportedNode", node.getIdentifier());
                exportedNode.setMaxAge(60);
                exportedNode.setPath("/");
                response.addCookie(exportedNode);
                this.importExportService.exportNode(node, exportRoot, (OutputStream)outputStream, params);
            } else if ("zip".equals(exportFormat)) {
                JCRNodeWrapper node = session.getNode(nodePath);
                response.setContentType("application/zip");
                WebUtils.setNoCacheHeaders(response);
                if ("template".equals(request.getParameter(CLEANUP))) {
                    params.put("xsl_path", this.templatesCleanupXsl);
                } else if ("simple".equals(request.getParameter(CLEANUP))) {
                    params.put("xsl_path", this.cleanupXsl);
                }
                if (request.getParameter("live") == null || Boolean.valueOf(request.getParameter("live")).booleanValue()) {
                    params.put("includeLive", Boolean.TRUE);
                }
                ServletOutputStream outputStream = response.getOutputStream();
                Cookie exportedNode = new Cookie("exportedNode", node.getIdentifier());
                exportedNode.setMaxAge(60);
                exportedNode.setPath("/");
                response.addCookie(exportedNode);
                this.importExportService.exportZip(node, exportRoot, (OutputStream)outputStream, params);
                outputStream.close();
            }
            response.setStatus(200);
        }
        catch (IOException e) {
            logger.warn("Cannot export due to some IO exception :" + e.getMessage());
            DefaultErrorHandler.getInstance().handle(e, request, response);
        }
        catch (Exception e) {
            logger.error("Cannot export", (Throwable)e);
            DefaultErrorHandler.getInstance().handle(e, request, response);
        }
        return null;
    }

    private Map<String, Object> getParams(HttpServletRequest request) {
        HashMap<String, Object> params = new HashMap<String, Object>(6);
        params.put("content", !"false".equals(request.getParameter("viewContent")));
        params.put("version", "true".equals(request.getParameter("viewVersion")));
        params.put("acl", !"false".equals(request.getParameter("viewAcl")));
        params.put("metadata", !"false".equals(request.getParameter("viewMetadata")));
        params.put("links", !"false".equals(request.getParameter("viewLinks")));
        params.put("wf", "true".equals(request.getParameter("viewWorkflow")));
        return params;
    }

    public void setServletContext(ServletContext servletContext) {
        this.cleanupXsl = servletContext.getRealPath("/WEB-INF/etc/repository/export/cleanup.xsl");
        this.templatesCleanupXsl = servletContext.getRealPath("/WEB-INF/etc/repository/export/templatesCleanup.xsl");
    }

    public void setImportExportService(ImportExportService importExportService) {
        this.importExportService = importExportService;
    }
}

