/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.queryParser.QueryParser;
import org.jahia.bin.BaseFindController;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRValueWrapper;
import org.jahia.services.content.QueryManagerWrapper;
import org.jahia.services.render.RenderException;
import org.jahia.services.render.URLResolver;
import org.jahia.services.render.URLResolverFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Find
extends BaseFindController {
    private static Logger logger = LoggerFactory.getLogger(Find.class);
    private int defaultDepthLimit = 1;
    private boolean defaultEscapeColon = false;
    private boolean defaultRemoveDuplicatePropertyValues = false;
    private URLResolverFactory urlResolverFactory;

    public void setUrlResolverFactory(URLResolverFactory urlResolverFactory) {
        this.urlResolverFactory = urlResolverFactory;
    }

    private int getInt(String paramName, int defaultValue, HttpServletRequest req) throws IllegalArgumentException {
        int param = defaultValue;
        String valueStr = req.getParameter(paramName);
        if (StringUtils.isNotEmpty((String)valueStr)) {
            try {
                param = Integer.parseInt(valueStr);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Invalid integer value '" + valueStr + "' for request parameter '" + paramName + "'", nfe);
            }
        }
        return param;
    }

    private Query getQuery(HttpServletRequest request, HttpServletResponse response, String workspace, Locale locale) throws IOException, RepositoryException {
        QueryManagerWrapper qm = JCRSessionFactory.getInstance().getCurrentUserSession(workspace, locale).getWorkspace().getQueryManager();
        if (qm == null) {
            response.sendError(501);
            return null;
        }
        String query = request.getParameter("query");
        if (StringUtils.isEmpty((String)query)) {
            response.sendError(400, "Mandatory parameter 'query' is not found in the request");
            return null;
        }
        query = this.expandRequestMarkers(request, query, true, StringUtils.defaultIfEmpty((String)request.getParameter("language"), (String)"JCR-SQL2"), false);
        logger.debug("Using expanded query=[{}]", (Object)query);
        Query q = qm.createQuery(query, StringUtils.defaultIfEmpty((String)request.getParameter("language"), (String)"JCR-SQL2"));
        int limit = this.getInt("limit", this.defaultLimit, request);
        if (limit <= 0 || limit > this.hardLimit) {
            limit = this.hardLimit;
        }
        int offset = this.getInt("offset", 0, request);
        if (limit > 0) {
            q.setLimit((long)limit);
        }
        if (offset > 0) {
            q.setOffset((long)offset);
        }
        return q;
    }

    protected String expandRequestMarkers(HttpServletRequest request, String sourceString, boolean escapeValue, String queryLanguage, boolean escapeForRegexp) {
        String result = new String(sourceString);
        int refMarkerPos = result.indexOf("{$");
        while (refMarkerPos >= 0) {
            String refName;
            String refValue;
            int endRefMarkerPos = result.indexOf("}", refMarkerPos);
            if (endRefMarkerPos > 0 && (refValue = request.getParameter(refName = result.substring(refMarkerPos + 2, endRefMarkerPos))) != null) {
                if (escapeValue) {
                    refValue = QueryParser.escape((String)refValue);
                    if ("xpath".equals(queryLanguage)) {
                        refValue = StringUtils.replace((String)refValue, (String)"'", (String)"\\'");
                    }
                    refValue = StringUtils.replace((String)refValue, (String)"'", (String)"''");
                }
                if (escapeForRegexp) {
                    refValue = Pattern.quote(refValue);
                }
                result = StringUtils.replace((String)result, (String)("{$" + refName + "}"), (String)refValue);
            }
            refMarkerPos = result.indexOf("{$", refMarkerPos + 2);
        }
        return result;
    }

    @Override
    protected void handle(HttpServletRequest request, HttpServletResponse response) throws RenderException, IOException, RepositoryException {
        URLResolver urlResolver = this.urlResolverFactory.createURLResolver(request.getPathInfo(), request.getServerName(), request);
        try {
            Query query = this.getQuery(request, response, urlResolver.getWorkspace(), urlResolver.getLocale());
            if (query == null) {
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Executing " + query.getLanguage() + " for workspace '" + urlResolver.getWorkspace() + "' and locale '" + urlResolver.getLocale() + "'. Statement: " + query.getStatement());
            }
            this.writeResults(query.execute(), request, response, query.getLanguage());
        }
        catch (IllegalArgumentException e) {
            logger.error("Invalid argument", (Throwable)e);
            response.sendError(400, e.getMessage());
        }
        catch (InvalidQueryException e) {
            logger.error("Invalid query", (Throwable)e);
            response.sendError(400, e.getMessage());
        }
    }

    private JSONObject serializeNode(Node currentNode, int depthLimit, boolean escapeColon, Pattern propertyMatchRegexp, Map<String, String> alreadyIncludedPropertyValues) throws RepositoryException, JSONException {
        PropertyIterator stringMap = currentNode.getProperties();
        JSONObject jsonObject = new JSONObject();
        HashSet<String> matchingProperties = new HashSet<String>();
        while (stringMap.hasNext()) {
            JCRValueWrapper[] propValues;
            String name;
            JCRPropertyWrapper propertyWrapper = (JCRPropertyWrapper)stringMap.next();
            int type = propertyWrapper.getType();
            String string = name = escapeColon ? JCRContentUtils.replaceColon(propertyWrapper.getName()) : propertyWrapper.getName();
            if (type == 2) continue;
            if (type == 10 || type == 9) {
                if (propertyWrapper.isMultiple()) continue;
                try {
                    jsonObject.put(name, (Object)((JCRNodeWrapper)propertyWrapper.getNode()).getUrl());
                }
                catch (ItemNotFoundException ex) {
                    logger.warn("Referenced Item cannot be found (To solve it you can run the JCR Integrity Tools):", (Throwable)ex);
                    jsonObject.put(name, (Object)propertyWrapper.getValue().getString());
                }
                continue;
            }
            if (!propertyWrapper.isMultiple()) {
                jsonObject.put(name, (Object)propertyWrapper.getValue().getString());
                if (propertyMatchRegexp == null || !propertyMatchRegexp.matcher(propertyWrapper.getValue().getString()).matches()) continue;
                if (alreadyIncludedPropertyValues != null) {
                    String nodeIdentifier = alreadyIncludedPropertyValues.get(propertyWrapper.getValue().getString());
                    if (nodeIdentifier != null) {
                        if (!nodeIdentifier.equals(currentNode.getIdentifier())) {
                            return null;
                        }
                    } else {
                        alreadyIncludedPropertyValues.put(propertyWrapper.getValue().getString(), currentNode.getIdentifier());
                    }
                }
                matchingProperties.add(name);
                continue;
            }
            JSONArray jsonArray = new JSONArray();
            for (JCRValueWrapper propValue : propValues = propertyWrapper.getValues()) {
                jsonArray.put((Object)propValue.getString());
                if (propertyMatchRegexp == null || !propertyMatchRegexp.matcher(propValue.getString()).matches()) continue;
                if (alreadyIncludedPropertyValues != null) {
                    String nodeIdentifier = alreadyIncludedPropertyValues.get(propValue.getString());
                    if (nodeIdentifier != null) {
                        if (!nodeIdentifier.equals(currentNode.getIdentifier())) {
                            return null;
                        }
                    } else {
                        alreadyIncludedPropertyValues.put(propValue.getString(), currentNode.getIdentifier());
                    }
                }
                matchingProperties.add(name);
            }
            jsonObject.put(name, (Object)jsonArray);
        }
        jsonObject.put("path", (Object)currentNode.getPath());
        jsonObject.put("identifier", (Object)currentNode.getIdentifier());
        jsonObject.put("index", currentNode.getIndex());
        jsonObject.put("depth", currentNode.getDepth());
        jsonObject.put("nodename", (Object)currentNode.getName());
        jsonObject.put("primaryNodeType", (Object)currentNode.getPrimaryNodeType().getName());
        if (propertyMatchRegexp != null) {
            jsonObject.put("matchingProperties", (Object)new JSONArray(matchingProperties));
        }
        if (depthLimit - 1 > 0) {
            NodeIterator childNodeIterator = currentNode.getNodes();
            JSONArray childMapList = new JSONArray();
            while (childNodeIterator.hasNext()) {
                Node currentChildNode = childNodeIterator.nextNode();
                JSONObject childSerializedMap = this.serializeNode(currentChildNode, depthLimit - 1, escapeColon, propertyMatchRegexp, alreadyIncludedPropertyValues);
                childMapList.put((Object)childSerializedMap);
            }
            jsonObject.put("childNodes", (Object)childMapList);
        }
        return jsonObject;
    }

    private JSONObject serializeRow(Row row, String[] columns, int depthLimit, boolean escapeColon, Set<String> alreadyIncludedIdentifiers, Pattern propertyMatchRegexp, Map<String, String> alreadyIncludedPropertyValues) throws RepositoryException, JSONException {
        JSONObject jsonObject = new JSONObject();
        Node currentNode = row.getNode();
        if (currentNode != null) {
            JSONObject serializedNode;
            if (currentNode.isNodeType("jnt:translation")) {
                try {
                    currentNode = currentNode.getParent();
                    if (alreadyIncludedIdentifiers.contains(currentNode.getIdentifier())) {
                        return null;
                    }
                    serializedNode = this.serializeNode(currentNode, depthLimit, escapeColon, propertyMatchRegexp, alreadyIncludedPropertyValues);
                    if (serializedNode == null) {
                        return null;
                    }
                    jsonObject.put("node", (Object)serializedNode);
                    alreadyIncludedIdentifiers.add(currentNode.getIdentifier());
                }
                catch (ItemNotFoundException e) {
                    currentNode = null;
                }
            } else {
                if (alreadyIncludedIdentifiers.contains(currentNode.getIdentifier())) {
                    return null;
                }
                serializedNode = this.serializeNode(currentNode, depthLimit, escapeColon, propertyMatchRegexp, alreadyIncludedPropertyValues);
                if (serializedNode == null) {
                    return null;
                }
                jsonObject.put("node", (Object)serializedNode);
                alreadyIncludedIdentifiers.add(currentNode.getIdentifier());
            }
        }
        for (String column : columns) {
            try {
                Value value = row.getValue(column);
                jsonObject.put(escapeColon ? JCRContentUtils.replaceColon(column) : column, (Object)(value != null ? value.getString() : null));
            }
            catch (ItemNotFoundException infe) {
                logger.warn("No value found for column " + column);
            }
            catch (PathNotFoundException pnfe) {
                logger.warn("No value found for column " + column);
            }
        }
        return jsonObject;
    }

    public void setDefaultDepthLimit(int defaultDepthLimit) {
        this.defaultDepthLimit = defaultDepthLimit;
    }

    public void setDefaultEscapeColon(boolean defaultEscapeColon) {
        this.defaultEscapeColon = defaultEscapeColon;
    }

    public boolean isDefaultRemoveDuplicatePropertyValues() {
        return this.defaultRemoveDuplicatePropertyValues;
    }

    public void setDefaultRemoveDuplicatePropertyValues(boolean defaultRemoveDuplicatePropertyValues) {
        this.defaultRemoveDuplicatePropertyValues = defaultRemoveDuplicatePropertyValues;
    }

    private void writeResults(QueryResult result, HttpServletRequest request, HttpServletResponse response, String queryLanguage) throws RepositoryException, IllegalArgumentException, IOException, RenderException {
        response.setContentType("application/json; charset=UTF-8");
        int depth = this.getInt("depthLimit", this.defaultDepthLimit, request);
        boolean escape = Boolean.valueOf(StringUtils.defaultIfEmpty((String)request.getParameter("escapeColon"), (String)String.valueOf(this.defaultEscapeColon)));
        boolean removeDuplicatePropertyValues = Boolean.valueOf(StringUtils.defaultIfEmpty((String)request.getParameter("removeDuplicatePropValues"), (String)String.valueOf(this.defaultRemoveDuplicatePropertyValues)));
        Pattern propertyMatchRegexp = null;
        String propertyMatchRegexpString = request.getParameter("propertyMatchRegexp");
        if (propertyMatchRegexpString != null) {
            String expandedPattern = this.expandRequestMarkers(request, propertyMatchRegexpString, false, queryLanguage, true);
            propertyMatchRegexp = Pattern.compile(expandedPattern, 2);
        }
        JSONArray results = new JSONArray();
        try {
            String[] columns = result.getColumnNames();
            boolean serializeRows = !Boolean.parseBoolean(request.getParameter("getNodes")) && columns.length > 0 && !columns[0].contains("*");
            HashSet<String> alreadyIncludedIdentifiers = new HashSet<String>();
            HashMap<String, String> alreadyIncludedPropertyValues = null;
            if (removeDuplicatePropertyValues) {
                alreadyIncludedPropertyValues = new HashMap<String, String>();
            }
            int resultCount = 0;
            if (serializeRows) {
                logger.debug("Serializing rows into JSON result structure...");
                RowIterator rows = result.getRows();
                while (rows.hasNext()) {
                    Row row = rows.nextRow();
                    JSONObject serializedRow = this.serializeRow(row, columns, depth, escape, alreadyIncludedIdentifiers, propertyMatchRegexp, alreadyIncludedPropertyValues);
                    if (serializedRow == null) continue;
                    results.put((Object)serializedRow);
                    ++resultCount;
                }
            } else {
                logger.debug("Serializing nodes into JSON result structure...");
                NodeIterator nodes = result.getNodes();
                while (nodes.hasNext()) {
                    Node nextNode = nodes.nextNode();
                    JSONObject serializedNode = this.serializeNode(nextNode, depth, escape, propertyMatchRegexp, alreadyIncludedPropertyValues);
                    if (serializedNode == null) continue;
                    results.put((Object)serializedNode);
                    ++resultCount;
                }
            }
            logger.debug("Found {} results.", (Object)resultCount);
            results.write((Writer)response.getWriter());
        }
        catch (JSONException e) {
            throw new RenderException(e);
        }
    }

    public static String getFindServletPath() {
        return "/cms/find";
    }
}

