/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin;

import java.io.IOException;
import java.io.Writer;
import java.security.Principal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.jahia.bin.BaseFindController;
import org.jahia.exceptions.JahiaException;
import org.jahia.exceptions.JahiaForbiddenAccessException;
import org.jahia.services.render.RenderException;
import org.jahia.services.sites.JahiaSite;
import org.jahia.services.sites.JahiaSitesService;
import org.jahia.services.usermanager.JahiaGroup;
import org.jahia.services.usermanager.JahiaGroupManagerService;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.utils.Patterns;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindPrincipal
extends BaseFindController {
    private static Logger logger = LoggerFactory.getLogger(FindPrincipal.class);
    private static final String PRINCIPALTYPE_PARAMNAME = "principalType";
    private static final String WILDCARDTERM_PARAMNAME = "wildcardTerm";
    private static final String ESCAPECOLON_PARAMNAME = "escapeColon";
    private static final String SITEKEY_PARAMNAME = "siteKey";
    private static final String PROPERTYMATCHREGEXP_PARAMNAME = "propertyMatchRegexp";
    private static final String REMOVEDUPLICATEPROPVALUES_PARAMNAME = "removeDuplicatePropValues";
    private static final String INCLUDECRITERIANAMES_PARAMNAME = "includeCriteriaNames";
    private static final Set<String> RESERVED_PARAMETERNAMES = new HashSet<String>();
    private JahiaUserManagerService jahiaUserManagerService;
    private JahiaGroupManagerService jahiaGroupManagerService;
    private JahiaSitesService jahiaSitesService;

    public void setJahiaUserManagerService(JahiaUserManagerService jahiaUserManagerService) {
        this.jahiaUserManagerService = jahiaUserManagerService;
    }

    public void setJahiaGroupManagerService(JahiaGroupManagerService jahiaGroupManagerService) {
        this.jahiaGroupManagerService = jahiaGroupManagerService;
    }

    public void setJahiaSitesService(JahiaSitesService jahiaSitesService) {
        this.jahiaSitesService = jahiaSitesService;
    }

    protected String expandRequestMarkers(HttpServletRequest request, String sourceString) {
        String result = new String(sourceString);
        int refMarkerPos = result.indexOf("{$");
        while (refMarkerPos >= 0) {
            String refName;
            String refValue;
            int endRefMarkerPos = result.indexOf("}", refMarkerPos);
            if (endRefMarkerPos > 0 && (refValue = request.getParameter(refName = result.substring(refMarkerPos + 2, endRefMarkerPos))) != null) {
                result = StringUtils.replace((String)result, (String)("{$" + refName + "}"), (String)refValue);
            }
            refMarkerPos = result.indexOf("{$", refMarkerPos + 2);
        }
        return result;
    }

    protected String retrieveParameter(HttpServletRequest request, HttpServletResponse response, String parameterName, boolean mandatory) throws IOException {
        String parameterValue = request.getParameter(parameterName);
        if (!StringUtils.isEmpty((String)parameterValue)) {
            parameterValue = this.expandRequestMarkers(request, parameterValue);
        }
        if (mandatory && StringUtils.isEmpty((String)parameterValue)) {
            response.sendError(400, "Mandatory parameter '" + parameterName + "' is not found in the request");
            throw new IOException("Mandatory parameter '" + parameterName + "' is not found in the request");
        }
        return parameterValue;
    }

    protected Map<String, String[]> retrieveOtherParameters(HttpServletRequest request) throws IOException {
        HashMap<String, String[]> parameterMap = new HashMap<String, String[]>(request.getParameterMap());
        for (String reservedParameterName : RESERVED_PARAMETERNAMES) {
            parameterMap.remove(reservedParameterName);
        }
        return parameterMap;
    }

    protected Properties buildSearchCriterias(String wildcardTerm, Map<String, String[]> otherRequestParameters, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Properties criterias = new Properties();
        if (wildcardTerm != null) {
            criterias.setProperty("*", wildcardTerm);
        }
        String includeCriteriaNames = this.retrieveParameter(request, response, INCLUDECRITERIANAMES_PARAMNAME, false);
        HashSet<String> criteriasToInclude = new HashSet<String>();
        if (includeCriteriaNames != null) {
            if (includeCriteriaNames.indexOf(",") >= 0) {
                String[] criteriaNamesArray = Patterns.COMMA.split(includeCriteriaNames);
                List<String> criteriaNamesList = Arrays.asList(criteriaNamesArray);
                criteriasToInclude.addAll(criteriaNamesList);
            } else {
                criteriasToInclude.add(includeCriteriaNames);
            }
        }
        for (Map.Entry<String, String[]> curEntry : otherRequestParameters.entrySet()) {
            String[] paramValues = curEntry.getValue();
            if (criteriasToInclude.size() > 0 && !criteriasToInclude.contains(curEntry.getKey())) {
                logger.debug("Ignoring parameter with name " + curEntry.getKey() + " since it wasn't specified in the include criteria name list");
                continue;
            }
            if (paramValues.length < 1) {
                logger.warn("Parameter " + curEntry.getKey() + " has invalid value(s), ignoring it.");
                continue;
            }
            if (paramValues.length > 1) {
                logger.warn("Parameter " + curEntry.getKey() + " has more than one value, only the first one will be used.");
                continue;
            }
            criterias.setProperty(curEntry.getKey(), this.expandRequestMarkers(request, paramValues[0]));
        }
        return criterias;
    }

    private void writeUserResults(Set<Principal> users, HttpServletRequest request, HttpServletResponse response, String propertyMatchRegexp, boolean removeDuplicatePropValues) throws RepositoryException, IllegalArgumentException, IOException, RenderException, JSONException {
        response.setContentType("application/json; charset=UTF-8");
        JSONArray results = new JSONArray();
        HashMap<String, String> alreadyIncludedPropertyValues = null;
        if (removeDuplicatePropValues) {
            alreadyIncludedPropertyValues = new HashMap<String, String>();
        }
        Pattern pattern = propertyMatchRegexp != null ? Pattern.compile(propertyMatchRegexp, 2) : null;
        for (Principal principal : users) {
            JSONObject jsonPrincipal = new JSONObject((Object)principal);
            if (principal instanceof JahiaUser && pattern != null) {
                JahiaUser jahiaUser = (JahiaUser)principal;
                Properties userProperties = jahiaUser.getProperties();
                HashSet<String> matchingProperties = new HashSet<String>();
                for (Map.Entry<Object, Object> curPropertyEntry : userProperties.entrySet()) {
                    String curPropertyName = (String)curPropertyEntry.getKey();
                    String curPropertyValue = (String)curPropertyEntry.getValue();
                    if (!pattern.matcher(curPropertyValue).matches()) continue;
                    if (alreadyIncludedPropertyValues != null) {
                        String nodeIdentifier = (String)alreadyIncludedPropertyValues.get(curPropertyValue);
                        if (nodeIdentifier != null) {
                            if (!nodeIdentifier.equals(jahiaUser.getUserKey())) {
                                break;
                            }
                        } else {
                            alreadyIncludedPropertyValues.put(curPropertyValue, jahiaUser.getUserKey());
                        }
                    }
                    matchingProperties.add(curPropertyName);
                }
                jsonPrincipal.put("matchingProperties", (Object)new JSONArray(matchingProperties));
            }
            results.put((Object)jsonPrincipal);
        }
        try {
            results.write((Writer)response.getWriter());
        }
        catch (JSONException e) {
            throw new RenderException(e);
        }
    }

    private void writeGroupResults(Set<JahiaGroup> groups, HttpServletRequest request, HttpServletResponse response, String propertyMatchRegexp, boolean removeDuplicatePropValues) throws RepositoryException, IllegalArgumentException, IOException, RenderException, JSONException {
        response.setContentType("application/json; charset=UTF-8");
        JSONArray results = new JSONArray();
        HashMap<String, String> alreadyIncludedPropertyValues = null;
        if (removeDuplicatePropValues) {
            alreadyIncludedPropertyValues = new HashMap<String, String>();
        }
        for (JahiaGroup jahiaGroup : groups) {
            JSONObject jsonGroup = new JSONObject((Object)jahiaGroup);
            if (propertyMatchRegexp != null) {
                Pattern pattern = Pattern.compile(propertyMatchRegexp, 2);
                Properties userProperties = jahiaGroup.getProperties();
                HashSet<String> matchingProperties = new HashSet<String>();
                for (Map.Entry<Object, Object> curPropertyEntry : userProperties.entrySet()) {
                    String curPropertyName = (String)curPropertyEntry.getKey();
                    String curPropertyValue = (String)curPropertyEntry.getValue();
                    if (!pattern.matcher(curPropertyValue).matches()) continue;
                    if (alreadyIncludedPropertyValues != null) {
                        String nodeIdentifier = (String)alreadyIncludedPropertyValues.get(curPropertyValue);
                        if (nodeIdentifier != null) {
                            if (!nodeIdentifier.equals(jahiaGroup.getGroupKey())) {
                                break;
                            }
                        } else {
                            alreadyIncludedPropertyValues.put(curPropertyValue, jahiaGroup.getGroupKey());
                        }
                    }
                    matchingProperties.add(curPropertyName);
                }
                jsonGroup.put("matchingProperties", (Object)new JSONArray(matchingProperties));
            }
            results.put((Object)jsonGroup);
        }
        try {
            results.write((Writer)response.getWriter());
        }
        catch (JSONException e) {
            throw new RenderException(e);
        }
    }

    @Override
    protected void handle(HttpServletRequest request, HttpServletResponse response) throws RenderException, IOException, RepositoryException, JahiaForbiddenAccessException {
        block12: {
            this.checkUserLoggedIn();
            this.checkUserAuthorized();
            try {
                String principalType = this.retrieveParameter(request, response, PRINCIPALTYPE_PARAMNAME, true);
                if (principalType == null) {
                    return;
                }
                String wildcardTerm = this.retrieveParameter(request, response, WILDCARDTERM_PARAMNAME, false);
                String propertyMatchRegExp = this.retrieveParameter(request, response, PROPERTYMATCHREGEXP_PARAMNAME, false);
                String removeDuplicatePropValuesStr = this.retrieveParameter(request, response, REMOVEDUPLICATEPROPVALUES_PARAMNAME, false);
                boolean removeDuplicatePropValues = false;
                if (removeDuplicatePropValuesStr != null) {
                    removeDuplicatePropValues = Boolean.parseBoolean(removeDuplicatePropValuesStr);
                }
                boolean siteKeyMandatory = false;
                if ("groups".equals(principalType)) {
                    siteKeyMandatory = true;
                }
                String siteKey = this.retrieveParameter(request, response, SITEKEY_PARAMNAME, siteKeyMandatory);
                Map<String, String[]> otherRequestParameters = this.retrieveOtherParameters(request);
                Properties searchCriterias = this.buildSearchCriterias(wildcardTerm, otherRequestParameters, request, response);
                if (logger.isDebugEnabled()) {
                    logger.debug("Searching for principal type " + principalType + " with criterias " + searchCriterias);
                }
                if ("users".equals(principalType)) {
                    Set<Principal> result = this.jahiaUserManagerService.searchUsers(searchCriterias);
                    this.writeUserResults(result, request, response, propertyMatchRegExp, removeDuplicatePropValues);
                    break block12;
                }
                if ("groups".equals(principalType)) {
                    if (siteKey == null) {
                        logger.error("Site key is mandatory for group searching and is missing in request, aborting searching...");
                        response.sendError(400);
                        return;
                    }
                    JahiaSite site = null;
                    try {
                        site = this.jahiaSitesService.getSiteByKey(siteKey);
                    }
                    catch (JahiaException e) {
                        logger.error("Error while trying to retrieve site with key " + siteKey + ", aborting search... ", (Throwable)e);
                        response.sendError(400);
                        return;
                    }
                    Set<JahiaGroup> result = this.jahiaGroupManagerService.searchGroups(site.getSiteKey(), searchCriterias);
                    this.writeGroupResults(result, request, response, propertyMatchRegExp, removeDuplicatePropValues);
                    break block12;
                }
                logger.error("Principal type value " + principalType + " is invalid, aborting searching...");
                response.sendError(400);
                return;
            }
            catch (JSONException jsone) {
                logger.error("JSON serialization error ", (Throwable)jsone);
                response.sendError(400, jsone.getMessage());
            }
            catch (IllegalArgumentException e) {
                logger.error("Invalid argument", (Throwable)e);
                response.sendError(400, e.getMessage());
            }
        }
    }

    public static String getFindPrincipalServletPath() {
        return "/cms/findPrincipal";
    }

    static {
        RESERVED_PARAMETERNAMES.add(PRINCIPALTYPE_PARAMNAME);
        RESERVED_PARAMETERNAMES.add(WILDCARDTERM_PARAMNAME);
        RESERVED_PARAMETERNAMES.add(ESCAPECOLON_PARAMNAME);
        RESERVED_PARAMETERNAMES.add(SITEKEY_PARAMNAME);
        RESERVED_PARAMETERNAMES.add(PROPERTYMATCHREGEXP_PARAMNAME);
        RESERVED_PARAMETERNAMES.add(REMOVEDUPLICATEPROPVALUES_PARAMNAME);
        RESERVED_PARAMETERNAMES.add(INCLUDECRITERIANAMES_PARAMNAME);
    }
}

