/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin;

import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.jahia.bin.FindUser;
import org.jahia.data.viewhelper.principal.PrincipalViewHelper;
import org.jahia.exceptions.JahiaBadRequestException;
import org.jahia.exceptions.JahiaException;
import org.jahia.services.sites.JahiaSite;
import org.jahia.services.sites.JahiaSitesService;
import org.jahia.services.usermanager.JahiaGroup;
import org.jahia.services.usermanager.JahiaGroupManagerService;
import org.jahia.services.usermanager.JahiaUser;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindUsersAndGroups
extends FindUser {
    private static final Logger logger = LoggerFactory.getLogger(FindUsersAndGroups.class);
    protected Set<String> groupDisplayProperties = Collections.emptySet();
    protected Set<String> groupSearchProperties = new HashSet<String>(Arrays.asList("groupname"));
    private JahiaGroupManagerService groupService;
    private JahiaSitesService siteService;

    public static String getFindUsersAndGroupsServletPath() {
        return "/cms/findUsersAndGroups";
    }

    protected String getSiteKey(HttpServletRequest request) {
        String siteKey = FindUsersAndGroups.getParameter(request, "siteKey", null);
        if (siteKey == null) {
            int siteId = FindUsersAndGroups.getIntParameter(request, "siteId");
            try {
                JahiaSite site = this.siteService.getSite(siteId);
                if (site == null) {
                    throw new JahiaBadRequestException("Site with id " + siteId + " cannot be found");
                }
                siteKey = site.getSiteKey();
            }
            catch (JahiaException e) {
                throw new JahiaBadRequestException(e);
            }
        }
        return siteKey;
    }

    @Override
    protected Set<Principal> search(String queryTerm, HttpServletRequest request) {
        int limit = Math.min(FindUsersAndGroups.getIntParameter(request, "limit", this.defaultLimit), this.hardLimit);
        if (!queryTerm.contains("*")) {
            queryTerm = queryTerm + "*";
        }
        Set<Principal> users = this.searchUsers(queryTerm);
        Set<JahiaGroup> groups = this.searchGroups(queryTerm, request);
        HashSet<Principal> result = new HashSet<Principal>();
        if (users.size() + groups.size() <= limit) {
            result.addAll(users);
            result.addAll(groups);
        } else {
            if (users.size() <= limit / 2) {
                result.addAll(users);
            } else {
                result.addAll(new LinkedList<Principal>(users).subList(0, Math.max(limit / 2, limit - groups.size())));
            }
            for (JahiaGroup g : groups) {
                if (result.size() >= limit) break;
                result.add(g);
            }
        }
        return result;
    }

    protected Set<JahiaGroup> searchGroups(String queryTerm, HttpServletRequest request) {
        long startTime = System.currentTimeMillis();
        String siteKey = this.getSiteKey(request);
        Properties searchCriterias = new Properties();
        for (String key : this.groupSearchProperties) {
            searchCriterias.put(key, queryTerm);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Performing group search using criteria: {}", (Object)searchCriterias);
        }
        Set<JahiaGroup> result = this.groupService.searchGroups(siteKey, searchCriterias);
        if (logger.isDebugEnabled()) {
            logger.debug("Found {} matching groups in {} ms", (Object)result.size(), (Object)(System.currentTimeMillis() - startTime));
        }
        return result;
    }

    public void setGroupDisplayProperties(Set<String> groupDisplayProperties) {
        this.groupDisplayProperties = groupDisplayProperties;
    }

    public void setGroupSearchProperties(Set<String> groupSearchProperties) {
        this.groupSearchProperties = groupSearchProperties;
    }

    public void setJahiaGroupManagerService(JahiaGroupManagerService groupService) {
        this.groupService = groupService;
    }

    public void setJahiaSitesService(JahiaSitesService siteService) {
        this.siteService = siteService;
    }

    protected JSONObject toJSON(JahiaGroup group) throws JSONException {
        JSONObject json = new JSONObject();
        json.put("key", (Object)("g:" + group.getGroupname()));
        json.put("groupKey", (Object)group.getGroupKey());
        json.put("groupname", (Object)group.getGroupname());
        json.put("displayName", (Object)PrincipalViewHelper.getFullName(group));
        json.put("type", (Object)"g");
        for (String key : this.groupDisplayProperties) {
            String value = group.getProperty(key);
            if (value == null) continue;
            json.put(key, (Object)value);
        }
        return json;
    }

    @Override
    protected JSONObject toJSON(JahiaUser user) throws JSONException {
        JSONObject json = super.toJSON(user);
        json.put("key", (Object)("u:" + user.getUsername()));
        String fullName = PrincipalViewHelper.getFullName(user);
        if (!fullName.equals(user.getUsername())) {
            fullName = fullName + " (" + user.getUsername() + ")";
        }
        json.put("displayName", (Object)fullName);
        json.put("type", (Object)"u");
        return json;
    }

    @Override
    protected JSONObject toJSON(Principal principal) throws JSONException {
        return principal instanceof JahiaGroup ? this.toJSON((JahiaGroup)principal) : this.toJSON((JahiaUser)principal);
    }
}

