/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin;

import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.jahia.bin.FindUsersAndGroups;
import org.jahia.exceptions.JahiaBadRequestException;
import org.jahia.exceptions.JahiaRuntimeException;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.usermanager.JahiaGroup;
import org.jahia.services.usermanager.JahiaUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindUsersAndGroupsInAcl
extends FindUsersAndGroups {
    private static final Logger logger = LoggerFactory.getLogger(FindUsersAndGroupsInAcl.class);

    public static String getFindUsersAndGroupsInAclServletPath() {
        return "/cms/findUsersAndGroupsInAcl";
    }

    protected Set<Principal> findMatchingPrincipals(List<Map<String, Object>> rolesForNode, String queryTerm) {
        if (rolesForNode.isEmpty()) {
            return Collections.emptySet();
        }
        Pattern pattern = Pattern.compile(queryTerm, 2);
        HashSet<Principal> matching = new HashSet<Principal>();
        for (Map<String, Object> principalEntry : rolesForNode) {
            Principal principal = (Principal)principalEntry.get("principal");
            if ("user".equals(principalEntry.get("principalType"))) {
                if (!this.userMatches((JahiaUser)principal, pattern)) continue;
                matching.add(principal);
                continue;
            }
            if ("group".equals(principalEntry.get("principalType"))) {
                if (!this.groupMatches((JahiaGroup)principal, pattern)) continue;
                matching.add(principal);
                continue;
            }
            logger.warn("Unknown principal type for entry {}. Skipping.", principalEntry);
        }
        return matching;
    }

    protected boolean groupMatches(JahiaGroup group, Pattern pattern) {
        boolean matches = false;
        for (String prop : this.groupSearchProperties) {
            String value = "groupname".equals(prop) ? group.getGroupname() : group.getProperty(prop);
            if (!StringUtils.isNotEmpty((String)value) || !pattern.matcher(value).matches()) continue;
            matches = true;
            break;
        }
        return matches;
    }

    @Override
    protected Set<Principal> search(String queryTerm, HttpServletRequest request) {
        String sourceNodePath = FindUsersAndGroupsInAcl.getParameter(request, "sourceNode");
        queryTerm = queryTerm.contains("*") ? StringUtils.replace((String)queryTerm, (String)"*", (String)".*") : queryTerm + ".*";
        JCRNodeWrapper sourceNode = null;
        try {
            sourceNode = JCRSessionFactory.getInstance().getCurrentUserSession().getNode(sourceNodePath);
        }
        catch (PathNotFoundException e) {
            throw new JahiaBadRequestException("Source node " + sourceNodePath + " cannot be found", e);
        }
        catch (RepositoryException e) {
            throw new JahiaRuntimeException(e);
        }
        List<Map<String, Object>> rolesForNode = JCRContentUtils.getRolesForNode(sourceNode, Boolean.valueOf(FindUsersAndGroupsInAcl.getParameter(request, "includeInherited", "false")), true, FindUsersAndGroupsInAcl.getParameter(request, "roles", null), -1, false);
        rolesForNode.addAll(JCRContentUtils.getRolesForNode(sourceNode, Boolean.valueOf(FindUsersAndGroupsInAcl.getParameter(request, "includeInherited", "false")), false, FindUsersAndGroupsInAcl.getParameter(request, "roles", null), -1, false));
        Set<Principal> result = this.findMatchingPrincipals(rolesForNode, queryTerm);
        if (logger.isDebugEnabled()) {
            logger.debug("Found {} matching principals in ACL of the node {}", (Object)result.size(), (Object)sourceNodePath);
        }
        return result;
    }

    protected boolean userMatches(JahiaUser user, Pattern pattern) {
        boolean matches = false;
        for (String prop : this.searchProperties) {
            String value = "username".equals(prop) ? user.getUsername() : user.getProperty(prop);
            if (!StringUtils.isNotEmpty((String)value) || !pattern.matcher(value).matches()) continue;
            matches = true;
            break;
        }
        return matches;
    }
}

