/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin;

import javax.servlet.http.HttpServletRequest;
import org.jahia.bin.JahiaControllerUtils;
import org.jahia.exceptions.JahiaBadRequestException;
import org.jahia.exceptions.JahiaForbiddenAccessException;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.usermanager.JahiaUser;
import org.springframework.web.servlet.mvc.multiaction.MultiActionController;

public abstract class JahiaMultiActionController
extends MultiActionController {
    private String requiredPermission;

    protected static final String getParameter(HttpServletRequest request, String name) throws JahiaBadRequestException {
        return JahiaControllerUtils.getParameter(request, name);
    }

    protected static final String getParameter(HttpServletRequest request, String name, String defaultValue) {
        return JahiaControllerUtils.getParameter(request, name, defaultValue);
    }

    protected void checkUserAuthorized() throws JahiaForbiddenAccessException {
        JahiaControllerUtils.checkUserAuthorized(this.getCurrentUser(), this.getRequiredPermission());
    }

    protected void checkUserAuthorized(JCRNodeWrapper node) throws JahiaForbiddenAccessException {
        JahiaControllerUtils.checkUserAuthorized(node, this.getCurrentUser(), this.getRequiredPermission());
    }

    protected void checkUserLoggedIn() throws JahiaForbiddenAccessException {
        JahiaControllerUtils.checkUserLoggedIn(this.getCurrentUser());
    }

    protected JahiaUser getCurrentUser() {
        return JCRSessionFactory.getInstance().getCurrentUser();
    }

    protected String getRequiredPermission() {
        return this.requiredPermission;
    }

    public void setRequiredPermission(String requiredPermission) {
        this.requiredPermission = requiredPermission;
    }
}

