/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin.filters;

import com.phloc.commons.io.IInputStreamProvider;
import com.phloc.css.ECSSVersion;
import com.phloc.css.decl.CSSExpressionMemberTermSimple;
import com.phloc.css.decl.CSSImportRule;
import com.phloc.css.decl.CSSMediaExpression;
import com.phloc.css.decl.CSSMediaQuery;
import com.phloc.css.decl.CSSMediaRule;
import com.phloc.css.decl.CascadingStyleSheet;
import com.phloc.css.decl.ICSSTopLevelRule;
import com.phloc.css.reader.CSSReader;
import com.phloc.css.writer.CSSWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.Charsets;
import org.apache.commons.lang.StringUtils;
import org.jahia.bin.Jahia;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.channels.Channel;
import org.jahia.services.channels.ChannelService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSSChannelFilter
implements Filter {
    private static Logger logger = LoggerFactory.getLogger(CSSChannelFilter.class);
    private ServletContext servletContext;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.servletContext = filterConfig.getServletContext();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String channelId = request.getParameter("channel");
        if (channelId != null) {
            String channelVariant = request.getParameter("variant");
            ChannelService service = (ChannelService)SpringContextSingleton.getInstance().getContext().getBean("ChannelService");
            Channel channel = service.getChannel(channelId);
            String uri = ((HttpServletRequest)request).getRequestURI();
            final InputStream stream = this.servletContext.getResourceAsStream(uri.replace(Jahia.getContextPath(), ""));
            CascadingStyleSheet css = CSSReader.readFromStream((IInputStreamProvider)new IInputStreamProvider(){

                public InputStream getInputStream() {
                    return stream;
                }
            }, (Charset)Charsets.UTF_8, (ECSSVersion)ECSSVersion.CSS30);
            if (css != null) {
                ArrayList<CSSMediaRule> filteredOutRules = new ArrayList<CSSMediaRule>();
                for (CSSMediaRule mediaRule : css.getAllMediaRules()) {
                    if (!this.evalMediaRule(channel, mediaRule.getAllMediaQueries(), channelVariant)) {
                        filteredOutRules.add(mediaRule);
                        continue;
                    }
                    for (CSSMediaQuery mediaQuery : mediaRule.getAllMediaQueries()) {
                        mediaQuery.getAllMediaExpressions().clear();
                    }
                }
                ArrayList<CSSImportRule> filteredOutImports = new ArrayList<CSSImportRule>();
                List imports = css.getAllImportRules();
                for (CSSImportRule anImport : imports) {
                    if (this.evalMediaRule(channel, anImport.getAllMediaQueries(), channelVariant)) continue;
                    filteredOutImports.add(anImport);
                }
                if (!filteredOutRules.isEmpty() || !filteredOutImports.isEmpty()) {
                    for (CSSMediaRule filteredOutRule : filteredOutRules) {
                        css.removeRule((ICSSTopLevelRule)filteredOutRule);
                    }
                    for (CSSImportRule filteredOutImport : filteredOutImports) {
                        css.removeImportRule(filteredOutImport);
                    }
                    CascadingStyleSheet sheet = new CascadingStyleSheet();
                    List allRules = css.getAllRules();
                    for (ICSSTopLevelRule rule : allRules) {
                        if (rule instanceof CSSMediaRule) {
                            List allRulesInMediaRule = ((CSSMediaRule)rule).getAllRules();
                            for (ICSSTopLevelRule icssTopLevelRule : allRulesInMediaRule) {
                                sheet.addRule(icssTopLevelRule);
                            }
                            continue;
                        }
                        sheet.addRule(rule);
                    }
                    CSSWriter w = new CSSWriter(ECSSVersion.CSS30);
                    w.writeCSS(sheet, (Writer)response.getWriter());
                    return;
                }
            } else {
                logger.warn("Cannot parse CSS " + uri);
            }
        }
        chain.doFilter(request, response);
    }

    private boolean evalMediaRule(Channel channel, List<CSSMediaQuery> mediaQueries, String channelVariant) {
        for (CSSMediaQuery mediaQuery : mediaQueries) {
            for (CSSMediaExpression mediaExpr : mediaQuery.getAllMediaExpressions()) {
                if (this.evalFeature(mediaExpr, channel, channelVariant)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean evalFeature(CSSMediaExpression mediaExpr, Channel channel, String channelVariant) {
        List<String> variants;
        Modifier modifier = Modifier.EQUALS;
        String feature = mediaExpr.getFeature().toLowerCase();
        if (feature.startsWith("max-")) {
            modifier = Modifier.MAX;
            feature = StringUtils.substringAfter((String)feature, (String)"max-");
        } else if (feature.startsWith("min-")) {
            modifier = Modifier.MIN;
            feature = StringUtils.substringAfter((String)feature, (String)"min-");
        }
        int channelIndex = 0;
        if (channelVariant != null && (variants = Arrays.asList(channel.getCapability("variants").split(","))).contains(channelVariant)) {
            channelIndex = variants.indexOf(channelVariant);
        }
        String capability = channel.getCapability("usable-resolutions");
        capability = capability.split(",")[channelIndex];
        if (feature.equals("width")) {
            List allSimpleMembers = mediaExpr.getValue().getAllSimpleMembers();
            if (allSimpleMembers != null && !allSimpleMembers.isEmpty()) {
                return this.evalLength(modifier, capability, ((CSSExpressionMemberTermSimple)allSimpleMembers.get(0)).getValue(), 0, "x");
            }
        } else if (feature.equals("height")) {
            List allSimpleMembers = mediaExpr.getValue().getAllSimpleMembers();
            if (allSimpleMembers != null && !allSimpleMembers.isEmpty()) {
                return this.evalLength(modifier, capability, ((CSSExpressionMemberTermSimple)allSimpleMembers.get(0)).getValue(), 1, "x");
            }
        } else if (feature.equals("device-width")) {
            List allSimpleMembers = mediaExpr.getValue().getAllSimpleMembers();
            if (allSimpleMembers != null && !allSimpleMembers.isEmpty()) {
                return this.evalLength(modifier, capability, ((CSSExpressionMemberTermSimple)allSimpleMembers.get(0)).getValue(), 0, "x");
            }
        } else if (feature.equals("device-height")) {
            List allSimpleMembers = mediaExpr.getValue().getAllSimpleMembers();
            if (allSimpleMembers != null && !allSimpleMembers.isEmpty()) {
                return this.evalLength(modifier, capability, ((CSSExpressionMemberTermSimple)allSimpleMembers.get(0)).getValue(), 1, "x");
            }
        } else if (feature.equals("orientation")) {
            List allSimpleMembers = mediaExpr.getValue().getAllSimpleMembers();
            if (allSimpleMembers != null && !allSimpleMembers.isEmpty()) {
                String value = ((CSSExpressionMemberTermSimple)allSimpleMembers.get(0)).getValue();
                return channelVariant == null && channel.getCapability("variants").split(",")[0].equals(value) || value.equals(channelVariant);
            }
        } else if (feature.equals("aspect-ratio") || feature.equals("device-aspect-ratio") || feature.equals("color") || feature.equals("monochrome") || feature.equals("resolution") || feature.equals("scan") || feature.equals("grid")) {
            // empty if block
        }
        return true;
    }

    public boolean evalLength(Modifier modifier, String realValue, String value, int indexOfRealValueInChannel, String channelValueSeparator) {
        if (realValue == null) {
            return true;
        }
        int rv = channelValueSeparator != null ? Integer.parseInt(realValue.split(channelValueSeparator)[indexOfRealValueInChannel]) : Integer.parseInt(realValue);
        if (value.endsWith("px")) {
            value = StringUtils.substringBeforeLast((String)value, (String)"px");
            int v = Integer.parseInt(value);
            switch (modifier) {
                case EQUALS: {
                    return v == rv;
                }
                case MIN: {
                    return v < rv;
                }
                case MAX: {
                    return v > rv;
                }
            }
        }
        return true;
    }

    public void destroy() {
    }

    private static enum Modifier {
        EQUALS,
        MIN,
        MAX;

    }
}

