/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin.filters;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.jahia.bin.Jahia;
import org.jahia.bin.JahiaControllerUtils;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.sites.JahiaSite;
import org.jahia.services.sites.JahiaSitesService;
import org.jahia.services.templates.JahiaTemplateManagerService;
import org.jahia.services.uicomponents.bean.contentmanager.ManagerConfiguration;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.settings.SettingsBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationListener;

public class ContentManagerAccessCheckFilter
implements Filter,
ApplicationListener<JahiaTemplateManagerService.TemplatePackageRedeployedEvent> {
    private static final Logger logger = LoggerFactory.getLogger(ContentManagerAccessCheckFilter.class);
    private String defaultContentManager = "repositoryexplorer";
    private String defaultContentPicker = "filepicker";
    private Map<String, String> mapping;
    private boolean requireAuthenticatedUser = true;
    private SettingsBean settingsBean;

    protected boolean checkConfig(HttpServletRequest request) {
        String cfg = StringUtils.defaultIfEmpty((String)request.getParameter("conf"), (String)(this.isContentPicker(request) ? this.defaultContentPicker : this.defaultContentManager));
        return this.getMapping().containsKey(cfg);
    }

    protected boolean checkWorkspace(HttpServletRequest request) {
        return JCRContentUtils.isValidWorkspace(request.getParameter("workspace"), true);
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        JCRNodeWrapper site;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (this.requireAuthenticatedUser && JahiaUserManagerService.isGuest(this.getCurrentUser()) || this.settingsBean.isReadOnlyMode()) {
            response.sendError(403);
            return;
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        if (!this.checkWorkspace(request)) {
            response.sendError(404);
            return;
        }
        String cfg = StringUtils.defaultIfEmpty((String)request.getParameter("conf"), (String)(this.isContentPicker(request) ? this.defaultContentPicker : this.defaultContentManager));
        if (!this.getMapping().containsKey(cfg)) {
            response.sendError(404);
            return;
        }
        if (cfg.equals("repositoryexplorer")) {
            try {
                site = JCRSessionFactory.getInstance().getCurrentUserSession().getRootNode();
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
                response.sendError(403);
                return;
            }
        } else if (cfg.equals("categorymanager")) {
            try {
                site = JCRSessionFactory.getInstance().getCurrentUserSession().getNode("/sites/systemsite");
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
                response.sendError(403);
                return;
            }
        } else {
            site = this.getSite(request);
            if (site == null) {
                response.sendError(404);
                return;
            }
        }
        if (this.requireAuthenticatedUser) {
            String permission = this.getMapping().get(cfg);
            if (permission == null && this.isContentPicker(request)) {
                permission = "jcr:read_default";
            }
            if (permission != null && !this.isAllowed(permission, site)) {
                response.sendError(403);
                return;
            }
        }
        chain.doFilter(servletRequest, servletResponse);
    }

    protected JahiaUser getCurrentUser() {
        return JCRSessionFactory.getInstance().getCurrentUser();
    }

    protected Map<String, String> getMapping() {
        if (this.mapping == null) {
            this.mapping = new HashMap<String, String>();
            for (JahiaTemplatesPackage aPackage : ServicesRegistry.getInstance().getJahiaTemplateManagerService().getAvailableTemplatePackages()) {
                if (aPackage.getContext() == null) continue;
                for (Map.Entry cfg : BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)aPackage.getContext(), ManagerConfiguration.class).entrySet()) {
                    this.mapping.put((String)cfg.getKey(), ((ManagerConfiguration)cfg.getValue()).getRequiredPermission());
                }
            }
        }
        return this.mapping;
    }

    protected JCRSiteNode getSite(HttpServletRequest request) {
        String siteId = request.getParameter("site");
        try {
            JCRSessionWrapper currentUserSession = JCRSessionFactory.getInstance().getCurrentUserSession();
            if (StringUtils.isNotEmpty((String)siteId)) {
                return currentUserSession.getNodeByUUID(siteId).getResolveSite();
            }
            JahiaSitesService siteService = JahiaSitesService.getInstance();
            JahiaSite defaultSite = siteService.getDefaultSite();
            if (defaultSite != null) {
                return (JCRSiteNode)currentUserSession.getNodeByUUID(((JCRSiteNode)defaultSite).getIdentifier());
            }
        }
        catch (RepositoryException e) {
            logger.warn("Unble to lookup site for UUID '{}'", (Object)siteId);
        }
        return null;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    protected boolean isAllowed(String permission, JCRNodeWrapper site) {
        boolean allowed = false;
        try {
            allowed = JahiaControllerUtils.hasRequiredPermission(site, this.getCurrentUser(), permission);
        }
        catch (ItemNotFoundException e) {
        }
        catch (RepositoryException e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        return allowed;
    }

    protected boolean isContentPicker(HttpServletRequest request) {
        return request.getRequestURI().equals(Jahia.getContextPath() + "/engines/contentpicker.jsp");
    }

    public void onApplicationEvent(JahiaTemplateManagerService.TemplatePackageRedeployedEvent event) {
        this.mapping = null;
    }

    public void setDefaultContentManager(String defaultContentManager) {
        this.defaultContentManager = defaultContentManager;
    }

    public void setDefaultContentPicker(String defaultContentPicker) {
        this.defaultContentPicker = defaultContentPicker;
    }

    public void setRequireAuthenticatedUser(boolean requireAuthenticatedUser) {
        this.requireAuthenticatedUser = requireAuthenticatedUser;
    }

    public void setSettingsBean(SettingsBean settingsBean) {
        this.settingsBean = settingsBean;
    }
}

