/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin.filters.jcr;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jahia.params.valves.AuthValveContext;
import org.jahia.pipelines.Pipeline;
import org.jahia.pipelines.PipelineException;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrSessionFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(JcrSessionFilter.class);
    private Pipeline authPipeline;
    private JCRSessionFactory sessionFactory;
    private JahiaUserManagerService userManagerService;

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        boolean initialized = SpringContextSingleton.getInstance().isInitialized();
        try {
            AuthValveContext authValveContext = null;
            if (initialized) {
                try {
                    this.sessionFactory.setCurrentUser(null);
                    authValveContext = new AuthValveContext((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse, this.sessionFactory);
                    this.authPipeline.invoke(authValveContext);
                }
                catch (PipelineException pe) {
                    logger.error("Error while authorizing user", (Throwable)pe);
                }
            }
            if (this.sessionFactory.getCurrentUser() != null && this.sessionFactory.getCurrentUser().isAccountLocked()) {
                this.sessionFactory.setCurrentUser(null);
            }
            if (this.sessionFactory.getCurrentUser() == null) {
                this.sessionFactory.setCurrentUser(this.userManagerService.lookupUser("guest"));
            } else {
                HttpSession httpSession = ((HttpServletRequest)servletRequest).getSession();
                if (authValveContext == null || !httpSession.isNew() || !authValveContext.isAuthRetrievedFromSession()) {
                    httpSession.setAttribute("org.jahia.usermanager.jahiauser", (Object)this.sessionFactory.getCurrentUser());
                }
            }
            filterChain.doFilter(servletRequest, servletResponse);
        }
        finally {
            if (initialized) {
                JcrSessionFilter.endRequest();
            }
        }
    }

    public static void endRequest() {
        JCRSessionFactory sessionFactory = JCRSessionFactory.getInstance();
        sessionFactory.setCurrentUser(null);
        sessionFactory.setCurrentLocale(null);
        sessionFactory.setFallbackLocale(null);
        sessionFactory.setCurrentAliasedUser(null);
        sessionFactory.setCurrentServletPath(null);
        sessionFactory.setCurrentPreviewDate(null);
        sessionFactory.closeAllSessions();
        ServicesRegistry.getInstance().getSchedulerService().triggerEndOfRequest();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void setAuthPipeline(Pipeline authPipeline) {
        this.authPipeline = authPipeline;
    }

    public void setSessionFactory(JCRSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void setUserManagerService(JahiaUserManagerService userManagerService) {
        this.userManagerService = userManagerService;
    }
}

