/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin.listeners;

import java.io.File;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import javax.servlet.jsp.jstl.core.Config;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.VFS;
import org.apache.pluto.driver.PortalStartupListener;
import org.codehaus.plexus.util.StringUtils;
import org.jahia.bin.Jahia;
import org.jahia.exceptions.JahiaException;
import org.jahia.exceptions.JahiaInitializationException;
import org.jahia.exceptions.JahiaRuntimeException;
import org.jahia.osgi.FrameworkService;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.JahiaAfterInitializationService;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.applications.ApplicationsManagerServiceImpl;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.usermanager.jcr.JCRUserManagerProvider;
import org.jahia.settings.SettingsBean;
import org.jahia.tools.patches.GroovyPatcher;
import org.jahia.utils.Patterns;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationEvent;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class JahiaContextLoaderListener
extends PortalStartupListener
implements ServletRequestListener,
ServletRequestAttributeListener,
HttpSessionListener,
HttpSessionActivationListener,
HttpSessionAttributeListener,
HttpSessionBindingListener,
ServletContextAttributeListener {
    private static final transient Logger logger = LoggerFactory.getLogger(JahiaContextLoaderListener.class);
    private static Set<String> addedSystemProperties = new HashSet<String>();
    private static ServletContext servletContext;
    private static long startupTime;
    private static long sessionCount;
    private static String pid;
    private static boolean contextInitialized;
    private static boolean running;
    private static Map<String, Object> jahiaContextListenersConfiguration;
    private static Map<ServletRequest, Long> requestTimes;
    private static String webAppRoot;

    public boolean isEventInterceptorActivated(String interceptorName) {
        if (jahiaContextListenersConfiguration == null) {
            return false;
        }
        Object interceptorActivatedObject = jahiaContextListenersConfiguration.get(interceptorName);
        if (interceptorActivatedObject instanceof Boolean) {
            return (Boolean)interceptorActivatedObject;
        }
        if (interceptorActivatedObject instanceof String) {
            return Boolean.parseBoolean((String)interceptorActivatedObject);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextInitialized(ServletContextEvent event) {
        startupTime = System.currentTimeMillis();
        this.startupWithTrust(Jahia.isEnterpriseEdition() ? Jahia.getBuildNumber() + "." + Jahia.getEEBuildNumber() : String.valueOf(Jahia.getBuildNumber()));
        logger.info("Starting up Digital Factory, please wait...");
        servletContext = event.getServletContext();
        Jahia.setContextPath(servletContext.getContextPath());
        this.initWebAppRoot();
        if (System.getProperty("jahia.config") == null) {
            JahiaContextLoaderListener.setSystemProperty("jahia.config", "");
        }
        if (System.getProperty("jahia.license") == null) {
            JahiaContextLoaderListener.setSystemProperty("jahia.license", "");
        }
        try {
            Jahia.verifyJavaVersion(servletContext.getInitParameter("supported_jdk_versions"));
        }
        catch (JahiaInitializationException e) {
            throw new JahiaRuntimeException(e);
        }
        this.detectPID(servletContext);
        GroovyPatcher.executeScripts(servletContext, "beforeContextInitializing");
        try {
            VFS.getManager();
        }
        catch (FileSystemException e) {
            throw new JahiaRuntimeException(e);
        }
        try {
            boolean isProcessingServer;
            long timer = System.currentTimeMillis();
            logger.info("Start initializing Spring root application context");
            running = true;
            super.contextInitialized(event);
            logger.info("Spring Root application context initialized in {} ms", (Object)(System.currentTimeMillis() - timer));
            ServicesRegistry.getInstance().init();
            WebApplicationContext rootCtx = ContextLoader.getCurrentWebApplicationContext();
            rootCtx.publishEvent((ApplicationEvent)new RootContextInitializedEvent(rootCtx));
            if (Jahia.isEnterpriseEdition()) {
                this.requireLicense();
            }
            if (isProcessingServer = SettingsBean.getInstance().isProcessingServer()) {
                GroovyPatcher.executeScripts(servletContext, "rootContextInitialized");
            }
            timer = System.currentTimeMillis();
            logger.info("Starting OSGi platform service");
            new FrameworkService(event.getServletContext());
            FrameworkService.getInstance().start();
            boolean stopWaiting = false;
            FrameworkService frameworkService = FrameworkService.getInstance();
            synchronized (frameworkService) {
                while (!stopWaiting && !FrameworkService.getInstance().isStarted()) {
                    try {
                        FrameworkService.getInstance().wait(600000L);
                        stopWaiting = true;
                        logger.info("Stopped waiting for OSGi framework startup");
                    }
                    catch (InterruptedException e) {}
                }
            }
            logger.info("OSGi platform service initialized in {} ms", (Object)(System.currentTimeMillis() - timer));
            this.initJahiaAfterInitializationServices();
            ApplicationsManagerServiceImpl.getInstance().registerListeners();
            Config.set((ServletContext)servletContext, (String)"javax.servlet.jsp.jstl.fmt.fallbackLocale", (Object)(SettingsBean.getInstance().getDefaultLanguageCode() != null ? SettingsBean.getInstance().getDefaultLanguageCode() : Locale.ENGLISH.getLanguage()));
            jahiaContextListenersConfiguration = (Map)ContextLoader.getCurrentWebApplicationContext().getBean("jahiaContextListenersConfiguration");
            if (this.isEventInterceptorActivated("interceptServletContextListenerEvents")) {
                SpringContextSingleton.getInstance().publishEvent(new ServletContextInitializedEvent(event.getServletContext()));
            }
            contextInitialized = true;
            if (isProcessingServer) {
                GroovyPatcher.executeScripts(servletContext, "contextInitialized");
            } else {
                GroovyPatcher.executeScripts(servletContext, "nonProcessingServer");
            }
        }
        catch (JahiaException e) {
            running = false;
            logger.error(e.getMessage(), (Throwable)e);
            throw new JahiaRuntimeException(e);
        }
        catch (BundleException e) {
            running = false;
            logger.error(e.getMessage(), (Throwable)e);
            throw new JahiaRuntimeException(e);
        }
        catch (RuntimeException e) {
            running = false;
            throw e;
        }
        finally {
            JCRSessionFactory.getInstance().closeAllSessions();
        }
    }

    private void initWebAppRoot() {
        webAppRoot = servletContext.getRealPath("/");
        if (webAppRoot != null && webAppRoot.length() > 1 && webAppRoot.charAt(webAppRoot.length() - 1) == File.separatorChar) {
            webAppRoot = webAppRoot.substring(0, webAppRoot.length() - 1);
        }
        try {
            JahiaContextLoaderListener.setSystemProperty("jahiaWebAppRoot", webAppRoot);
        }
        catch (SecurityException se) {
            logger.error("System property jahiaWebAppRoot was NOT set to " + webAppRoot + " successfully ! Please check app server security manager policies to allow this.", (Throwable)se);
        }
        if (System.getProperty("jahiaWebAppRoot") != null && System.getProperty("jahiaWebAppRoot").equals(webAppRoot)) {
            logger.info("System property jahiaWebAppRoot set to " + webAppRoot + " successfully.");
        } else {
            logger.error("System property jahiaWebAppRoot was NOT set to " + webAppRoot + " successfully ! Please check app server security manager policies to allow this.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initJahiaAfterInitializationServices() throws JahiaInitializationException {
        try {
            JCRSessionFactory.getInstance().setCurrentUser(JCRUserManagerProvider.getInstance().lookupRootUser());
            for (JahiaAfterInitializationService service : SpringContextSingleton.getInstance().getContext().getBeansOfType(JahiaAfterInitializationService.class).values()) {
                service.initAfterAllServicesAreStarted();
            }
            ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackageRegistry().afterInitializationForModules();
        }
        finally {
            JCRSessionFactory.getInstance().setCurrentUser(null);
        }
    }

    public static void initJahiaAfterInitializationServices(ListableBeanFactory beanfactory) throws JahiaInitializationException {
        Map map = beanfactory.getBeansOfType(JahiaAfterInitializationService.class);
        for (JahiaAfterInitializationService service : map.values()) {
            service.initAfterAllServicesAreStarted();
        }
    }

    private void detectPID(ServletContext servletContext) {
        try {
            pid = Patterns.AT.split(ManagementFactory.getRuntimeMXBean().getName())[0];
        }
        catch (Exception e) {
            logger.warn("Unable to determine process id", (Throwable)e);
        }
    }

    private void requireLicense() {
        try {
            if (!ContextLoader.getCurrentWebApplicationContext().getBean("licenseChecker").getClass().getName().equals("org.jahia.security.license.LicenseChecker") || !ContextLoader.getCurrentWebApplicationContext().getBean("LicenseFilter").getClass().getName().equals("org.jahia.security.license.LicenseFilter")) {
                throw new FatalBeanException("Required classes for license manager were not found");
            }
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new FatalBeanException("Required classes for license manager were not found", (Throwable)e);
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        if (!running) {
            return;
        }
        contextInitialized = false;
        running = false;
        if (this.isEventInterceptorActivated("interceptServletContextListenerEvents")) {
            SpringContextSingleton.getInstance().publishEvent(new ServletContextDestroyedEvent(event.getServletContext()));
        }
        long timer = System.currentTimeMillis();
        logger.info("Stopping OSGi platform service");
        try {
            FrameworkService.getInstance().stop();
        }
        catch (Exception e) {
            logger.error("Error stopping OSGi platform service. Cause: " + e.getMessage(), (Throwable)e);
        }
        logger.info("OSGi platform service stopped in {} ms", (Object)(System.currentTimeMillis() - timer));
        timer = System.currentTimeMillis();
        logger.info("Shutting down Spring root application context");
        super.contextDestroyed(event);
        JahiaContextLoaderListener.removeAddedSystemProperties();
        logger.info("Spring Root application context shut down in {} ms", (Object)(System.currentTimeMillis() - timer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startupWithTrust(String buildString) {
        String msg;
        StringBuilder buildBuffer = new StringBuilder();
        for (int i = 0; i < buildString.length(); ++i) {
            buildBuffer.append(" ");
            buildBuffer.append(buildString.substring(i, i + 1));
        }
        StringBuilder versionBuffer = new StringBuilder();
        for (int i = 0; i < "7.0.0.3".length(); ++i) {
            versionBuffer.append(" ");
            versionBuffer.append("7.0.0.3".substring(i, i + 1));
        }
        StringBuilder codeNameBuffer = new StringBuilder();
        for (int i = 0; i < "Elektra".length(); ++i) {
            codeNameBuffer.append(" ");
            codeNameBuffer.append("Elektra".substring(i, i + 1));
        }
        InputStream is = null;
        try {
            is = ((Object)((Object)this)).getClass().getResourceAsStream(Jahia.isEnterpriseEdition() ? "/META-INF/jahia-ee-startup-intro.txt" : "/META-INF/jahia-startup-intro.txt");
            msg = IOUtils.toString((InputStream)is);
        }
        catch (Exception e) {
            try {
                logger.warn(e.getMessage(), (Throwable)e);
                msg = "";
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)is);
        }
        IOUtils.closeQuietly((InputStream)is);
        msg = StringUtils.replace((String)msg, (String)"@BUILD_NUMBER@", (String)buildBuffer.toString());
        msg = StringUtils.replace((String)msg, (String)"@BUILD_DATE@", (String)Jahia.getBuildDate());
        msg = StringUtils.replace((String)msg, (String)"@VERSION@", (String)versionBuffer.toString());
        msg = StringUtils.replace((String)msg, (String)"@CODENAME@", (String)codeNameBuffer.toString());
        System.out.println(msg);
        System.out.flush();
    }

    public static ServletContext getServletContext() {
        return servletContext;
    }

    public static long getStartupTime() {
        return startupTime;
    }

    public void sessionCreated(HttpSessionEvent se) {
        ++sessionCount;
        if (this.isEventInterceptorActivated("interceptHttpSessionListenerEvents")) {
            SpringContextSingleton.getInstance().publishEvent(new HttpSessionCreatedEvent(se.getSession()));
        }
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        --sessionCount;
        if (this.isEventInterceptorActivated("interceptHttpSessionListenerEvents")) {
            SpringContextSingleton.getInstance().publishEvent(new HttpSessionDestroyedEvent(se.getSession()));
        }
    }

    public void requestDestroyed(ServletRequestEvent sre) {
        requestTimes.remove(sre.getServletRequest());
        if (this.isEventInterceptorActivated("interceptServletRequestListenerEvents")) {
            SpringContextSingleton.getInstance().publishEvent(new ServletRequestDestroyedEvent(sre.getServletRequest()));
        }
    }

    public void requestInitialized(ServletRequestEvent sre) {
        requestTimes.put(sre.getServletRequest(), System.currentTimeMillis());
        if (this.isEventInterceptorActivated("interceptServletRequestListenerEvents")) {
            SpringContextSingleton.getInstance().publishEvent(new ServletRequestInitializedEvent(sre.getServletRequest()));
        }
    }

    public static long getSessionCount() {
        return sessionCount;
    }

    public static long getRequestCount() {
        return requestTimes.size();
    }

    public static String getPid() {
        return pid;
    }

    public static void setSystemProperty(String key, String value) {
        if (System.setProperty(key, value) == null) {
            addedSystemProperties.add(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeAddedSystemProperties() {
        try {
            for (String key : addedSystemProperties) {
                System.clearProperty(key);
            }
        }
        finally {
            addedSystemProperties.clear();
        }
    }

    public void sessionWillPassivate(HttpSessionEvent se) {
        if (this.isEventInterceptorActivated("interceptHttpSessionActivationEvents")) {
            SpringContextSingleton.getInstance().publishEvent(new HttpSessionWillPassivateEvent(se.getSession()));
        }
    }

    public void sessionDidActivate(HttpSessionEvent se) {
        if (this.isEventInterceptorActivated("interceptHttpSessionActivationEvents")) {
            SpringContextSingleton.getInstance().publishEvent(new HttpSessionDidActivateEvent(se.getSession()));
        }
    }

    public void attributeAdded(HttpSessionBindingEvent se) {
        if (this.isEventInterceptorActivated("interceptHttpSessionAttributeListenerEvents")) {
            SpringContextSingleton.getInstance().publishEvent(new HttpSessionAttributeAddedEvent(se));
        }
    }

    public void attributeRemoved(HttpSessionBindingEvent se) {
        if (this.isEventInterceptorActivated("interceptHttpSessionAttributeListenerEvents")) {
            SpringContextSingleton.getInstance().publishEvent(new HttpSessionAttributeRemovedEvent(se));
        }
    }

    public void attributeReplaced(HttpSessionBindingEvent se) {
        if (this.isEventInterceptorActivated("interceptHttpSessionAttributeListenerEvents")) {
            SpringContextSingleton.getInstance().publishEvent(new HttpSessionAttributeReplacedEvent(se));
        }
    }

    public void valueBound(HttpSessionBindingEvent event) {
        if (this.isEventInterceptorActivated("interceptHttpSessionBindingListenerEvents")) {
            SpringContextSingleton.getInstance().publishEvent(new HttpSessionValueBoundEvent(event));
        }
    }

    public void valueUnbound(HttpSessionBindingEvent event) {
        if (this.isEventInterceptorActivated("interceptHttpSessionBindingListenerEvents")) {
            SpringContextSingleton.getInstance().publishEvent(new HttpSessionValueUnboundEvent(event));
        }
    }

    public void attributeAdded(ServletContextAttributeEvent scab) {
        if (contextInitialized && this.isEventInterceptorActivated("interceptServletContextAttributeListenerEvents")) {
            SpringContextSingleton.getInstance().publishEvent(new ServletContextAttributeAddedEvent(scab));
        }
    }

    public void attributeRemoved(ServletContextAttributeEvent scab) {
        if (contextInitialized && this.isEventInterceptorActivated("interceptServletContextAttributeListenerEvents")) {
            SpringContextSingleton.getInstance().publishEvent(new ServletContextAttributeRemovedEvent(scab));
        }
    }

    public void attributeReplaced(ServletContextAttributeEvent scab) {
        if (contextInitialized && this.isEventInterceptorActivated("interceptServletContextAttributeListenerEvents")) {
            SpringContextSingleton.getInstance().publishEvent(new ServletContextAttributeReplacedEvent(scab));
        }
    }

    public void attributeAdded(ServletRequestAttributeEvent srae) {
        if (this.isEventInterceptorActivated("interceptServletRequestAttributeListenerEvents")) {
            SpringContextSingleton.getInstance().publishEvent(new ServletRequestAttributeAddedEvent(srae));
        }
    }

    public void attributeRemoved(ServletRequestAttributeEvent srae) {
        if (this.isEventInterceptorActivated("interceptServletRequestAttributeListenerEvents")) {
            SpringContextSingleton.getInstance().publishEvent(new ServletRequestAttributeRemovedEvent(srae));
        }
    }

    public void attributeReplaced(ServletRequestAttributeEvent srae) {
        if (this.isEventInterceptorActivated("interceptServletRequestAttributeListenerEvents")) {
            SpringContextSingleton.getInstance().publishEvent(new ServletRequestAttributeReplacedEvent(srae));
        }
    }

    public static boolean isContextInitialized() {
        return contextInitialized;
    }

    public static boolean isRunning() {
        return running;
    }

    public static String getWebAppRoot() {
        return webAppRoot;
    }

    static {
        sessionCount = 0L;
        pid = "";
        contextInitialized = false;
        requestTimes = Collections.synchronizedMap(new LRUMap(1000));
    }

    private class ServletContextDestroyedEvent
    extends ApplicationEvent {
        private static final long serialVersionUID = -2099082546094025673L;

        public ServletContextDestroyedEvent(ServletContext servletContext) {
            super((Object)servletContext);
        }
    }

    public class ServletContextInitializedEvent
    extends ApplicationEvent {
        private static final long serialVersionUID = 7380625349896182566L;

        public ServletContextInitializedEvent(ServletContext servletContext) {
            super((Object)servletContext);
        }

        public ServletContext getServletContext() {
            return (ServletContext)super.getSource();
        }
    }

    private class ServletRequestAttributeReplacedEvent
    extends ApplicationEvent {
        private static final long serialVersionUID = 1785714293103597626L;

        public ServletRequestAttributeReplacedEvent(ServletRequestAttributeEvent servletRequestAttributeEvent) {
            super((Object)servletRequestAttributeEvent);
        }
    }

    private class ServletRequestAttributeRemovedEvent
    extends ApplicationEvent {
        private static final long serialVersionUID = 4181992489489417634L;

        public ServletRequestAttributeRemovedEvent(ServletRequestAttributeEvent servletRequestAttributeEvent) {
            super((Object)servletRequestAttributeEvent);
        }
    }

    public class ServletRequestAttributeAddedEvent
    extends ApplicationEvent {
        private static final long serialVersionUID = 3317475270634384739L;

        public ServletRequestAttributeAddedEvent(ServletRequestAttributeEvent servletRequestAttributeEvent) {
            super((Object)servletRequestAttributeEvent);
        }

        public ServletRequestAttributeEvent getServletRequestAttributeEvent() {
            return (ServletRequestAttributeEvent)super.getSource();
        }
    }

    public class ServletContextAttributeReplacedEvent
    extends ApplicationEvent {
        private static final long serialVersionUID = 5729697513603811739L;

        public ServletContextAttributeReplacedEvent(ServletContextAttributeEvent servletContextAttributeEvent) {
            super((Object)servletContextAttributeEvent);
        }

        public ServletContextAttributeEvent getServletContextAttributeEvent() {
            return (ServletContextAttributeEvent)super.getSource();
        }
    }

    public class ServletContextAttributeRemovedEvent
    extends ApplicationEvent {
        private static final long serialVersionUID = -3543715780914938235L;

        public ServletContextAttributeRemovedEvent(ServletContextAttributeEvent servletContextAttributeEvent) {
            super((Object)servletContextAttributeEvent);
        }

        public ServletContextAttributeEvent getServletContextAttributeEvent() {
            return (ServletContextAttributeEvent)super.getSource();
        }
    }

    public class ServletContextAttributeAddedEvent
    extends ApplicationEvent {
        private static final long serialVersionUID = 3430737803878399224L;

        public ServletContextAttributeAddedEvent(ServletContextAttributeEvent servletContextAttributeEvent) {
            super((Object)servletContextAttributeEvent);
        }

        public ServletContextAttributeEvent getServletContextAttributeEvent() {
            return (ServletContextAttributeEvent)super.getSource();
        }
    }

    public class HttpSessionValueUnboundEvent
    extends ApplicationEvent {
        private static final long serialVersionUID = 8453994121930169941L;

        public HttpSessionValueUnboundEvent(HttpSessionBindingEvent httpSessionBindingEvent) {
            super((Object)httpSessionBindingEvent);
        }

        public HttpSessionBindingEvent getHttpSessionBindingEvent() {
            return (HttpSessionBindingEvent)super.getSource();
        }
    }

    public class HttpSessionValueBoundEvent
    extends ApplicationEvent {
        private static final long serialVersionUID = -3415824235349946403L;

        public HttpSessionValueBoundEvent(HttpSessionBindingEvent httpSessionBindingEvent) {
            super((Object)httpSessionBindingEvent);
        }

        public HttpSessionBindingEvent getHttpSessionBindingEvent() {
            return (HttpSessionBindingEvent)super.getSource();
        }
    }

    public class HttpSessionAttributeReplacedEvent
    extends ApplicationEvent {
        private static final long serialVersionUID = 8128290080471455221L;

        public HttpSessionAttributeReplacedEvent(HttpSessionBindingEvent httpSessionBindingEvent) {
            super((Object)httpSessionBindingEvent);
        }

        public HttpSessionBindingEvent getHttpSessionBindingEvent() {
            return (HttpSessionBindingEvent)super.getSource();
        }
    }

    public class HttpSessionAttributeRemovedEvent
    extends ApplicationEvent {
        private static final long serialVersionUID = 876708448117102271L;

        public HttpSessionAttributeRemovedEvent(HttpSessionBindingEvent httpSessionBindingEvent) {
            super((Object)httpSessionBindingEvent);
        }

        public HttpSessionBindingEvent getHttpSessionBindingEvent() {
            return (HttpSessionBindingEvent)super.getSource();
        }
    }

    public class HttpSessionAttributeAddedEvent
    extends ApplicationEvent {
        private static final long serialVersionUID = 7316259699549761735L;

        public HttpSessionAttributeAddedEvent(HttpSessionBindingEvent httpSessionBindingEvent) {
            super((Object)httpSessionBindingEvent);
        }

        public HttpSessionBindingEvent getHttpSessionBindingEvent() {
            return (HttpSessionBindingEvent)super.getSource();
        }
    }

    public class HttpSessionDidActivateEvent
    extends ApplicationEvent {
        private static final long serialVersionUID = 5814761122135408014L;

        public HttpSessionDidActivateEvent(HttpSession session) {
            super((Object)session);
        }

        public HttpSession getSession() {
            return (HttpSession)super.getSource();
        }
    }

    public class HttpSessionWillPassivateEvent
    extends ApplicationEvent {
        private static final long serialVersionUID = 6886011344567163295L;

        public HttpSessionWillPassivateEvent(HttpSession session) {
            super((Object)session);
        }

        public HttpSession getSession() {
            return (HttpSession)super.getSource();
        }
    }

    public class ServletRequestInitializedEvent
    extends ApplicationEvent {
        private static final long serialVersionUID = 5822992792782543993L;

        public ServletRequestInitializedEvent(ServletRequest servletRequest) {
            super((Object)servletRequest);
        }

        public ServletRequest getServletRequest() {
            return (ServletRequest)super.getSource();
        }
    }

    public class ServletRequestDestroyedEvent
    extends ApplicationEvent {
        private static final long serialVersionUID = 7596456549896361175L;

        public ServletRequestDestroyedEvent(ServletRequest servletRequest) {
            super((Object)servletRequest);
        }

        public ServletRequest getServletRequest() {
            return (ServletRequest)super.getSource();
        }
    }

    public class HttpSessionDestroyedEvent
    extends ApplicationEvent {
        private static final long serialVersionUID = -1387944667725619591L;

        public HttpSessionDestroyedEvent(HttpSession session) {
            super((Object)session);
        }

        public HttpSession getSession() {
            return (HttpSession)super.getSource();
        }
    }

    public class HttpSessionCreatedEvent
    extends ApplicationEvent {
        private static final long serialVersionUID = -7421486835176013728L;

        public HttpSessionCreatedEvent(HttpSession session) {
            super((Object)session);
        }

        public HttpSession getSession() {
            return (HttpSession)super.getSource();
        }
    }

    public static class RootContextInitializedEvent
    extends ApplicationEvent {
        private static final long serialVersionUID = 8215602249732419470L;

        public RootContextInitializedEvent(Object source) {
            super(source);
        }

        public XmlWebApplicationContext getContext() {
            return (XmlWebApplicationContext)this.getSource();
        }
    }
}

