/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.content;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jahia.content.ObjectKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JahiaObject
implements Serializable {
    private static final long serialVersionUID = -2624062108412420112L;
    private static Logger logger = LoggerFactory.getLogger(JahiaObject.class);
    private static Map<String, String> keyTypeClassNames = new ConcurrentHashMap<String, String>();
    protected ObjectKey objectKey;
    private static Map<String, Method> methodsMap = new ConcurrentHashMap<String, Method>(32);

    public JahiaObject(ObjectKey objectKey) {
        this.objectKey = objectKey;
    }

    protected JahiaObject() {
    }

    public static void registerType(String type, String className) {
        logger.debug("Registering type [" + type + "] with class name [" + className + "]");
        keyTypeClassNames.put(type, className);
    }

    public static void unregisterType(String type) {
        keyTypeClassNames.remove(type);
    }

    public static JahiaObject getInstance(ObjectKey objectKey) throws ClassNotFoundException {
        return (JahiaObject)JahiaObject.getInstanceAsObject(objectKey, false);
    }

    public static JahiaObject getInstance(ObjectKey objectKey, boolean forceLoadFromDB) throws ClassNotFoundException {
        return (JahiaObject)JahiaObject.getInstanceAsObject(objectKey, forceLoadFromDB);
    }

    public static Object getInstanceAsObject(ObjectKey objectKey) throws ClassNotFoundException {
        return JahiaObject.getInstanceAsObject(objectKey, false);
    }

    public static Object getInstanceAsObject(ObjectKey objectKey, boolean forceLoadFromDB) throws ClassNotFoundException {
        Object resultObject = null;
        if (objectKey == null) {
            return null;
        }
        String type = objectKey.getType();
        String idStr = objectKey.getIDInType();
        if (!keyTypeClassNames.containsKey(type)) {
            throw new ClassNotFoundException("No class defined for type [" + type + "]");
        }
        try {
            Method childClassMethod;
            String className = keyTypeClassNames.get(type);
            Object[] args = new Object[forceLoadFromDB ? 2 : 1];
            args[0] = idStr;
            if (forceLoadFromDB) {
                args[1] = forceLoadFromDB;
            }
            if (!methodsMap.containsKey(className + forceLoadFromDB)) {
                Class<JahiaObject> childClass = Class.forName(className).asSubclass(JahiaObject.class);
                Class[] childClassParameters = new Class[forceLoadFromDB ? 2 : 1];
                childClassParameters[0] = String.class;
                if (forceLoadFromDB) {
                    childClassParameters[1] = Boolean.TYPE;
                }
                childClassMethod = childClass.getMethod("getChildInstance", childClassParameters);
                methodsMap.put(className + forceLoadFromDB, childClassMethod);
            } else {
                childClassMethod = methodsMap.get(className + forceLoadFromDB);
            }
            resultObject = childClassMethod.invoke(null, args);
        }
        catch (ClassNotFoundException cnfe) {
            logger.error("Error while creating instance of object " + objectKey, (Throwable)cnfe);
        }
        catch (NoSuchMethodException nsme) {
            logger.error("Error while creating instance of object " + objectKey, (Throwable)nsme);
        }
        catch (SecurityException se) {
            logger.error("Error while creating instance of object " + objectKey, (Throwable)se);
        }
        catch (IllegalAccessException iae) {
            logger.error("Error while creating instance of object " + objectKey, (Throwable)iae);
        }
        catch (IllegalArgumentException iae2) {
            logger.error("Error while creating instance of object " + objectKey, (Throwable)iae2);
        }
        catch (InvocationTargetException ite) {
            logger.error("Error while creating instance of object " + objectKey, (Throwable)ite);
            logger.error("Error while creating instance of object " + objectKey + ", target exception=", ite.getTargetException());
        }
        return resultObject;
    }

    public ObjectKey getObjectKey() {
        return this.objectKey;
    }
}

