/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.data.templates;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jahia.bin.Jahia;
import org.jahia.data.templates.ModuleState;
import org.jahia.osgi.BundleResource;
import org.jahia.osgi.BundleUtils;
import org.jahia.services.templates.ModuleVersion;
import org.jahia.services.templates.SourceControlManagement;
import org.jahia.settings.SettingsBean;
import org.osgi.framework.Bundle;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.io.Resource;

public class JahiaTemplatesPackage {
    private static final Resource[] NO_RESOURCES = new Resource[0];
    private static final String GIT_URI_END = ".git";
    private Bundle bundle = null;
    private ModuleState state;
    private ClassLoader classLoader;
    private ClassLoader chainedClassLoader;
    private String m_FilePath;
    private String m_Name;
    private ModuleVersion version;
    private List<String> depends = new LinkedList<String>();
    private String id;
    private String groupId;
    private List<String> initialImports = new LinkedList<String>();
    private String m_Provider;
    private String m_Thumbnail;
    private String description;
    private LinkedHashMap<String, JahiaTemplatesPackage> dependencies;
    private int modulePriority = 0;
    private String moduleType;
    private String rootFolderPath;
    private String resourceBundleName;
    private List<String> definitionsFile = new LinkedList<String>();
    private List<String> rulesFiles = new LinkedList<String>();
    private List<String> resourceBundleHierarchy = new LinkedList<String>();
    private List<String> rulesDescriptorFiles = new LinkedList<String>();
    @Deprecated
    private long buildNumber;
    private String autoDeployOnSite;
    private AbstractApplicationContext context;
    private String scmURI;
    private File sourcesFolder;
    private SourceControlManagement sourceControl;
    private boolean isActiveVersion = false;
    private boolean isLastVersion = false;
    private boolean serviceInitialized;
    private boolean sourcesDownloadable;
    private String forgeUrl;
    private boolean editModeBlocked;

    public JahiaTemplatesPackage(Bundle bundle) {
        this.bundle = bundle;
        this.resetDependencies();
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public ModuleState getState() {
        return this.state;
    }

    public void setState(ModuleState state) {
        this.state = state;
    }

    public String getName() {
        return this.m_Name;
    }

    public void setName(String name) {
        this.m_Name = name;
    }

    public String getRootFolder() {
        return this.getId();
    }

    public String getId() {
        return this.id;
    }

    public String getRootFolderWithVersion() {
        return this.getIdWithVersion();
    }

    public String getIdWithVersion() {
        return this.id + "/" + this.version.toString();
    }

    public void setRootFolder(String moduleId) {
        this.setId(moduleId);
    }

    public void setId(String moduleId) {
        if (StringUtils.isNotEmpty((String)moduleId)) {
            this.id = moduleId;
            SettingsBean conf = SettingsBean.getInstance();
            this.rootFolderPath = conf.getTemplatesContext() + (conf.getTemplatesContext().endsWith("/") ? "" : "/") + moduleId;
        } else {
            this.id = "";
            this.rootFolderPath = SettingsBean.getInstance().getTemplatesContext();
        }
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getProvider() {
        return this.m_Provider;
    }

    public void setProvider(String provider) {
        this.m_Provider = provider;
    }

    public String getThumbnail() {
        return this.m_Thumbnail;
    }

    public void setThumbnail(String val) {
        this.m_Thumbnail = val;
    }

    public String getFilePath() {
        return this.m_FilePath;
    }

    public void setFilePath(String path) {
        this.m_FilePath = path;
    }

    public boolean isDefault() {
        return this.getId() != null && "default".equals(this.getId());
    }

    public List<String> getInitialImports() {
        return this.initialImports;
    }

    public void addInitialImport(String initImport) {
        this.initialImports.add(initImport);
    }

    public List<String> getDepends() {
        return this.depends;
    }

    public void setDepends(String dep) {
        this.depends.add(dep);
    }

    public String toString() {
        return this.getId();
    }

    public String getRootFolderPath() {
        return this.rootFolderPath;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    public void setResourceBundleName(String resourceBundleName) {
        this.resourceBundleName = resourceBundleName;
    }

    public List<String> getDefinitionsFiles() {
        return this.definitionsFile;
    }

    public void setDefinitionsFile(String definitionFile) {
        this.definitionsFile.add(definitionFile);
    }

    public List<String> getRulesFiles() {
        return this.rulesFiles;
    }

    public void setRulesFile(String rulesFile) {
        this.rulesFiles.add(rulesFile);
    }

    public List<String> getResourceBundleHierarchy() {
        return this.resourceBundleHierarchy;
    }

    public void clearHierarchy() {
        this.getResourceBundleHierarchy().clear();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JahiaTemplatesPackage that = (JahiaTemplatesPackage)o;
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(that.version) : that.version != null);
    }

    public int hashCode() {
        int result = this.version != null ? this.version.hashCode() : 0;
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        return result;
    }

    public List<String> getRulesDescriptorFiles() {
        return this.rulesDescriptorFiles;
    }

    public void setRulesDescriptorFile(String rulesDescriptorFiles) {
        this.rulesDescriptorFiles.add(rulesDescriptorFiles);
    }

    public List<JahiaTemplatesPackage> getDependencies() {
        return new ArrayList<JahiaTemplatesPackage>(this.dependencies.values());
    }

    public void addDependency(JahiaTemplatesPackage dep) {
        if (dep != null) {
            this.dependencies.put(dep.getId(), dep);
        }
    }

    public void resetDependencies() {
        this.dependencies = new LinkedHashMap();
    }

    @Deprecated
    public long getBuildNumber() {
        return this.buildNumber;
    }

    @Deprecated
    public void setBuildNumber(long buildNumber) {
        this.buildNumber = buildNumber;
    }

    public ModuleVersion getVersion() {
        return this.version;
    }

    public void setVersion(ModuleVersion version) {
        this.version = version;
    }

    public int getModulePriority() {
        return this.modulePriority;
    }

    public void setModulePriority(int modulePriority) {
        this.modulePriority = modulePriority;
    }

    public String getModuleType() {
        return this.moduleType;
    }

    public void setModuleType(String moduleType) {
        this.moduleType = moduleType;
    }

    public void setAutoDeployOnSite(String autoDeployOnSite) {
        this.autoDeployOnSite = autoDeployOnSite;
    }

    public String getAutoDeployOnSite() {
        return this.autoDeployOnSite;
    }

    public AbstractApplicationContext getContext() {
        return this.context;
    }

    public void setContext(AbstractApplicationContext context) {
        this.context = context;
        this.serviceInitialized = false;
    }

    public boolean isActiveVersion() {
        return this.isActiveVersion;
    }

    public void setActiveVersion(boolean activeVersion) {
        this.isActiveVersion = activeVersion;
    }

    public boolean isLastVersion() {
        return this.isLastVersion;
    }

    public void setLastVersion(boolean lastVersion) {
        this.isLastVersion = lastVersion;
    }

    public String getScmURI() {
        return this.scmURI;
    }

    public void setScmURI(String scmURI) {
        int index;
        if (scmURI != null && (index = scmURI.lastIndexOf(GIT_URI_END)) > -1) {
            scmURI = scmURI.substring(0, index + GIT_URI_END.length());
        }
        this.scmURI = scmURI;
    }

    public File getSourcesFolder() {
        return this.sourcesFolder;
    }

    public void setSourcesFolder(File sourcesFolder) {
        this.sourcesFolder = sourcesFolder;
    }

    public SourceControlManagement getSourceControl() {
        return this.sourceControl;
    }

    public void setSourceControl(SourceControlManagement sourceControl) throws IOException {
        this.sourceControl = sourceControl;
        if (sourceControl != null) {
            this.scmURI = sourceControl.getURI();
        }
    }

    public Resource getResource(String relativePath) {
        if (relativePath == null) {
            return null;
        }
        URL entryURL = this.bundle.getEntry(relativePath);
        if (entryURL != null) {
            return new BundleResource(entryURL, this.bundle);
        }
        return null;
    }

    public boolean resourceExists(String relativePath) {
        if (relativePath == null) {
            return false;
        }
        return this.bundle.getEntry(relativePath) != null;
    }

    public Resource[] getResources(String relativePath) {
        Enumeration resourceEnum = this.bundle.findEntries(relativePath, null, false);
        ArrayList<BundleResource> resources = new ArrayList<BundleResource>();
        if (resourceEnum == null) {
            return NO_RESOURCES;
        }
        while (resourceEnum.hasMoreElements()) {
            resources.add(new BundleResource((URL)resourceEnum.nextElement(), this.bundle));
        }
        return resources.toArray(new Resource[resources.size()]);
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader == null && this.bundle != null && this.state != null && this.state.getState() != null && this.state.getState() != ModuleState.State.STOPPING && this.state.getState() != ModuleState.State.STOPPED) {
            this.classLoader = BundleUtils.createBundleClassLoader(this.bundle);
        }
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader getChainedClassLoader() {
        if (this.chainedClassLoader != null) {
            return this.chainedClassLoader;
        }
        final ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>();
        classLoaders.add(Jahia.class.getClassLoader());
        if (this.getClassLoader() != null) {
            classLoaders.add(this.getClassLoader());
        }
        for (JahiaTemplatesPackage dependentPack : this.getDependencies()) {
            if (dependentPack == null || dependentPack.getClassLoader() == null) continue;
            classLoaders.add(dependentPack.getClassLoader());
        }
        this.chainedClassLoader = new ClassLoader(){

            @Override
            public URL getResource(String name) {
                URL url = null;
                for (ClassLoader loader : classLoaders) {
                    url = loader.getResource(name);
                    if (url == null) continue;
                    return url;
                }
                return url;
            }

            @Override
            protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                for (ClassLoader loader : classLoaders) {
                    try {
                        return loader.loadClass(name);
                    }
                    catch (ClassNotFoundException e) {
                    }
                }
                throw new ClassNotFoundException(name);
            }
        };
        return this.chainedClassLoader;
    }

    public void setRootFolderPath(String rootFolderPath) {
        this.rootFolderPath = rootFolderPath;
    }

    public boolean isServiceInitialized() {
        return this.serviceInitialized;
    }

    public void setServiceInitialized(boolean serviceInitialized) {
        this.serviceInitialized = serviceInitialized;
    }

    public void setSourcesDownloadable(boolean sourcesDownloadable) {
        this.sourcesDownloadable = sourcesDownloadable;
    }

    public boolean isSourcesDownloadable() {
        return this.sourcesDownloadable;
    }

    public String getForgeUrl() {
        return this.forgeUrl;
    }

    public void setForgeUrl(String forgeUrl) {
        this.forgeUrl = forgeUrl;
    }

    public boolean isEditModeBlocked() {
        return this.editModeBlocked;
    }

    public void setEditModeBlocked(boolean editModeBlocked) {
        this.editModeBlocked = editModeBlocked;
    }
}

