/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.data.viewhelper.principal;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.servlet.ServletRequest;
import org.apache.commons.collections.iterators.EnumerationIterator;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.jahia.exceptions.JahiaException;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.sites.JahiaSite;
import org.jahia.services.usermanager.GuestGroup;
import org.jahia.services.usermanager.JahiaGroup;
import org.jahia.services.usermanager.JahiaGroupManagerService;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.services.usermanager.UsersGroup;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrincipalViewHelper
implements Serializable {
    private static final long serialVersionUID = -3791113369394869324L;
    public static final String PRINCIPAL = "Principal";
    public static final String PERMISSIONS = "Permissions";
    public static final String PROVIDER = "Provider";
    public static final String SITEID = "SiteID";
    public static final String SITEKEY = "SiteKey";
    public static final String SITETITLE = "SiteTitle";
    public static final String NAME = "Name";
    public static final String PROPERTIES = "Properties";
    public static final String INHERITANCE = "Inheritance";
    private static final transient Logger logger = LoggerFactory.getLogger(PrincipalViewHelper.class);
    private static final transient Comparator<Principal> PRINCIPAL_COMPARATOR = new PrincipalComparator();
    private Map<Principal, Integer[]> perms;
    private Set<Principal> inheritance;
    private static Set<String> selectBoxFieldsHeading = new HashSet<String>();
    private List<Integer> selectBoxFieldsSize = new ArrayList<Integer>();
    private List<Method> selectBoxFieldsMethod = new ArrayList<Method>();

    public PrincipalViewHelper(String[] textFormat) {
        for (int i = 0; i < textFormat.length; ++i) {
            StringTokenizer st = new StringTokenizer(textFormat[i], ",");
            String fieldToDisplay = (String)st.nextElement();
            if (!selectBoxFieldsHeading.contains(fieldToDisplay)) continue;
            if (st.hasMoreElements()) {
                this.selectBoxFieldsSize.add(Integer.valueOf(((String)st.nextElement()).trim()));
            } else {
                this.selectBoxFieldsSize.add(new Integer(-1));
            }
            try {
                this.selectBoxFieldsMethod.add(PrincipalViewHelper.class.getMethod("get" + fieldToDisplay, Principal.class, Integer.class));
                continue;
            }
            catch (NoSuchMethodException nsme) {
                logger.error("Internal class error ! Please check Jahia code", (Throwable)nsme);
            }
        }
    }

    public String getPrincipalTextOption(Principal p) {
        StringBuilder authUserText = new StringBuilder();
        for (int i = 0; i < this.selectBoxFieldsMethod.size(); ++i) {
            Method m = this.selectBoxFieldsMethod.get(i);
            Integer size = this.selectBoxFieldsSize.get(i);
            Object[] args = new Object[]{p, size};
            try {
                authUserText.append(StringEscapeUtils.escapeXml((String)((String)m.invoke((Object)this, args))));
                if (i < this.selectBoxFieldsMethod.size() - 1) {
                    authUserText.append("|");
                }
            }
            catch (InvocationTargetException ite) {
                logger.error("Internal class error !", (Throwable)ite);
            }
            catch (IllegalAccessException iae) {
                logger.error("Internal class error !", (Throwable)iae);
            }
            if (i + 1 >= selectBoxFieldsHeading.size()) continue;
            authUserText.append(" ");
        }
        return StringUtils.replace((String)authUserText.toString(), (String)" ", (String)"&nbsp;");
    }

    public String getPrincipalValueOption(Principal p) {
        StringBuilder buff = new StringBuilder();
        if (p == null) {
            return "null";
        }
        if (p instanceof JahiaUser) {
            return buff.append("u").append(((JahiaUser)p).getUserKey()).toString();
        }
        return buff.append("g").append(((JahiaGroup)p).getGroupKey()).toString();
    }

    public static String getFullName(Principal p) {
        if (p instanceof JahiaGroup) {
            return PrincipalViewHelper.getDisplayName(p);
        }
        if (p instanceof JahiaUser) {
            JahiaUser jahiaUser = (JahiaUser)p;
            StringBuilder fullName = new StringBuilder();
            String value = jahiaUser.getProperty("j:firstName");
            if (StringUtils.isNotEmpty((String)value)) {
                fullName.append(value);
            }
            if (StringUtils.isNotEmpty((String)(value = jahiaUser.getProperty("j:lastName")))) {
                if (fullName.length() > 0) {
                    fullName.append(" ");
                }
                fullName.append(value);
            }
            return fullName.length() == 0 ? PrincipalViewHelper.getDisplayName(jahiaUser) : fullName.toString();
        }
        return p.getName();
    }

    public static String getDisplayName(Principal p) {
        return PrincipalViewHelper.getDisplayName(p, null);
    }

    public static String getDisplayName(Principal p, Locale locale) {
        if (p instanceof JahiaUser) {
            JahiaUser jahiaUser = (JahiaUser)p;
            String userName = jahiaUser.getUsername();
            userName = PrincipalViewHelper.getUserDisplayName(userName, locale);
            return userName;
        }
        if (p instanceof JahiaGroup) {
            JahiaGroup jahiaGroup = (JahiaGroup)p;
            String groupName = jahiaGroup.getGroupname();
            groupName = PrincipalViewHelper.getGroupDisplayName(groupName, locale);
            return groupName;
        }
        return p.getName();
    }

    public static String getGroupDisplayName(String groupName) {
        return PrincipalViewHelper.getGroupDisplayName(groupName, null);
    }

    public static String getGroupDisplayName(String groupName, Locale locale) {
        if ("guest".equals(groupName)) {
            groupName = Messages.get(ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackage(SettingsBean.getInstance().getGuestGroupResourceModuleName()), SettingsBean.getInstance().getGuestGroupResourceKey(), locale != null ? locale : PrincipalViewHelper.getLocale(), groupName);
        }
        return groupName;
    }

    public static String getUserDisplayName(String userName) {
        return PrincipalViewHelper.getUserDisplayName(userName, null);
    }

    public static String getUserDisplayName(String userName, Locale locale) {
        if ("guest".equals(userName)) {
            userName = Messages.get(ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackage(SettingsBean.getInstance().getGuestUserResourceModuleName()), SettingsBean.getInstance().getGuestUserResourceKey(), locale != null ? locale : PrincipalViewHelper.getLocale(), userName);
        }
        return userName;
    }

    public static String getName(Principal p, Integer size) {
        String displayName = PrincipalViewHelper.getDisplayName(p);
        return PrincipalViewHelper.adjustStringSize(displayName, size);
    }

    public static String getProvider(Principal p, Integer size) {
        if (p instanceof JahiaUser) {
            return PrincipalViewHelper.adjustStringSize(((JahiaUser)p).getProviderName(), size);
        }
        return PrincipalViewHelper.adjustStringSize(((JahiaGroup)p).getProviderName(), size);
    }

    public static String getSiteID(Principal p, Integer size) {
        if (p instanceof JahiaUser) {
            return StringUtils.repeat((String)" ", (int)size);
        }
        return PrincipalViewHelper.adjustStringSize(Integer.toString(((JahiaGroup)p).getSiteID()), size);
    }

    public static String getSiteKey(Principal p, Integer size) {
        int siteID = -1;
        siteID = p instanceof JahiaUser ? 0 : ((JahiaGroup)p).getSiteID();
        if (siteID == 0) {
            return PrincipalViewHelper.adjustStringSize("server", size);
        }
        if (siteID > 0) {
            try {
                JahiaSite jahiaSite = ServicesRegistry.getInstance().getJahiaSitesService().getSite(siteID);
                return PrincipalViewHelper.adjustStringSize(jahiaSite.getSiteKey(), size);
            }
            catch (JahiaException je) {
                logger.error("Error while retrieving site id=" + siteID, (Throwable)je);
            }
        }
        return PrincipalViewHelper.adjustStringSize("unknown", size);
    }

    public static String getSiteTitle(Principal p, Integer size) {
        int siteID = -1;
        siteID = p instanceof JahiaUser ? 0 : ((JahiaGroup)p).getSiteID();
        if (siteID == 0) {
            return PrincipalViewHelper.adjustStringSize("server", size);
        }
        if (siteID > 0) {
            try {
                JahiaSite jahiaSite = ServicesRegistry.getInstance().getJahiaSitesService().getSite(siteID);
                if (jahiaSite != null) {
                    return PrincipalViewHelper.adjustStringSize(jahiaSite.getTitle(), size);
                }
            }
            catch (JahiaException je) {
                logger.error("Error while retrieving site id=" + siteID, (Throwable)je);
            }
        }
        return PrincipalViewHelper.adjustStringSize("unknown", size);
    }

    public static String getPrincipal(Principal p, Integer size) {
        return PrincipalViewHelper.getPrincipalType(p) == 'u' ? "u" : "g";
    }

    public static char getPrincipalType(Principal p) {
        if (p instanceof JahiaUser) {
            return 'u';
        }
        return 'g';
    }

    public static String getProperties(Principal p, Integer size) {
        StringBuilder properties = new StringBuilder();
        if (p instanceof JahiaUser) {
            String email;
            JahiaUser user = (JahiaUser)p;
            if (user.getUsername().equals("guest")) {
                properties.append(PrincipalViewHelper.getI18n("org.jahia.engines.users.guest.label", "guest"));
                return PrincipalViewHelper.adjustStringSize(properties.toString(), size);
            }
            String firstname = user.getProperty("j:firstName");
            String lastname = user.getProperty("j:lastName");
            if (lastname != null && !"".equals(lastname.trim())) {
                properties.append(lastname);
                if (size == -1 || lastname.length() < size) {
                    properties.append(" ");
                }
            }
            if (firstname != null && !"".equals(firstname.trim())) {
                properties.append(firstname);
            }
            if ("".equals(properties.toString()) && (email = user.getProperty("j:email")) != null) {
                properties.append(email);
            }
            return PrincipalViewHelper.adjustStringSize(properties.toString(), size);
        }
        if (p instanceof UsersGroup) {
            properties.append(PrincipalViewHelper.getI18n("org.jahia.engines.groups.users.label", "users"));
            return PrincipalViewHelper.adjustStringSize(properties.toString(), size);
        }
        if (p instanceof GuestGroup) {
            properties.append(PrincipalViewHelper.getI18n("org.jahia.engines.groups.guest.label", "guest"));
            return PrincipalViewHelper.adjustStringSize(properties.toString(), size);
        }
        JahiaGroup group = (JahiaGroup)p;
        EnumerationIterator grpMembers = group.isPreloadedGroups() ? new EnumerationIterator(group.members()) : null;
        StringBuilder members = new StringBuilder().append("(");
        if (grpMembers != null) {
            while (grpMembers.hasNext()) {
                Object obj = grpMembers.next();
                members.append(PrincipalViewHelper.getDisplayName((Principal)obj));
                if (size == -1 || members.length() <= size) {
                    if (!grpMembers.hasNext()) continue;
                    members.append(", ");
                    continue;
                }
                break;
            }
        } else {
            members.append("...");
        }
        members.append(")");
        return PrincipalViewHelper.adjustStringSize(members.toString(), size);
    }

    public String getPermissions(Principal p, Integer size) {
        int i;
        if (size == -1) {
            size = 3;
        }
        Integer permissions = this.perms.get(p)[0];
        StringBuilder permStr = new StringBuilder();
        boolean inherited = (permissions >> 3 & 1) != 0;
        boolean linked = (permissions >> 4 & 1) != 0;
        char[] perms = new char[]{'R', 'W', 'A'};
        for (i = 0; i < size; ++i) {
            permStr.append((permissions >> i & 1) != 0 ? Character.valueOf(perms[i]) : "-");
        }
        for (i = size.intValue(); i < 3; ++i) {
            permStr.append(" ");
        }
        if (linked) {
            permStr.append("+");
        } else if (inherited) {
            permStr.append("*");
        } else {
            permStr.append("&nbsp;");
        }
        return permStr.toString();
    }

    public void setPermissions(Map<Principal, Integer[]> perms) {
        this.perms = perms;
    }

    public String getInheritance(Principal p, Integer size) {
        if (this.inheritance.contains(p)) {
            return "*&nbsp;";
        }
        return "&nbsp;&nbsp;";
    }

    public void setInheritance(Set<Principal> inheritance) {
        this.inheritance = inheritance;
    }

    public static Set<Principal> getSearchResult(ServletRequest request) {
        String searchString = request.getParameter("searchString");
        String searchIn = request.getParameter("searchIn");
        String[] searchInProps = request.getParameterValues("properties");
        String storedOn = request.getParameter("storedOn");
        String[] providers = request.getParameterValues("providers");
        return PrincipalViewHelper.getSearchResult(searchIn, searchString, searchInProps, storedOn, providers);
    }

    public static Set<Principal> getSearchResult(String searchIn, String searchString, String[] searchInProps, String storedOn, String[] providers) {
        JahiaUserManagerService jahiaUserManagerService = ServicesRegistry.getInstance().getJahiaUserManagerService();
        Properties searchParameters = new Properties();
        TreeSet<Principal> searchResults = new TreeSet<Principal>(PRINCIPAL_COMPARATOR);
        long countLimit = SettingsBean.getInstance().getJahiaJCRUserCountLimit();
        if (countLimit > 0L) {
            logger.info("Just first {} users are returned from Jahia JCR repository...", (Object)countLimit);
            searchParameters.setProperty("countLimit", String.valueOf(countLimit));
        }
        if (searchIn == null) {
            logger.debug("No formular transmited. Finding all Jahia DB users.");
            searchParameters.setProperty("*", "*");
            searchResults.addAll(jahiaUserManagerService.searchUsers(searchParameters));
        } else {
            if ("".equals(searchString)) {
                searchString = "*";
            }
            if ("allProps".equals(searchIn) || searchInProps == null) {
                searchParameters.setProperty("*", searchString);
            } else {
                for (String searchInProp : searchInProps) {
                    searchParameters.setProperty(searchInProp, searchString);
                }
            }
            if ("everywhere".equals(storedOn) || providers == null) {
                searchResults.addAll(jahiaUserManagerService.searchUsers(searchParameters));
            } else {
                for (String curServer : providers) {
                    Set<Principal> curSearchResults = jahiaUserManagerService.searchUsers(curServer, searchParameters);
                    if (curSearchResults == null) continue;
                    searchResults.addAll(curSearchResults);
                }
            }
        }
        return searchResults;
    }

    public static Set<Principal> getGroupSearchResult(ServletRequest request, int siteID) {
        String searchString = request.getParameter("searchString");
        String searchIn = request.getParameter("searchIn");
        String[] searchInProps = request.getParameterValues("properties");
        String storedOn = request.getParameter("storedOn");
        String[] providers = request.getParameterValues("providers");
        return PrincipalViewHelper.getGroupSearchResult(searchIn, siteID, searchString, searchInProps, storedOn, providers);
    }

    public static Set<Principal> getGroupSearchResult(String searchIn, int siteID, String searchString, String[] searchInProps, String storedOn, String[] providers) {
        JahiaGroupManagerService jahiaGroupManagerService = ServicesRegistry.getInstance().getJahiaGroupManagerService();
        Properties searchParameters = new Properties();
        TreeSet<Principal> searchResults = new TreeSet<Principal>(PRINCIPAL_COMPARATOR);
        if (searchIn == null) {
            logger.debug("No formular transmited. Finding all Jahia DB users.");
            searchParameters.setProperty("*", "*");
            searchResults.addAll(jahiaGroupManagerService.searchGroups(siteID, searchParameters));
        } else {
            int i;
            if ("".equals(searchString)) {
                searchString = "*";
            }
            if ("allProps".equals(searchIn) || searchInProps == null) {
                searchParameters.setProperty("*", searchString);
            } else {
                for (i = 0; i < searchInProps.length; ++i) {
                    searchParameters.setProperty(searchInProps[i], searchString);
                }
            }
            if ("everywhere".equals(storedOn) || providers == null) {
                searchResults.addAll(jahiaGroupManagerService.searchGroups(siteID, searchParameters));
            } else {
                for (i = 0; i < providers.length; ++i) {
                    String curServer = providers[i];
                    Set<JahiaGroup> curSearchResults = jahiaGroupManagerService.searchGroups(curServer, siteID, searchParameters);
                    if (curSearchResults == null) continue;
                    searchResults.addAll(curSearchResults);
                }
            }
        }
        return searchResults;
    }

    public static Set<Principal> removeJahiaAdministrators(Set<Principal> users) {
        TreeSet<Principal> usersWithoutJahiaAdmin = new TreeSet<Principal>(PRINCIPAL_COMPARATOR);
        usersWithoutJahiaAdmin.addAll(users);
        JahiaGroup jahiaAdminGroup = ServicesRegistry.getInstance().getJahiaGroupManagerService().getAdministratorGroup(null);
        EnumerationIterator memberEnum = new EnumerationIterator(jahiaAdminGroup.members());
        while (memberEnum.hasNext()) {
            Object curMemberObject = memberEnum.next();
            if (!(curMemberObject instanceof JahiaUser)) continue;
            usersWithoutJahiaAdmin.remove(curMemberObject);
        }
        return usersWithoutJahiaAdmin;
    }

    public static Set<JahiaGroup> getUserGroupMembership(JahiaUser usr, int site) {
        HashSet<JahiaGroup> groups = new HashSet<JahiaGroup>();
        JahiaGroupManagerService jahiaGroupManagerService = ServicesRegistry.getInstance().getJahiaGroupManagerService();
        List<String> v = jahiaGroupManagerService.getUserMembership(usr);
        for (String gname : v) {
            JahiaGroup g = jahiaGroupManagerService.lookupGroup(gname);
            if (g == null || g.getSiteID() != site && g.getSiteID() != 0) continue;
            groups.add(g);
        }
        return groups;
    }

    private static String getI18n(String key, String defaultValue) {
        Locale locale = PrincipalViewHelper.getLocale();
        return Messages.getInternal(key, locale, defaultValue);
    }

    private static Locale getLocale() {
        Locale locale = JCRSessionFactory.getInstance().getCurrentLocale();
        if (locale == null) {
            locale = SettingsBean.getInstance().getDefaultLocale();
        }
        if (locale == null) {
            locale = Locale.ENGLISH;
        }
        return locale;
    }

    private static String adjustStringSize(String str, int size) {
        if (size == -1 || str == null) {
            return str;
        }
        if (str.length() > size) {
            return str.substring(0, size - 2) + "..";
        }
        StringBuilder emtpyStr = new StringBuilder();
        for (int i = 0; i < size - str.length(); ++i) {
            emtpyStr.append(" ");
        }
        return str + emtpyStr;
    }

    static {
        selectBoxFieldsHeading.add(PRINCIPAL);
        selectBoxFieldsHeading.add(PERMISSIONS);
        selectBoxFieldsHeading.add(PROVIDER);
        selectBoxFieldsHeading.add(SITEID);
        selectBoxFieldsHeading.add(SITEKEY);
        selectBoxFieldsHeading.add(SITETITLE);
        selectBoxFieldsHeading.add(NAME);
        selectBoxFieldsHeading.add(PROPERTIES);
        selectBoxFieldsHeading.add(INHERITANCE);
    }

    private static class PrincipalComparator
    implements Comparator<Principal>,
    Serializable {
        private static final long serialVersionUID = 7942666955260548143L;

        private PrincipalComparator() {
        }

        @Override
        public int compare(Principal o1, Principal o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null || o1.getName() == null) {
                return 1;
            }
            if (o2 == null || o2.getName() == null) {
                return -1;
            }
            return o1.getName().compareTo(o2.getName());
        }
    }
}

