/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.engines;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.PageContext;
import org.jahia.engines.EngineMessage;

public class EngineMessages {
    public static final String GLOBAL_MESSAGE = "org.jahia.engines.global_message";
    public static final String CONTEXT_KEY = "engineMessages";
    Map<String, List<EngineMessage>> messages = new HashMap<String, List<EngineMessage>>();

    public void add(EngineMessage message) {
        this.add(GLOBAL_MESSAGE, message);
    }

    public void add(String property, EngineMessage message) {
        List<EngineMessage> propertyList = this.messages.get(property);
        if (propertyList == null) {
            propertyList = new ArrayList<EngineMessage>();
        }
        propertyList.add(message);
        this.messages.put(property, propertyList);
    }

    public Set<String> getProperties() {
        return this.messages.keySet();
    }

    public Set<Map.Entry<String, List<EngineMessage>>> getEntrySet() {
        return this.messages.entrySet();
    }

    public int getSize() {
        Iterator<String> propertyIter = this.getProperties().iterator();
        int size = 0;
        while (propertyIter.hasNext()) {
            String curPropertyName = propertyIter.next();
            List<EngineMessage> curPropertyList = this.messages.get(curPropertyName);
            size += curPropertyList.size();
        }
        return size;
    }

    public List<EngineMessage> getMessages() {
        ArrayList<EngineMessage> fullList = new ArrayList<EngineMessage>();
        for (String curPropertyName : this.getProperties()) {
            List<EngineMessage> curPropertyList = this.messages.get(curPropertyName);
            fullList.addAll(curPropertyList);
        }
        return fullList;
    }

    public List<EngineMessage> getMessages(String property) {
        return this.messages.get(property);
    }

    public int getSize(String property) {
        List<EngineMessage> propertyList = this.messages.get(property);
        if (propertyList != null) {
            return propertyList.size();
        }
        return 0;
    }

    public boolean isEmpty() {
        return this.messages.isEmpty();
    }

    public void saveMessages(ServletRequest request) {
        request.setAttribute(CONTEXT_KEY, (Object)this);
    }

    public void saveMessages(String contextPrefix, ServletRequest request) {
        request.setAttribute(contextPrefix + CONTEXT_KEY, (Object)this);
    }

    public void saveMessages(PageContext pageContext) {
        pageContext.setAttribute(CONTEXT_KEY, (Object)this);
    }

    public void saveMessages(PageContext pageContext, int scope) {
        pageContext.setAttribute(CONTEXT_KEY, (Object)this, scope);
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("org.jahia.engines.EngineMessages : ");
        buff.append(this.messages);
        return buff.toString();
    }
}

