/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.exceptions;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaException
extends Exception {
    private static Logger logger = LoggerFactory.getLogger(JahiaException.class);
    private static final long serialVersionUID = -1837958722110615030L;
    public static final int WARNING_SEVERITY = 1;
    public static final int ERROR_SEVERITY = 2;
    public static final int CRITICAL_SEVERITY = 3;
    public static final int FATAL_SEVERITY = 4;
    public static final int INITIALIZATION_ERROR = 0;
    public static final int DATABASE_ERROR = 1;
    public static final int FILE_ERROR = 2;
    public static final int DATA_ERROR = 3;
    public static final int TEMPLATE_ERROR = 4;
    public static final int PERSISTENCE_ERROR = 5;
    public static final int USER_ERROR = 5;
    public static final int PAGE_ERROR = 6;
    public static final int WINDOW_ERROR = 7;
    public static final int PARAMETER_ERROR = 8;
    public static final int APPLICATION_ERROR = 9;
    public static final int NEWSFEED_ERROR = 10;
    public static final int CONFIG_ERROR = 11;
    public static final int SERVICE_ERROR = 12;
    public static final int REGISTRY_ERROR = 13;
    public static final int SERVLET_ERROR = 14;
    public static final int LISTENER_ERROR = 15;
    public static final int SECURITY_ERROR = 16;
    public static final int ACL_ERROR = 17;
    public static final int CACHE_ERROR = 18;
    public static final int OBJECT_ERROR = 19;
    public static final int ENGINE_ERROR = 20;
    public static final int LOCK_ERROR = 21;
    public static final int SESSION_ERROR = 22;
    protected static final int ACCOUNTS_ERROR = 23;
    protected static final int LICENSE_ERROR = 24;
    public static final int JEF_ERROR = 25;
    public static final int JAVASECURITY_ERROR = 26;
    public static final int ENGINE_VALIDATION_ERROR = 27;
    public static final int UNAVAILABLE_ERROR = 28;
    public static final int ENTRY_NOT_FOUND = 30;
    public static final int SITE_NOT_FOUND = 40;
    public static final int TEMPLATE_SERVICE_ERROR = 50;
    protected String mUserErrorMsg;
    protected String mJahiaErrorMsg;
    protected int mErrorCode;
    protected int mErrorSeverity;
    private int responseErrorCode = 500;

    public JahiaException(String userErrorMsg, String jahiaErrorMsg, int errorCode, int errorSeverity) {
        super("User message=" + userErrorMsg + ", System message=" + jahiaErrorMsg);
        this.mUserErrorMsg = userErrorMsg;
        this.mJahiaErrorMsg = jahiaErrorMsg;
        this.mErrorCode = errorCode;
        this.mErrorSeverity = errorSeverity;
    }

    public JahiaException(String userErrorMsg, String jahiaErrorMsg, int errorCode, int errorSeverity, Throwable t) {
        super("User message=" + userErrorMsg + ", System message=" + jahiaErrorMsg + ", root cause:" + (t == null ? "null" : t.getMessage()), t);
        this.mUserErrorMsg = userErrorMsg;
        this.mJahiaErrorMsg = jahiaErrorMsg;
        this.mErrorCode = errorCode;
        this.mErrorSeverity = errorSeverity;
    }

    public int getSeverity() {
        return this.mErrorSeverity;
    }

    public final String getUserErrorMsg() {
        return this.mUserErrorMsg;
    }

    public final String getJahiaErrorMsg() {
        return this.mJahiaErrorMsg;
    }

    public final int getErrorCode() {
        return this.mErrorCode;
    }

    public final Throwable getRootCause() {
        return this.getCause();
    }

    @Override
    public String toString() {
        logger.debug("called.");
        StringBuffer result = new StringBuffer();
        result.append(super.toString());
        if (this.getRootCause() != null) {
            result.append(" root cause=");
            result.append(this.getRootCause().toString());
        }
        return result.toString();
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        logger.debug("(PrintWriter s) called.");
        super.printStackTrace(s);
        if (this.getRootCause() != null) {
            this.getRootCause().printStackTrace(s);
        }
    }

    @Override
    public void printStackTrace(PrintStream s) {
        logger.debug("(PrintStream s) called.");
        super.printStackTrace(s);
        if (this.getRootCause() != null) {
            this.getRootCause().printStackTrace(s);
        }
    }

    @Override
    public void printStackTrace() {
        logger.debug("() called.");
        super.printStackTrace();
        if (this.getRootCause() != null) {
            this.getRootCause().printStackTrace();
        }
    }

    public int getResponseErrorCode() {
        return this.responseErrorCode;
    }
}

