/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.hibernate.cache.ehcache;

import java.util.Properties;
import net.sf.ehcache.CacheManager;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.ehcache.EhCacheRegionFactory;
import org.hibernate.cfg.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharingEhcacheRegionFactory
extends EhCacheRegionFactory {
    private static final String EXISTING_CACHE_MANAGER_NAME = "org.jahia.hibernate.ehcache.existingCacheManagerName";
    private static final Logger LOG = LoggerFactory.getLogger((String)SharingEhcacheRegionFactory.class.getName());
    private static final long serialVersionUID = 827915208448076343L;

    public void start(Settings settings, Properties properties) throws CacheException {
        if (this.manager != null) {
            LOG.warn("Attempt to restart an already started EhCacheProvider. Use sessionFactory.close()  between repeated calls to buildSessionFactory. Using previously created EhCacheProvider. If this behaviour is required, consider using SingletonEhCacheProvider.");
            return;
        }
        try {
            String existingCacheManagerName = null;
            if (properties != null) {
                existingCacheManagerName = (String)properties.get(EXISTING_CACHE_MANAGER_NAME);
            }
            if (existingCacheManagerName == null || existingCacheManagerName.length() == 0) {
                throw new CacheException("No existing cache manager name specified in configuration, property org.jahia.hibernate.ehcache.existingCacheManagerName was not set properly.");
            }
            this.manager = CacheManager.getCacheManager((String)existingCacheManagerName);
        }
        catch (net.sf.ehcache.CacheException e) {
            if (e.getMessage().startsWith("Cannot parseConfiguration CacheManager. Attempt to create a new instance of CacheManager using the diskStorePath")) {
                throw new CacheException("Attempt to restart an already started EhCacheProvider. Use sessionFactory.close()  between repeated calls to buildSessionFactory. Consider using SingletonEhCacheProvider. Error from  ehcache was: " + e.getMessage());
            }
            throw e;
        }
    }

    public void stop() {
    }
}

