/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.osgi;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleDelegatingClassLoader
extends ClassLoader
implements BundleReference {
    private static final Logger log = LoggerFactory.getLogger(BundleDelegatingClassLoader.class);
    private final ClassLoader bridge;
    private final Bundle backingBundle;

    public static BundleDelegatingClassLoader createBundleClassLoaderFor(Bundle aBundle) {
        return BundleDelegatingClassLoader.createBundleClassLoaderFor(aBundle, null);
    }

    public static BundleDelegatingClassLoader createBundleClassLoaderFor(final Bundle bundle, final ClassLoader bridge) {
        return (BundleDelegatingClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new BundleDelegatingClassLoader(bundle, bridge);
            }
        });
    }

    protected BundleDelegatingClassLoader(Bundle bundle, ClassLoader bridgeLoader) {
        super(null);
        this.backingBundle = bundle;
        this.bridge = bridgeLoader;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        try {
            return this.backingBundle.loadClass(name);
        }
        catch (ClassNotFoundException cnfe) {
            throw new ClassNotFoundException(name + " not found from bundle [" + this.backingBundle.getSymbolicName() + "]", cnfe);
        }
        catch (NoClassDefFoundError ncdfe) {
            String cname = ncdfe.getMessage().replace('/', '.');
            NoClassDefFoundError e = new NoClassDefFoundError(cname + " not found from bundle [" + this.backingBundle + "]");
            e.initCause(ncdfe);
            throw e;
        }
    }

    @Override
    protected URL findResource(String name) {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace("Looking for resource " + name);
        }
        URL url = this.backingBundle.getResource(name);
        if (trace && url != null) {
            log.trace("Found resource " + name + " at " + url);
        }
        return url;
    }

    protected Enumeration findResources(String name) throws IOException {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace("Looking for resources " + name);
        }
        Enumeration enm = this.backingBundle.getResources(name);
        if (trace && enm != null && enm.hasMoreElements()) {
            log.trace("Found resource " + name + " at " + this.backingBundle.getLocation());
        }
        return enm;
    }

    @Override
    public URL getResource(String name) {
        URL resource = this.findResource(name);
        if (this.bridge != null && resource == null) {
            resource = this.bridge.getResource(name);
        }
        return resource;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> enm = this.findResources(name);
        if (this.bridge != null && enm == null) {
            enm = this.bridge.getResources(name);
        }
        return enm;
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = null;
        try {
            clazz = this.findClass(name);
        }
        catch (ClassNotFoundException cnfe) {
            if (this.bridge != null) {
                clazz = this.bridge.loadClass(name);
            }
            throw cnfe;
        }
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    public String toString() {
        return "BundleDelegatingClassLoader for [" + this.backingBundle + "]";
    }

    public Bundle getBundle() {
        return this.backingBundle;
    }
}

