/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.osgi;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.apache.felix.framework.Felix;
import org.jahia.osgi.ProvisionActivator;
import org.jahia.services.SpringContextSingleton;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.PropertyPlaceholderHelper;

public class FrameworkService {
    private static final Logger logger = LoggerFactory.getLogger(FrameworkService.class);
    private static FrameworkService instance;
    private final ServletContext context;
    private Felix felix;
    private ProvisionActivator provisionActivator = null;
    private boolean started;

    public FrameworkService(ServletContext context) {
        this.context = context;
        instance = this;
    }

    public void start() throws BundleException {
        Felix tmp = new Felix(this.createConfig());
        tmp.start();
        this.felix = tmp;
    }

    public void stop() throws BundleException {
        this.provisionActivator = null;
        if (this.felix != null) {
            FrameworkEvent stopEvent = null;
            this.felix.stop();
            logger.info("Waiting for OSGi framework shutdown...");
            try {
                stopEvent = this.felix.waitForStop(30000L);
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            logger.info("Framework stopped with event {}", (Object)stopEvent.getType());
        }
        logger.info("OSGi framework stopped");
    }

    public ProvisionActivator getProvisionActivator() {
        return this.provisionActivator;
    }

    private Map<String, Object> createConfig() {
        Map unreplaced = (Map)SpringContextSingleton.getBean("felixProperties");
        PropertyPlaceholderHelper placeholderHelper = new PropertyPlaceholderHelper("${", "}");
        Properties systemProps = System.getProperties();
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry entry : unreplaced.entrySet()) {
            map.put((String)entry.getKey(), placeholderHelper.replacePlaceholders((String)entry.getValue(), systemProps));
        }
        String value = (String)map.get("gosh.args");
        if (value != null && value.contains("--port=-1")) {
            map.put("gosh.args", "--nointeractive");
        }
        map.put("org.jahia.servlet.context", this.context);
        this.provisionActivator = new ProvisionActivator(this.context);
        map.put("felix.systembundle.activators", Arrays.asList(this.provisionActivator));
        return map;
    }

    public boolean isStarted() {
        return this.started;
    }

    public static BundleContext getBundleContext() {
        if (instance != null && FrameworkService.instance.felix != null) {
            return FrameworkService.instance.felix.getBundleContext();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyStarted() {
        logger.info("Got started event");
        if (instance != null) {
            FrameworkService frameworkService = instance;
            synchronized (frameworkService) {
                logger.info("Started event arrived");
                FrameworkService.instance.started = true;
                instance.notifyAll();
                logger.info("Notified all about framework started event");
            }
        }
    }

    public static FrameworkService getInstance() {
        return instance;
    }
}

